/*
 * dia_SrvHandler_ReadCDCountInsert.h
 *
 *  Created on: Jan 27, 2017
 *      Author: mky6kor
 */
#ifndef DIA_SRVHANDLER_READCDCOUNTINSERT_H_
#define DIA_SRVHANDLER_READCDCOUNTINSERT_H_

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DEVICEMGR_LISTENER__
#include "common/interfaces/dia_IDeviceMGRListener.h"
#endif

class dia_SrvHandler_ReadCDCountInsert
:public dia_ServiceHandlerUDS,
 public dia_IDeviceMGRListenerImpl{

	DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_ReadCDCountInsert);
public:
	//!class constructor
	dia_SrvHandler_ReadCDCountInsert();
	/**
	  * \brief    	handle the received request
	  *
	  *				Function receives the message via the oDiagMsgBuffer and send it to the SA.
      *				The SystemAdapter returns the number of CD inserted.
	  */
	 virtual tVoid vProcessRequest ( const std::vector<tVoid*>& /*vecArgs*/ );

	 /**
	   * \brief    	status for the requested CD Insert Count Value
	   *
	   *				Function receives the message via its parameter and send it to the tester.
	   *				It verifies the SA answer and send the number of CD inserted to the tester.
	   */

	   virtual tVoid vOnGetCDInsertCount ( tU8 icounter );
protected:
	//!class destructor
	virtual ~dia_SrvHandler_ReadCDCountInsert();

};


#endif /* DIA_SRVHANDLER_READCDCOUNTINSERT_H_ */
