/*
 * dia_SrvHandler_ReadCDCountInsert.cpp
 *
 *  Created on: Jan 27, 2017
 *      Author: mky6kor
 */

#include "dia_SrvHandler_ReadCDCountInsert.h"
#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif


#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DEVICEMGR_LISTENER__
#include "common/interfaces/dia_IDeviceMGRListener.h"
#endif

#define DATA_START 3
#define DATA_LENGTH 1

dia_SrvHandler_ReadCDCountInsert::dia_SrvHandler_ReadCDCountInsert(tVoid):
dia_ServiceHandlerUDS("dia_SrvHandler_ReadCDCountInsert", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_CD_INSERT_COUNT /*DID*/)
{
	// TODO Auto-generated constructor stub
	dia_tclFnctTrace trc("dia_SrvHandler_ReadCDCountInsert::dia_SrvHandler_ReadCDCountInsert(tVoid)");
}

dia_SrvHandler_ReadCDCountInsert::~dia_SrvHandler_ReadCDCountInsert(tVoid) {
	// TODO Auto-generated destructor stub

	   _BP_TRY_BEGIN
	   {
	      (tVoid) unsetSysAdapterListener<dia_IDeviceMGRListener>(this);
	   }
	   _BP_CATCH_ALL
	   {
	      DIA_TR_ERR("EXCEPTION CAUGHT:  dia_SrvHandler_ReadCDCountInsert::~dia_SrvHandler_ReadCDCountInsert!!!");
	      NORMAL_M_ASSERT_ALWAYS();
	   }
	_BP_CATCH_END
}
tVoid dia_SrvHandler_ReadCDCountInsert::vProcessRequest(const std::vector<tVoid*>& /*vecArgs*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadCDCountInsert::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_IDeviceMGR*  pDeviceMGR= 0;
   if (querySysAdapterInterface<dia_IDeviceMGR>(&pDeviceMGR) == DIA_SUCCESS) {
      if (pDeviceMGR) {
         (tVoid) setSysAdapterListener<dia_IDeviceMGRListener>(this);
         if (pDeviceMGR->getDevicesValues() == DIA_SUCCESS) {
            errorDetected = FALSE;
         }
      }
   }

   if (errorDetected) {
      (tVoid) unsetSysAdapterListener<dia_IDeviceMGRListener>(this);
      DIA_TR_ERR("dia_SrvHandler_ReadCDCountInsert ---  SEND TO DEVICE_MANAGER SA FEATURE FAILED!!!!");
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }
}

void dia_SrvHandler_ReadCDCountInsert::vOnGetCDInsertCount( tU8 icounter )
{

   dia_tclFnctTrace trc( "dia_SrvHandler_ReadCDCountInsert::vOnGetCDInsertCount" );
   DIA_TR_INF( "dia_SrvHandler_ReadCDCountInsert::dia_SrvHandler_ReadCDCountInsert- CD Count from SA = %d", icounter );
   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

   (void) oDiagMsgBuffer().vSetDataU8 (DATA_START + 0,icounter);
   (void) unsetSysAdapterListener<dia_IDeviceMGRListener>(this);

      vResReadyAndQuit();
      DIA_TR_INF( "dia_SrvHandler_ReadCDCountInsert::vOnGetCDInsertCount SUCCESSFUL" );
}
