/*
 * dia_SrvHandler_ReadBatteryLevel.cpp
 *
 *  Created on: 10.01.2014
 *      Author: nce5kor
 */
// TTFis: DIA_REQ UDS 04 22 02 00

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef DIA_SRVHANDLER_READ_BATTERYLEVEL_H_
#include "project/services/customer/dia_SrvHandler_ReadBatteryLevel.h"
#endif

#define DATA_START 3
#define DATA_LENGTH 1

//-----------------------------------------------------------------------------

dia_SrvHandler_ReadBatteryLevel::dia_SrvHandler_ReadBatteryLevel(void) :
      dia_ServiceHandlerUDS("dia_SrvHandler_ReadBatteryLevel", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_BATTERY_LEVEL)
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadBatteryLevel::dia_SrvHandler_ReadBatteryLevel(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_ReadBatteryLevel::~dia_SrvHandler_ReadBatteryLevel(void)
{
   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_ISpmListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_ReadBatteryLevel::~dia_SrvHandler_ReadBatteryLevel !!!");
      NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END}

//-------------------------------------------------------------------------------

tVoid dia_SrvHandler_ReadBatteryLevel::vProcessRequest(const std::vector<void*>& /*vecArgs*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadBatteryLevel::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_ISpm* pSpm = 0;
   if (querySysAdapterInterface<dia_ISpm>(&pSpm) == DIA_SUCCESS)
   {
      if (pSpm)
      {
         (tVoid) setSysAdapterListener<dia_ISpmListener>(this);
         if (pSpm->getBatteryVoltage() == DIA_SUCCESS)
         {
            errorDetected = FALSE;
         }
      }
   }

   if (errorDetected) {
      (tVoid) unsetSysAdapterListener<dia_ISpmListener>(this);
      DIA_TR_ERR("dia_SrvHandler_ReadBatteryLevel ---  SEND TO SPM SA FEATURE FAILED!!!!");
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }
}
//-------------------------------------------------------------------------------
void dia_SrvHandler_ReadBatteryLevel::vOnGetBatteryVoltage (tU16 voltage)
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadBatteryLevel::vOnGetPowerSupply");

   DIA_TR_INF("dia_SrvHandler_ReadBatteryLevel::vOnGetPowerSupply voltage=%d", voltage);

   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

   float fVoltage = ((float)voltage / (float)200.0f) + 0.5f; // / 1000 / 0.2

   tU8 u8Voltage = (tU8) fVoltage;
   DIA_TR_INF("dia_SrvHandler_ReadBatteryLevel::vOnGetPowerSupply u8Voltage=%d", u8Voltage);

   // Sending back the positive answer
   (void) oDiagMsgBuffer().vSetDataU8 (DATA_START, u8Voltage);

   (void) unsetSysAdapterListener<dia_ISpmListener>(this);
   vResReadyAndQuit();
}
