/*****************************************************************************************
*
* \file    dia_SrvHandler_ReadBTSubModuleSWVersion.cpp
*
* \brief   Service Handler for Read BT Submodule SW Version
*
* \author  stc2hi
*
* \date    23.09.2016
*
* (c) 2014 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __DIA_SRVHANDLER_READBTSUBMODULESWVERSION_H__
#include "project/services/customer/dia_SrvHandler_ReadBTSubModuleSWVersion.h"
#endif

#define DATA_START  3
#define DATA_LENGTH 10


/******************************************************************************
* FUNCTION:    dia_SrvHandler_ReadBTSubModuleSWVersion
*
* DESCRIPTION: Constructor
*
******************************************************************************/

dia_SrvHandler_ReadBTSubModuleSWVersion::dia_SrvHandler_ReadBTSubModuleSWVersion ( void )
   : dia_ServiceHandlerUDS("dia_SrvHandler_ReadBTSubModuleSWVersion",
         DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,
         DIA_C_U16_DID_RBCM_BT_SUBMODULE_SW_VERSION)
{
   dia_tclFnctTrace oTrace("dia_SrvHandler_ReadBTSubModuleSWVersion::dia_SrvHandler_ReadBTSubModuleSWVersion()");
}

/******************************************************************************
* FUNCTION:    ~dia_SrvHandler_ReadBTSubModuleSWVersion
*
* DESCRIPTION: Destructor
*
******************************************************************************/
dia_SrvHandler_ReadBTSubModuleSWVersion::~dia_SrvHandler_ReadBTSubModuleSWVersion ( void )
{
}

/******************************************************************************
* FUNCTION:    vProcessRequest
*
* DESCRIPTION: This function receives request from tester.
			   Data is analyzed and prepared for diagnosis-internal communication
*
* PARAMETER:   const std::vector<void*> - list of input params
*
* RETURNVALUE: void
*
******************************************************************************/

void
dia_SrvHandler_ReadBTSubModuleSWVersion::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadBTSubModuleSWVersion::vProcessRequest");

   // data memory
   std::vector<tU8> dataVec;
   tU32 propID = DIA_PROP_VERSION_SW_BLUETOOTH;

   // retrieve size of property
   tU16 i, length = dia_getPropertySize(propID);
   dataVec.reserve(length);
   dataVec.resize(length);

   tDiaResult retCode = dia_getProperty(propID, dataVec);
   if ( retCode == DIA_SUCCESS )
   {
      length = (tU16) strlen((char*) dataVec.data());
      if (length > DATA_LENGTH)
      {
         DIA_TR_ERR("dia_SrvHandler_ReadBTSubModuleSWVersion::vOnProcessRequest - length %d truncated to %d.", length, DATA_LENGTH);
         length = DATA_LENGTH;
      }

      // Sending back the positive answer
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

      for (i = 0; i < length; i++)
      {
         (void) oDiagMsgBuffer().vSetDataU8(DATA_START+i, dataVec[i]);
      }
      for (; i < DATA_LENGTH; i++)
      {
         (void) oDiagMsgBuffer().vSetDataU8(DATA_START+i, ' ');
      }

      vResReadyAndQuit();
   }
   else
   {
      DIA_TR_ERR("dia_SrvHandler_ReadBTSubModuleSWVersion::vOnProcessRequest UNABLE TO READ ITEM (READ OPERATION FAILED) !!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

