 /**
 * \file        dia_SrvHandler_MercedesTruckSoftware.h
 *
 * \brief       {insert brief description here}
 *
 * \details     {insert file description here}
 *
 * \author      ama8kor
 * \date        April 09, 2019
 *
 * \copyright   Robert Bosch Car Multimedia 2019
 */

#ifndef __DIA_SRV_HANDLER_MERCEDES_TRUCK_SOFTWARE_H__
#define __DIA_SRV_HANDLER_MERCEDES_TRUCK_SOFTWARE_H__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

namespace tinyxml2 
{
	class XMLElement;
	class XMLNode;
}
using namespace tinyxml2;
namespace dia {

/**
 * \class   dia_SrvHandler_MercedesTruckSoftware
 *
 * \brief   service handler to process read aoftware part number request
 *
 * \ingroup diaServicesproj
 */
class dia_SrvHandler_MercedesTruckSoftware
   : public dia_ServiceHandlerUDS
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_MercedesTruckSoftware);

public:
   /**
    *
    * \brief      class constructor
    *
    *             class constructor with name, service identifier and 1 byte
    *             data identifier
    *
    * \param[in]  name     name used to distinguish between multiple instances
    * \param[in]  sid      diagnostic service identifier (e.g. 0x22)
    * \param[in]  did      diagnostic data identifier (1 byte)
    *
    * \return     none
    */
   dia_SrvHandler_MercedesTruckSoftware(tCString name, tU8 sid, tU16 did);

   /**
    *
    * \brief      class destructor
    *
    *             class destructor
    */
   virtual ~dia_SrvHandler_MercedesTruckSoftware(void);
   /**
    *
    * \brief      method called to start service processing
    *
    *             This method is used to start processing of a received diagnosis
    *             request. The additional parameters are parameters provided by
    *             the service handler itself during creation of its lookup key. The
    *             lookup key and up to two parameters are stored in the lookup table
    *             of a service dispatcher that dispatches incoming message to the
    *             associated service handler.
    *
    * \param[in]  vecArgs      request buffer
    *
    * \return     none
    */
   virtual void vProcessRequest ( const std::vector<void*>&  /* vecArgs */);

private:
   /**
    *
    * \brief      method called to parse xml
    *
    *             This method is used to parse the xml file.
    *             
    * \param[in]  file      xml file path
    *
    * \return     none
    */
	virtual void parseXML( const std::string& /* file */ ); 
	/**
    *
    * \brief      method called to parse the node
    *
    *             This method is used to parse the xml node and search the desired target value. 
    *             Once the target is available, the value is extraced and stored in member variable.
    *             
    * \param[in]  node      xml node pointer
    *
    * \return     void
    */
	virtual void recursiveParse(XMLNode* /* node */);
   /**
    *
    * \brief      member variable to store parsed string
    *
    */
	std::string _MercedesTruckSoftwarePartNumber;
   /**
    *
    * \brief      member variable to store parsing result
    *
    */
   tBool _MercedesTruckSoftwarePartNumberFound;
};

} /* namespace dia */

#endif /* __DIA_SRV_HANDLER_MERCEDES_TRUCK_SOFTWARE_H__ */
