/*
 * dia_SrvHandler_KeyPressRotary.cpp
 *
 *  Created on: 05.10.2015
 *      Author: stc2hi
 * 	--------------------------------------------------------------------------------------------------------------------------------------------
 * 	Date 	        Author	           Modification
 * 	1.9.16			dvd5kor			   AIVI-26191 - Changed the mapping according to new Spec (Only one rotary button)
 */
// TTFis:\> DIA_REQ UDS 03 22 03 01

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef DIA_SRVHANDLER_KEY_PRESS_ROTARY_H_
#include "dia_SrvHandler_KeyPressRotary.h"
#endif


#define DATA_START 3
#define DATA_LENGTH 1

//-----------------------------------------------------------------------------

dia_SrvHandler_KeyPressRotary::dia_SrvHandler_KeyPressRotary ( void )
    : dia_ServiceHandlerUDS("dia_SrvHandler_KeyPressRotary",
	  DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,
	  (tU16) DIA_C_U16_DID_AIVI_KEY_PRESS_ROTARY /*DID*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_KeyPressRotary::dia_SrvHandler_KeyPressRotary(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_KeyPressRotary::~dia_SrvHandler_KeyPressRotary ( void )
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_KeyPressRotary::~dia_SrvHandler_KeyPressRotary !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_KeyPressRotary::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_KeyPressRotary::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_IInputHandlingPrj* pInterface = 0;
   if ( querySysAdapterInterface<dia_IInputHandlingPrj>(&pInterface) == DIA_SUCCESS )
   {
   	DIA_TR_INF("dia_SrvHandler_KeyPressRotary::vProcessRequest - querySysAdapterInterface OK");
      if ( pInterface )
      {
      	(void) setSysAdapterListener<dia_IInputHandlingPrjListener>(this);
         if ( pInterface->getEncoderDirStatus () == DIA_SUCCESS )
         {
            errorDetected = FALSE;
         }
		   else
		   {
         	DIA_TR_INF("dia_SrvHandler_KeyPressRotary::vProcessRequest - getEncoderStatus() failed.");
         }
      }
   }
   else
   {
   	  DIA_TR_INF("dia_SrvHandler_KeyPressRotary::vProcessRequest - querySysAdapterInterface NOK !");
   }

   if ( errorDetected )
   {
      (void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
      DIA_TR_ERR(" ---  SEND TO KEYBOARD SERVER FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_KeyPressRotary::vOnEncoderDirStatus ( const std::vector<tS8> vecEncoderStatus )
{
   dia_tclFnctTrace trc("dia_SrvHandler_KeyPressRotary:vOnEncoderDirStatus");

   (void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);

   // Sending back the positive answer
   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

   tU8 u8EncoderBitmap = 0;

   for (tU32 i = 0; i < vecEncoderStatus.size(); i++)
   {
	  #ifdef VARIANT_S_FTR_ENABLE_RIVIE
	  //Only one Rotary button, according to new spec
	  if (i == 6 || i == 8) //Only one rotary button (code can be 6 or 8 for encoder)
	  {
		if (vecEncoderStatus[i] < 0)
		{
			u8EncoderBitmap |= (1 << 7);
			u8EncoderBitmap &= ~(1 << 6);
		}
		else if (vecEncoderStatus[i] > 0)
		{
			u8EncoderBitmap |= (1 << 6);
			u8EncoderBitmap &= ~(1 << 7);
		}
	  }
	  #else 
      if (i == 6) //Left
      {
         if (vecEncoderStatus[i] < 0)
         {
            u8EncoderBitmap |= (1 << 7);
            u8EncoderBitmap &= ~(1 << 6);
         }
         else if (vecEncoderStatus[i] > 0)
         {
            u8EncoderBitmap |= (1 << 6);
            u8EncoderBitmap &= ~(1 << 7);
         }
      }
      if (i == 8) //Right
      {
         if (vecEncoderStatus[i] < 0)
         {
            u8EncoderBitmap |= (1 << 5);
            u8EncoderBitmap &= ~(1 << 4);
         }
         else if (vecEncoderStatus[i] > 0)
         {
            u8EncoderBitmap |= (1 << 4);
            u8EncoderBitmap &= ~(1 << 5);
         }
      }
	  #endif
   }

   (void) oDiagMsgBuffer().vSetDataU8(DATA_START, u8EncoderBitmap);

   vResReadyAndQuit();
}


