/*
 * dia_SrvHandler_KeyPressButtons.cpp
 *
 *  Created on: 05.10.2015
 *      Author: stc2hi
 */
// TTFis:\> DIA_REQ UDS 03 22 03 00

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef DIA_SRVHANDLER_KEY_PRESS_BUTTONS_H_
#include "dia_SrvHandler_KeyPressButtons.h"
#endif


#define DATA_START 3
#define DATA_LENGTH 2
#define DIA_PRJ_SWC_KEY_COUNT 39

// convert DIA key code to a bit position in 2 bytes
static tU16 aKeyCodeBitmap[DIA_PRJ_SWC_KEY_COUNT] =
{
      0, //DIA_PRJ_KEY_CODE_UNKNOWN = 0,
      (1 << 8) | 2, //DIA_PRJ_KEY_CODE_PHONE,
      (0 << 8) | 4, //DIA_PRJ_KEY_CODE_CD,
      (0 << 8) | 8, //DIA_PRJ_KEY_CODE_CAMERA,
      (0 << 8) | 5, //DIA_PRJ_KEY_CODE_AUX,
      (0 << 8) | 6, //DIA_PRJ_KEY_CODE_PREV,
      (0 << 8) | 7, //DIA_PRJ_KEY_CODE_NEXT,
      (0 << 8) | 3, //DIA_PRJ_KEY_CODE_RADIO,
      (1 << 8) | 6, //DIA_PRJ_KEY_CODE_INFO,
      (1 << 8) | 7, //DIA_PRJ_KEY_CODE_SETUP,
      (1 << 8) | 1, //DIA_PRJ_KEY_CODE_MAP,
      (1 << 8) | 5, //DIA_PRJ_KEY_CODE_BACK,
      (1 << 8) | 4, //DIA_PRJ_KEY_CODE_DAY_NIGHT,
      (1 << 8) | 3, //DIA_PRJ_KEY_CODE_NAV,
      (0 << 8) | 2, //DIA_PRJ_KEY_CODE_ENTER (DIA_EN_PRJ_KEY_CODE_RIGHT_ENCODER),
      (1 << 8) | 6, //DIA_PRJ_KEY_CODE_XM,
      (0 << 8) | 3, //DIA_PRJ_KEY_CODE_AM_FM,
      0, //DIA_PRJ_KEY_CODE_MENU,
      (1 << 8) | 7, //DIA_PRJ_KEY_CODE_APP,
      0, //DIA_PRJ_KEY_CODE_AUDIO,
      0, //DIA_PRJ_KEY_CODE_DISP,
      0, //DIA_PRJ_KEY_VIRTUAL_STM,
      (0 << 8) | 1, //DIA_PRJ_KEY_CODE_POWER (DIA_EN_PRJ_KEY_CODE_LEFT_ENCODER),
      (1 << 8) | 8, //DIA_PRJ_KEY_CODE_EJECT,
      (0 << 8) | 6,//DIA_PRJ_SWC_KEY_CODE_MODE
      (0 << 8) | 6,//DIA_PRJ_SWC_KEY_CODE_OK
      0,//DIA_PRJ_SWC_KEY_CODE_SEEK_UP,
      0,//DIA_PRJ_SWC_KEY_CODE_SEEK_DOWN,
      (1 << 8) | 2,//DIA_PRJ_SWC_KEY_CODE_TEL_VR,
      (0 << 8) | 2,//DIA_PRJ_SWC_KEY_CODE_VOL_DOWN,
      (0 << 8) | 1,//DIA_PRJ_SWC_KEY_CODE_VOL_UP,
      (0 << 8) | 7,//DIA_PRJ_SWC_KEY_CODE_TEL_HANG_UP,
      0,//DIA_PRJ_SWC_KEY_CODE_BACK,
      0,//DIA_PRJ_SWC_KEY_CODE_UP,
      0,//DIA_PRJ_SWC_KEY_CODE_DOWN,
      (0 << 8) | 3,//DIA_PRJ_SWC_KEY_CODE_MUTE
      (0 << 8) | 4,//DIA_PRJ_SWC_KEY_CODE_AUDIO_SRC_UP
      0,//DIA_PRJ_SWC_KEY_CODE_AUDIO_SRC_DOWN
      0//DIA_PRJ_SWC_KEY_CODE_RADIO
};

//-----------------------------------------------------------------------------

dia_SrvHandler_KeyPressButtons::dia_SrvHandler_KeyPressButtons ( void )
    : dia_ServiceHandlerUDS("dia_SrvHandler_KeyPressButtons",
     DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,
     (tU16) DIA_C_U16_DID_AIVI_KEY_PRESS_BUTTONS /*DID*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_KeyPressButtons::dia_SrvHandler_KeyPressButtons(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_KeyPressButtons::~dia_SrvHandler_KeyPressButtons ( void )
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_KeyPressButtons::~dia_SrvHandler_KeyPressButtons !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_KeyPressButtons::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_KeyPressButtons::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_IInputHandlingPrj* pInterface = 0;
   if ( querySysAdapterInterface<dia_IInputHandlingPrj>(&pInterface) == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_SrvHandler_KeyPressButtons::vProcessRequest - querySysAdapterInterface OK");
      if ( pInterface )
      {
         (void) setSysAdapterListener<dia_IInputHandlingPrjListener>(this);
         if ( pInterface->getPressedKeys () == DIA_SUCCESS )
         {
            errorDetected = FALSE;
         }
         else
         {
            DIA_TR_INF("dia_SrvHandler_KeyPressButtons::vProcessRequest - getPressedKeys() failed.");
         }
      }
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_KeyPressButtons::vProcessRequest - querySysAdapterInterface NOK !");
   }

   if ( errorDetected )
   {
      (void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
      DIA_TR_ERR(" ---  SEND TO KEYBOARD SERVER FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_KeyPressButtons::vOnGetPressedKey ( const std::vector<dia_tPressedKeyPrj> pressedKeys )
{
   dia_tclFnctTrace trc("dia_SrvHandler_KeyPressButtons:vOnGetPressedKey");

   (void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);

   // Sending back the positive answer
   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

   tU8 u8KeyBitmap[DATA_LENGTH] = {0, 0};

   for (tU32 i = 0; i < pressedKeys.size(); i++)
   {
      dia_eVdInuptHandlingKeyCodePrj pressedKey = pressedKeys[i].mCode;

      if (!((pressedKeys[i].mStatus == 1) || (pressedKeys[i].mStatus == 2)))
      {
         DIA_TR_ERR(" ---  UNKNOWN STATUS (%d) for KEY (%d)!!!!", pressedKeys[i].mStatus, pressedKey);
         continue;
      }

      if ((pressedKey > DIA_PRJ_KEY_CODE_UNKNOWN) && (pressedKey < DIA_PRJ_SWC_KEY_COUNT))
      {
         tU16 u16ByteBit = aKeyCodeBitmap[pressedKey];
         tU8 u8Byte = (tU8)(u16ByteBit >> 8);
         tU8 u8Bit = (tU8) (u16ByteBit & 0xFF);

         DIA_TR_INF("Pressed Key: %d -> Byte %d, Bit %d", pressedKey, u8Byte, u8Bit);

         if ((u8Byte < DATA_LENGTH) && (u8Bit > 0) && (u8Bit <= 8))
         {
            u8KeyBitmap[u8Byte] |= (tU8) (1U << (u8Bit - 1));
         }
         else
         {
            DIA_TR_ERR(" ---  MISSING KEY BIT MAP!!!!");
         }
      }
      else
      {
         DIA_TR_ERR(" ---  NOT AN FACEPLATE KEY (%d)!!!!", pressedKey);
      }
   }

   (void) oDiagMsgBuffer().vSetDataU8(DATA_START, u8KeyBitmap[0]);
   (void) oDiagMsgBuffer().vSetDataU8(DATA_START+1, u8KeyBitmap[1]);

   vResReadyAndQuit();
}

