/*
 * dia_SrvHandler_Get_TunerAMFM_Fieldstrength.cpp
 *
 *  Created on: Feb 11, 2019
 *      Author: urm7kor
 */
#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif
#ifndef DIA_SRVHANDLER_GET_TUNERAMFMWB_FIELDSTRENGTH_H_
#include "dia_SrvHandler_Get_TunerAMFMWB_Fieldstrength.h"
#endif
#define DATA_START 3
#define DATA_LENGTH 1

//-------------------------------------------------------------------------------

dia_SrvHandler_Get_TunerAMFMWB_Fieldstrength::dia_SrvHandler_Get_TunerAMFMWB_Fieldstrength ( tCString name, tU8 sid, tU16 did )
: dia_ServiceHandlerUDS(name,sid,did)
{
	dia_tclFnctTrace trc("dia_SrvHandler_Get_TunerAMFMWB_Fieldstrength::dia_SrvHandler_Get_TunerAMFMWB_Fieldstrength(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_Get_TunerAMFMWB_Fieldstrength::~dia_SrvHandler_Get_TunerAMFMWB_Fieldstrength ( tVoid )
{
	_BP_TRY_BEGIN
	{
		(tVoid) unsetSysAdapterListener<dia_ITunerAMFMPrjListener>(this);
	}
	_BP_CATCH_ALL
	{
		DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_Get_TunerAMFMWB_Fieldstrength::~dia_SrvHandler_Get_TunerAMFMWB_Fieldstrength !!!");
		NORMAL_M_ASSERT_ALWAYS();
	}
	_BP_CATCH_END
}

//-------------------------------------------------------------------------------

tVoid
dia_SrvHandler_Get_TunerAMFMWB_Fieldstrength::vProcessRequest ( const std::vector<tVoid*>& /*vecArgs*/ )
{
	dia_tclFnctTrace trc("dia_SrvHandler_Get_TunerAMFMWB_Fieldstrength::vProcessRequest");
	tBool errorDetected = TRUE;

	dia_ITunerAMFMPrj* pInterface = OSAL_NULL;
	if ( querySysAdapterInterface<dia_ITunerAMFMPrj>(&pInterface) == DIA_SUCCESS )
	{
		DIA_TR_INF("dia_SrvHandler_Get_TunerAMFMWB_Fieldstrength::vProcessRequest - querySysAdapterInterface OK.");
		if ( pInterface )
		{
			DIA_TR_INF("dia_SrvHandler_Get_TunerAMFMWB_Fieldstrength::vProcessRequest - pInterface OK.");
			(tVoid) setSysAdapterListener<dia_ITunerAMFMPrjListener>(this);

			if(oDiagMsgBuffer().u16GetDataLength()==DATA_START+DATA_LENGTH){
				DIA_TR_INF("dia_SrvHandler_Get_TunerAMFMWB_Fieldstrength::vProcessRequest - MsgLength OK -> Send here!");
			}

			if ( pInterface->tunerAMFMWB_TunerBandFieldStrength_Get() == DIA_SUCCESS )
			{
				DIA_TR_INF("dia_SrvHandler_Get_TunerAMFMWB_Fieldstrength::dia_SrvHandler_Get_TunerAMFMWB_Fieldstrength is Success");
				errorDetected = FALSE;
			}
		}
	} else {
		DIA_TR_INF("dia_SrvHandler_Get_TunerAMFMWB_Fieldstrength::vProcessRequest - querySysAdapterInterface FAILED.");
	}

	if ( errorDetected )
	{
		(tVoid) unsetSysAdapterListener<dia_ITunerAMFMPrjListener>(this);
		DIA_TR_ERR(" ---  SEND TO TUNER AMFMWB FAILED!!!!");
		vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
	}
}

//-----------------------------------------------------------------------------

tVoid
dia_SrvHandler_Get_TunerAMFMWB_Fieldstrength::vOnTunerAMFMFWB_BandFieldStrength_Get ( dia_eBandAMFMWB activeBand, tU8 strength )
{
	tU8 u8Strength = 0x00;

	dia_tclFnctTrace trc("dia_SrvHandler_Get_TunerAMFM_Fieldstrength::vOnTunerAMFMWBFieldStrength_Get");

	if( (mDID == DIA_C_U16_DID_CENTER_CMC_19_WEATHERBAND_FIELDSTRENGTH) &&
			(activeBand == DIA_EN_AMFMWBTUNER_BAND_WB))
	{
		u8Strength = strength;
		DIA_TR_INF("dia_SrvHandler_Get_TunerAMFM_Fieldstrength::vOnTunerAMFMFieldStrength_Get - received strength for WB: %d", u8Strength);
	}
	else if((mDID == DIA_C_U16_DID_CENTER_CMC_19_TUNER_AM_FM_FIELDSTRENGTH) &&
			((activeBand == DIA_EN_AMFMWBTUNER_BAND_FM) ||
					(activeBand == DIA_EN_AMFMWBTUNER_BAND_AM))){
		u8Strength = strength;
		DIA_TR_INF("dia_SrvHandler_Get_TunerAMFM_Fieldstrength::vOnTunerAMFMFieldStrength_Get - received strength for FM/AM: %d", u8Strength);
	}
	else if (mDID == DIA_C_U16_DID_CENTER_CMC_19_TUNER_HD_FIELDSTRENGTH)
	{
		u8Strength = strength;
		DIA_TR_INF("dia_SrvHandler_Get_TunerAMFM_Fieldstrength::vOnTunerAMFMFieldStrength_Get - received strength for HD: %d", u8Strength);
	}
	else{
		DIA_TR_INF("Not received fieldstrength for active band");
	}

	DIA_TR_INF("dia_SrvHandler_Get_TunerAMFM_Fieldstrength::vOnTunerAMFMFieldStrength_Get - received strength: %d", strength);

	(tVoid) unsetSysAdapterListener<dia_ITunerAMFMPrjListener>(this);
	oDiagMsgBuffer().vSetPosResp();
	oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);
	(tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) u8Strength));

	vResReadyAndQuit();
}
