/*
 * dia_SrvHandler_Get_SXM_Tuner_Fieldstrength.cpp
 *
 *  Created on: Feb 14, 2019
 *      Author: urm7kor
 */

#include "dia_SrvHandler_Get_SXM_Tuner_Fieldstrength.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif
#define DATA_START 3
#define DATA_LENGTH 1

//-----------------------------------------------------------------------------

dia_SrvHandler_Get_SXM_Tuner_Fieldstrength::dia_SrvHandler_Get_SXM_Tuner_Fieldstrength ( void )
    : dia_ServiceHandlerUDS("dia_SrvHandler_TunerXM_SignalQuality",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,(tU16) DIA_C_U16_DID_CENTER_CMC_19_TUNER_SXM_FIELDSTRENGTH /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerXM_SignalQuality::dia_SrvHandler_TunerXM_SignalQuality(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_Get_SXM_Tuner_Fieldstrength::~dia_SrvHandler_Get_SXM_Tuner_Fieldstrength ( void )
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_ITunerXMListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_Get_SXM_Tuner_Fieldstrength::~dia_SrvHandler_Get_SXM_Tuner_Fieldstrength !!!");
        DIA_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_Get_SXM_Tuner_Fieldstrength::vProcessRequest(const std::vector<void*>& /*vecArgs*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_Get_SXM_Tuner_Fieldstrength::vProcessRequest");
   tBool errorDetected = TRUE;

   dia_ITunerXM* pInterface = OSAL_NULL;
   if ( querySysAdapterInterface<dia_ITunerXM>(&pInterface) == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_SrvHandler_Get_SXM_Tuner_Fieldstrength::vProcessRequest - querySysAdapterInterface OK.");
      if ( pInterface )
      {
         DIA_TR_INF("dia_SrvHandler_Get_SXM_Tuner_Fieldstrength::vProcessRequest - pInterface OK.");
         (void) setSysAdapterListener<dia_ITunerXMListener>(this);

         if(oDiagMsgBuffer().u16GetDataLength()==DATA_START){
            DIA_TR_INF("dia_SrvHandler_Get_SXM_Tuner_Fieldstrength::vProcessRequest - MsgLength OK -> Send here!");
         } else {
            DIA_TR_ERR("dia_SrvHandler_Get_SXM_Tuner_Fieldstrength::vProcessRequest - MsgLength FAILED - different than expected!");
         }

         if ( pInterface->tunerXM_1_SignalQuality_Get() == DIA_SUCCESS )
         {
            DIA_TR_INF("dia_SrvHandler_Get_SXM_Tuner_Fieldstrength::vProcessRequest - pInterface->tunerXM_SignalQuality_Get() SUCCESS.");
            errorDetected = FALSE;
         } else {
            DIA_TR_INF("dia_SrvHandler_Get_SXM_Tuner_Fieldstrength::vProcessRequest - pInterface->tunerXM_SignalQuality_Get() FAILED.");
         }
      }
   } else {
      DIA_TR_INF("dia_SrvHandler_Get_SXM_Tuner_Fieldstrength::vProcessRequest - querySysAdapterInterface FAILED.");
   }

   if ( errorDetected )
   {
      (void) unsetSysAdapterListener<dia_ITunerXMListener>(this);
      DIA_TR_ERR(" ---  SEND TO XM TUNER SERVER FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_Get_SXM_Tuner_Fieldstrength::vOnTunerXM_1_SignalQuality_Get ( tU8 quality )
{
   dia_tclFnctTrace trc("dia_SrvHandler_Get_SXM_Tuner_Fieldstrength::vOnTunerXM_1_ChannelLabel_Get");

   (void) unsetSysAdapterListener<dia_ITunerXMListener>(this);

   if(quality!=0xFF)
   {
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) quality));

      vResReadyAndQuit();
      DIA_TR_INF("dia_SrvHandler_Get_SXM_Tuner_Fieldstrength::vOnTunerXM_1_ChannelLabel_Get SUCCESSFUL");
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_Get_SXM_Tuner_Fieldstrength::vOnTunerXM_1_ChannelLabel_Get FAIL");
      // Sending back the Negative answer
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}
