/*
 * dia_SrvHandler_Get_FM_Tuner2_Fieldstrength.cpp
 *
 *  Created on: Feb 12, 2019
 *      Author: urm7kor
 */
#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif
#include "dia_SrvHandler_Get_FM_Tuner2_Fieldstrength.h"

#define DATA_START 3
#define DATA_LENGTH 1

//-------------------------------------------------------------------------------

dia_SrvHandler_Get_FM_Tuner2_Fieldstrength::dia_SrvHandler_Get_FM_Tuner2_Fieldstrength ( tVoid )
: dia_ServiceHandlerUDS("dia_SrvHandler_Get_FM_Tuner2_Fieldstrength",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,DIA_C_U16_DID_CENTER_CMC_19_TUNER2_FM_FIELDSTRENGTH /*DID*/)
{
	dia_tclFnctTrace trc("dia_SrvHandler_Get_FM_Tuner2_Fieldstrength::dia_SrvHandler_Get_FM_Tuner2_Fieldstrength(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_Get_FM_Tuner2_Fieldstrength::~dia_SrvHandler_Get_FM_Tuner2_Fieldstrength ( tVoid )
{
	_BP_TRY_BEGIN
	{
		(tVoid) unsetSysAdapterListener<dia_ITunerTestmodeListener>(this);
	}
	_BP_CATCH_ALL
	{
		DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_Get_FM_Tuner2_Fieldstrength::~dia_SrvHandler_Get_FM_Tuner2_Fieldstrength !!!");
		NORMAL_M_ASSERT_ALWAYS();
	}
	_BP_CATCH_END
}

//-------------------------------------------------------------------------------

tVoid
dia_SrvHandler_Get_FM_Tuner2_Fieldstrength::vProcessRequest ( const std::vector<tVoid*>& /*vecArgs*/ )
{
	dia_tclFnctTrace trc("dia_SrvHandler_Get_FM_Tuner2_Fieldstrength::vProcessRequest");
	tBool errorDetected = TRUE;
	dia_ITunerTestmode* pInterface = 0;
	if ((querySysAdapterInterface<dia_ITunerTestmode>(&pInterface) == DIA_SUCCESS) && pInterface)
	{
		(void) setSysAdapterListener<dia_ITunerTestmodeListener>(this);
		if (pInterface->controlTestmode(TRUE) == DIA_SUCCESS)
		{
			errorDetected = FALSE;
		}
		else
		{
			DIA_TR_INF("dia_SrvHandler_Antenna1Parameter::vProcessRequest - controlTestmode() failed.");
		}
	}
	else
	{
		DIA_TR_INF("dia_SrvHandler_Antenna1Parameter::vProcessRequest - querySysAdapterInterface NOK !");
	}

	if (errorDetected)
	{
		(void) unsetSysAdapterListener<dia_ITunerTestmodeListener>(this);
		DIA_TR_ERR("dia_SrvHandler_Antenna1Parameter ---  SEND TO Tuner SERVER FAILED !!!");
		vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
	}

}

//-----------------------------------------------------------------------------
void
dia_SrvHandler_Get_FM_Tuner2_Fieldstrength::vOnControlTestmode()
{
	dia_tclFnctTrace trc("dia_SrvHandler_Get_FM_Tuner2_Fieldstrength::vOnControlTestmode");
}

//------------------------------------------------------------------------------------

void
dia_SrvHandler_Get_FM_Tuner2_Fieldstrength::vOnTestmodeData(const dia_ITunerTestmodeData& data)
{
	dia_tclFnctTrace trc("dia_SrvHandler_Antenna1Parameter::vOnTestmodeData");

	if (data.ePhysicalTuner == DIA_EN_AMFMTUNER_2)
	{
		(void) unsetSysAdapterListener<dia_ITunerTestmodeListener>(this);

		dia_ITunerTestmode* pInterface = 0;
		if ((querySysAdapterInterface<dia_ITunerTestmode>(&pInterface) == DIA_SUCCESS) && pInterface)
		{
			(void) pInterface->controlTestmode(FALSE);
		}

		oDiagMsgBuffer().vSetPosResp();
		oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

		(void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 0, data.u8Fieldstrength); //FieldStrength FM Tuner2

		vResReadyAndQuit();
	}
}
