/*
 * dia_SrvHandler_Get_DAB_Tuner_Fieldstrength.cpp
 *
 *  Created on: Feb 11, 2019
 *      Author: urm7kor
 */
#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#include "dia_SrvHandler_Get_DAB_Tuner_Fieldstrength.h"
#define DATA_START 3
#define DATA_LENGTH 1
//-----------------------------------------------------------------------------

dia_SrvHandler_Get_DAB_Tuner_Fieldstrength::dia_SrvHandler_Get_DAB_Tuner_Fieldstrength ( void )
: dia_ServiceHandlerUDS("dia_SrvHandler_Get_DAB_Tuner_Fieldstrength", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, DIA_C_U16_DID_CENTER_CMC_19_TUNER_DAB_FIELDSTRENGTH)
{
	dia_tclFnctTrace trc("dia_SrvHandler_Get_DAB_Tuner_Fieldstrength::dia_SrvHandler_Get_DAB_Tuner_Fieldstrength(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_Get_DAB_Tuner_Fieldstrength::~dia_SrvHandler_Get_DAB_Tuner_Fieldstrength ( void )
{
	_BP_TRY_BEGIN
	{
		(void) unsetSysAdapterListener<dia_ITunerDABListener>(this);
	}
	_BP_CATCH_ALL
	{
		DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_Get_DAB_Tuner_Fieldstrength::~dia_SrvHandler_Get_DAB_Tuner_Fieldstrength !!!");
		DIA_ASSERT_ALWAYS();
	}
	_BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_Get_DAB_Tuner_Fieldstrength::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
	dia_tclFnctTrace trc("dia_SrvHandler_Get_DAB_Tuner_Fieldstrength::vProcessRequest");

	tBool errorDetected = TRUE;

	dia_ITunerDAB* pInterface = 0;
	if ((querySysAdapterInterface<dia_ITunerDAB>(&pInterface) == DIA_SUCCESS) && pInterface)
	{
		(void) setSysAdapterListener<dia_ITunerDABListener>(this);
		if (pInterface->tunerDABTestmode_Set(TRUE) == DIA_SUCCESS)
		{
			if (pInterface->tunerDABTestModeData_Get() == DIA_SUCCESS)
			{
				errorDetected = FALSE;
			}
			else
			{
				DIA_TR_INF("dia_SrvHandler_Get_DAB_Tuner_Fieldstrength::vProcessRequest - tunerDABTestModeData_Get() failed.");
			}
		}
		else
		{
			DIA_TR_INF("dia_SrvHandler_Get_DAB_Tuner_Fieldstrength::vProcessRequest - tunerDABTestmode_Set() failed.");
		}
	}
	else
	{
		DIA_TR_INF("dia_SrvHandler_Get_DAB_Tuner_Fieldstrength::vProcessRequest - querySysAdapterInterface NOK !");
	}

	if (errorDetected)
	{
		(void) unsetSysAdapterListener<dia_ITunerDABListener>(this);
		DIA_TR_ERR("dia_SrvHandler_Get_DAB_Tuner_Fieldstrength ---  SEND TO SensorPV SERVER FAILED !!!");
		vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
	}
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_Get_DAB_Tuner_Fieldstrength::vOnDABStatusSignalFieldStrengh ( tS8 signalFieldStrengh )
{
	dia_tclFnctTrace trc("dia_SrvHandler_Get_DAB_Tuner_Fieldstrength::vOnDABStatusSignalFieldStrengh");

	DIA_TR_INF("dia_SrvHandler_Get_DAB_Tuner_Fieldstrength::vOnDABStatusSignalFieldStrengh - received strength: %d", signalFieldStrengh);

	(tVoid) unsetSysAdapterListener<dia_ITunerDABListener>(this);
	oDiagMsgBuffer().vSetPosResp();
	oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);
	(tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tS8) signalFieldStrengh));

	vResReadyAndQuit();
}
