/*
 * dia_SrvHandler_FirstUSBProgramming.cpp
 *
 *  Created on: 09.11.2015
 *      Author: stc2hi
 *      --------------------------------------------------------------------------------------
 *      Date        Author       Modification
 *
 *      15.02.2016   bsu9kor      Default values changed.(NCG3D-9533)
 *      09.08.2017   mky6kor      Solved Programming Log issue (NCG3D-55224)
 *
 *      ---------------------------------------------------------------------------------------
 */
// TTFis:\> DIA_REQ UDS 03 22 11 03

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef DIA_SRVHANDLER_FIRST_USB_PROGRAMMING_H_
#include "dia_SrvHandler_FirstUSBProgramming.h"
#endif

#define DATA_START 3
#define DATA_LENGTH 20

#define DEC2BCD(val1, val2)    (tU8)(((val1 / 10)* 16) + (val2 % 10) )
#define DEFAULT 0xFF

//-----------------------------------------------------------------------------

dia_SrvHandler_FirstUSBProgramming::dia_SrvHandler_FirstUSBProgramming ( void )
    : dia_ServiceHandlerUDS("dia_SrvHandler_FirstUSBProgramming",
     DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,
     (tU16) DIA_C_U16_DID_AIVI_FIRST_USB_PROGRAMMING /*DID*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_FirstUSBProgramming::dia_SrvHandler_FirstUSBProgramming(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_FirstUSBProgramming::~dia_SrvHandler_FirstUSBProgramming ( void )
{
    _BP_TRY_BEGIN
    {
        (void) unsetSysAdapterListener<dia_ISwUpdateListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_FirstUSBProgramming::~dia_SrvHandler_FirstUSBProgramming !!!");
        DIA_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_FirstUSBProgramming::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_FirstUSBProgramming::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_ISwUpdate* pInterface = 0;
   if ( querySysAdapterInterface<dia_ISwUpdate>(&pInterface) == DIA_SUCCESS )
   {
        DIA_TR_INF("dia_SrvHandler_FirstUSBProgramming::vProcessRequest - querySysAdapterInterface OK");
      if ( pInterface )
      {
         (void) setSysAdapterListener<dia_ISwUpdateListener>(this);
         dia_tHistoryScope historyScope(DIA_EN_UPDATE_HISTORY_SCOPE_FIRST_USB, 0, 0);
         if ( pInterface->getSwUpdateInfo (historyScope) == DIA_SUCCESS )
         {
            errorDetected = FALSE;
         }
       else
       {
            DIA_TR_INF("dia_SrvHandler_FirstUSBProgramming::vProcessRequest - getSwUpdateInfo() failed.");
         }
      }
   }
   else
   {
        DIA_TR_INF("dia_SrvHandler_FirstUSBProgramming::vProcessRequest - querySysAdapterInterface NOK !");
   }

   if ( errorDetected )
   {
      (void) unsetSysAdapterListener<dia_ISwUpdateListener>(this);
      DIA_TR_ERR(" ---  SEND TO DOWNLOAD SERVER FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_FirstUSBProgramming::vOnSwUpdateInfo ( const std::vector<dia_tProgramHistory>& progInfo )
{
   dia_tclFnctTrace trc("dia_SrvHandler_FirstUSBProgramming:vOnSwUpdateInfo");

   (void) unsetSysAdapterListener<dia_ISwUpdateListener>(this);

   // Sending back the positive answer
   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

   tU8 progIndex = 0;

   if ( !(progInfo.empty()) )
   {
      DIA_TR_INF("dia_SrvHandler_FirstUSBProgramming::vOnSwUpdateInfo SUCCESSFUL");

     tU16 year = (progInfo.at(progIndex).mYear);

      if((progInfo.at(progIndex).mYear) >= 1000)
      {
        year = ((progInfo.at(progIndex).mYear) % 1000);
        year = (year % 100);
      }
      else if((progInfo.at(progIndex).mYear) >= 100)
      {
        year = ((progInfo.at(progIndex).mYear) % 100);
      }

      (void) oDiagMsgBuffer().vSetDataU8((tU8) (DATA_START+0),(DEC2BCD((tU8)year, (tU8)year)));
      (void) oDiagMsgBuffer().vSetDataU8((tU8) (DATA_START+1),(DEC2BCD((tU8)(progInfo.at(progIndex).mMonth),(tU8)(progInfo.at(progIndex).mMonth))));
      (void) oDiagMsgBuffer().vSetDataU8((tU8) (DATA_START+2),(DEC2BCD((tU8)(progInfo.at(progIndex).mDay),(tU8)(progInfo.at(progIndex).mDay))));
      (void) oDiagMsgBuffer().vSetDataU8((tU8) (DATA_START+3),(DEC2BCD((tU8)(progInfo.at(progIndex).mHour),(tU8)(progInfo.at(progIndex).mHour))));
      (void) oDiagMsgBuffer().vSetDataU8((tU8) (DATA_START+4),(DEC2BCD((tU8)(progInfo.at(progIndex).mMinute),(tU8)(progInfo.at(progIndex).mMinute))));
      (void) oDiagMsgBuffer().vSetDataU8((tU8) (DATA_START+5),(DEC2BCD((tU8)(progInfo.at(progIndex).mSecond),(tU8)(progInfo.at(progIndex).mSecond))));

     if (progInfo.at(progIndex).mProgStatus)
     {
        (void) oDiagMsgBuffer().vSetDataU8((tU8) (DATA_START+6),0);
     }
     else
     {
        (void) oDiagMsgBuffer().vSetDataU8((tU8) (DATA_START+6),1);
     }
     (void) oDiagMsgBuffer().vSetDataU8((tU8) (DATA_START+7),0);
     (void) oDiagMsgBuffer().vSetDataU8((tU8) (DATA_START+8),1);

      //Filling 0s to version name
      for (tU8 j = 9; j <= 18 ; ++j)
      {
         (void) oDiagMsgBuffer().vSetDataU8((tU8) (DATA_START+j), 0);
      }
     std::string SWversionSubStr = progInfo.at(progIndex).mSwVersionName; //.substr(15,7);

      tU8 i = 9; // Response buffer progIndex

      for (std::string::const_iterator bIterator = SWversionSubStr.begin(); bIterator != SWversionSubStr.end(); ++bIterator, ++i)
      {
         (void) oDiagMsgBuffer().vSetDataU8((tU8) (DATA_START+i), *bIterator);
      }

     (void) oDiagMsgBuffer().vSetDataU8((tU8) (DATA_START+19),0x00);
   }
   else
   {
       DIA_TR_INF("dia_SrvHandler_FirstUSBProgramming::vOnSwUpdateInfo LIST EMPTY OR LESS UPDATES");
       for ( tU8 i = 0 ; i < DATA_LENGTH; i += 1 )
       {
          (void) oDiagMsgBuffer().vSetDataU8((tU8) (DATA_START+i),DEFAULT );
       }
   }
   vResReadyAndQuit();
}



