/*
 * dia_SrvHandler_FanActivationDuration.cpp
 *
 *  Created on: 14.12.2016
 *      Author: stc2hi
 */
// TTFis:\> DIA_REQ UDS 03 22 10 09

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#include "dia_SrvHandler_FanActivationDuration.h"

#define DATA_START 3
#define DATA_LENGTH 2

//-----------------------------------------------------------------------------

dia_SrvHandler_FanActivationDuration::dia_SrvHandler_FanActivationDuration ( void )
    : dia_ServiceHandlerUDS("dia_SrvHandler_FanActivationDuration", 
                            DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, 
                            DIA_C_U16_DID_AIVI_FAN_ACTIVATION_DURATION)
{
}

//-----------------------------------------------------------------------------

dia_SrvHandler_FanActivationDuration::~dia_SrvHandler_FanActivationDuration ( void )
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_IFanStatisticsListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_FanActivationDuration::~dia_SrvHandler_FanActivationDuration !!!");
        DIA_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_FanActivationDuration::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_FanActivationDuration::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_IFanStatistics* pInterface = 0;
   if ((querySysAdapterInterface<dia_IFanStatistics>(&pInterface) == DIA_SUCCESS) && pInterface)
   {
      (void) setSysAdapterListener<dia_IFanStatisticsListener>(this);
      if (pInterface->getFanActivationStatistics() == DIA_SUCCESS)
      {
         errorDetected = FALSE;
      }
      else
      {
         DIA_TR_INF("dia_SrvHandler_FanActivationDuration::vProcessRequest - getFanActivationStatistics() failed.");
      }
   }
   else
   {
      DIA_TR_ERR("dia_SrvHandler_FanActivationDuration::vProcessRequest - querySysAdapterInterface NOK !");
   }

   if (errorDetected)
   {
      (void) unsetSysAdapterListener<dia_IFanStatisticsListener>(this);
      DIA_TR_ERR("dia_SrvHandler_FanActivationDuration ---  SEND TO INTERFACE SERVER FAILED !!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_FanActivationDuration::vOnFanActivationDuration (tU16 duration)
{
   dia_tclFnctTrace trc("dia_SrvHandler_FanActivationDuration::vOnFanActivationDuration");

   DIA_TR_INF("dia_SrvHandler_FanActivationDuration::vOnFanActivationDuration received: %d", duration);

   (void) unsetSysAdapterListener<dia_IFanStatisticsListener>(this);

   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 0, ((tU8) (duration >> 8)));
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 1, (((tU8) duration)));

   vResReadyAndQuit();
}
