/*
 * dia_SrvHandler_FanActivationCounter.cpp
 *
 *  Created on: 14.12.2016
 *      Author: stc2hi
 */
// TTFis:\> DIA_REQ UDS 03 22 10 08

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#include "dia_SrvHandler_FanActivationCounter.h"

#define DATA_START 3
#define DATA_LENGTH 2

//-----------------------------------------------------------------------------

dia_SrvHandler_FanActivationCounter::dia_SrvHandler_FanActivationCounter ( void )
    : dia_ServiceHandlerUDS("dia_SrvHandler_FanActivationCounter", 
                            DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, 
                            DIA_C_U16_DID_AIVI_FAN_ACTIVATION_COUNTER)
{
}

//-----------------------------------------------------------------------------

dia_SrvHandler_FanActivationCounter::~dia_SrvHandler_FanActivationCounter ( void )
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_IFanStatisticsListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_FanActivationCounter::~dia_SrvHandler_FanActivationCounter !!!");
        DIA_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_FanActivationCounter::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_FanActivationCounter::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_IFanStatistics* pInterface = NULL;
   if ((querySysAdapterInterface<dia_IFanStatistics>(&pInterface) == DIA_SUCCESS) && pInterface)
   {
      (void) setSysAdapterListener<dia_IFanStatisticsListener>(this);

      if (pInterface->getFanActivationStatistics() == DIA_SUCCESS)
      {
         errorDetected = FALSE;
      }
      else
      {
         DIA_TR_INF("dia_SrvHandler_FanActivationCounter::vProcessRequest - getFanActivationStatistics() failed.");
      }
   }
   else
   {
      DIA_TR_ERR("dia_SrvHandler_FanActivationCounter::vProcessRequest - querySysAdapterInterface NOK !");
   }

   if (errorDetected)
   {
      (void) unsetSysAdapterListener<dia_IFanStatisticsListener>(this);
      DIA_TR_ERR("dia_SrvHandler_FanActivationCounter ---  SEND TO INTERFACE FAILED !!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_FanActivationCounter::vOnFanActivationCounter (tU16 counter)
{
   dia_tclFnctTrace trc("dia_SrvHandler_FanActivationCounter::vOnFanActivationCounter");

   DIA_TR_INF("dia_SrvHandler_FanActivationCounter::vOnFanActivationCounter received: %d", counter);

   (void) unsetSysAdapterListener<dia_IFanStatisticsListener>(this);

   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 0, ((tU8) (counter >> 8)));
   (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 1, (((tU8) counter)));

   vResReadyAndQuit();
}
