 /*!
 * \file       dia_SrvHandler_CISInstallationContainerSwVersion.h
 *
 * \brief      Service handler to read the Software Version of CIS Installation Container
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    diag services
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       29.04.2020
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __DIA_SRV_HANDLER_CIS_INSTALLATION_CONTAINER_SOFTWARE_VERSION_H__
#define __DIA_SRV_HANDLER_CIS_INSTALLATION_CONTAINER_SOFTWARE_VERSION_H__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

namespace tinyxml2 
{
	class XMLElement;
	class XMLNode;
}
using namespace tinyxml2;
namespace dia {

/**
 * \class   dia_SrvHandlerInstallationContainerSwVersion
 *
 * \brief   service handler to process read reuest for
 *			Software Version of CIS Installation Container
 *
 * \ingroup diaServicesproj
 */
class dia_SrvHandlerInstallationContainerSwVersion
   : public dia_ServiceHandlerUDS
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandlerInstallationContainerSwVersion);

public:
   /**
    *
    * \brief      class constructor
    *
    *             class constructor with name, service identifier and 2 byte
    *             data identifier
    *
    * \param[in]  name     name used to distinguish between multiple instances
    * \param[in]  sid      diagnostic service identifier (e.g. 0x22)
    * \param[in]  did      diagnostic data identifier (2 byte)
    *
    * \return     none
    */
   dia_SrvHandlerInstallationContainerSwVersion(tCString name, tU8 sid, tU16 did);

   /**
    *
    * \brief      class destructor
    *
    *             class destructor
    */
   virtual ~dia_SrvHandlerInstallationContainerSwVersion(void);
   /**
    *
    * \brief      method called to start service processing
    *
    *             This method is used to start processing of a received diagnosis
    *             request. The additional parameters are parameters provided by
    *             the service handler itself during creation of its lookup key. The
    *             lookup key and up to two parameters are stored in the lookup table
    *             of a service dispatcher that dispatches incoming message to the
    *             associated service handler.
    *
    * \param[in]  vecArgs      request buffer
    *
    * \return     none
    */
   virtual void vProcessRequest ( const std::vector<void*>&  /* vecArgs */);

private:
	/**
    *
    * \brief      method called to retrive the software version
	*             of the CIS Installation Container
    *             
    * \param[in]  none
    *
    * \return     none
    */
	virtual void getInstallationContainerSoftwareVersion( void );
    /**
    *
    * \brief      method called to parse xml
    *
    *             This method is used to parse the xml file.
    *             
    * \param[in]  file      xml file path
    *
    * \return     none
    */
	virtual void parseXML( const std::string& /* file */ ); 
	/**
    *
    * \brief      method called to parse the node
    *
    *             This method is used to parse the xml node and search the desired target value. 
    *             Once the target is available, the value is extraced and stored in member variable.
    *             
    * \param[in]  node      xml node pointer
    *
    * \return     void
    */
	virtual void recursiveParse(XMLNode* /* node */);
   /**
    *
    * \brief      member variable to store parsed string
    *
    */
	std::string __CISInstallationContainerSoftwareVersion;
	/**
    *
    * \brief      member variable to store sw version data
    *
    */
	std::vector<tU8> mSwVersion;
   /**
    *
    * \brief      member variable to store parsing result
    *
    */
   tBool __CISInstallationContainerSoftwareVersionFound;
};

} /* namespace dia */

#endif /* __DIA_SRV_HANDLER_CIS_INSTALLATION_CONTAINER_SOFTWARE_VERSION_H__ */
