/*!
 * \file       dia_SrvHandlerVINIdentRead.cpp
 *
 * \brief      Service Handler for reading VIN
 *
 * \details    
 *             
 *
 * \component  Diagnosis
 *
 * \ingroup
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

// TTFis: DIA_REQ UDS 03 22 F1 90

#ifndef __INCLUDED_SERVICE_HANDLER_VIN_IDENT_READ__
#include "project/services/customer/dia_SrvHandlerVINIdentRead.h"
#endif 

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#define DATA_SIZE (1/*sizeof(SID)*/ + mDIDLen)

//-----------------------------------------------------------------------------

dia_SrvHandlerVINIdentRead::dia_SrvHandlerVINIdentRead ( tCString name, tU8 sid, tU16 did )
    : dia_SrvHandlerGenericIdentRead(name,sid,did)
{
   dia_tclFnctTrace trc("dia_SrvHandlerVINIdentRead::dia_SrvHandlerVINIdentRead(tCString,tU8,tU16)");
}
//-----------------------------------------------------------------------------

dia_SrvHandlerVINIdentRead::~dia_SrvHandlerVINIdentRead ( void )
{
}

//-----------------------------------------------------------------------------

void
dia_SrvHandlerVINIdentRead::vProcessRequest ( const std::vector<void*>& vecArgs )
{
   dia_tclFnctTrace trc("dia_SrvHandlerVINIdentRead::vOnProcessRequest");

   // data length contains at least sid, ctrl byte and DID --> 4 bytes minimum
   tU16 dataLength = oDiagMsgBuffer().u16GetDataLength();
   if ( dataLength !=  (DATA_SIZE + 1) ) // one additional byte contains the message length
   {
      DIA_TR_INF("dia_SrvHandlerVINIdentRead::vOnProcessRequest INVALID LENGTH. EXPECTED %d B BUT RECEIVED %d B !", (DATA_SIZE+1), dataLength);
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT));
      return;
   }

   if ( vecArgs.size() )
   {
      tU32 propID = (tU32) vecArgs[0];

      // data memory
      std::vector<tU8> dataVec;

      // retrieve size of property
      tU16 length = dia_getPropertySize(propID); //DIA_PROP_LENGTH_MAX;
      dataVec.reserve(length);
      dataVec.resize(length);

      DIA_TR_INF("dia_SrvHandlerVINIdentRead::vOnProcessRequest - length %d, dataVec.size() %d (cleaned).", length, dataVec.size());

      tDiaResult retCode = dia_getProperty(propID,dataVec);
      if ( retCode == DIA_SUCCESS )
      {

         DIA_TR_INF("dia_SrvHandlerVINIdentRead::vOnProcessRequest - length %d, dataVec.size() %d (new data).", length, dataVec.size());

         // Sending back the positive answer
         oDiagMsgBuffer().vSetPosResp();
         oDiagMsgBuffer().vSetDataLength(DATA_SIZE + (tU16) (dataVec.size()));
         for (tU16 i = 0; i < dataVec.size(); ++i)
         {
            (void) oDiagMsgBuffer().vSetDataU8(DATA_SIZE+i, dataVec[i]);
         }
      }
      else
      {
         DIA_TR_INF("dia_SrvHandlerVINIdentRead::vOnProcessRequest UNABLE TO READ ITEM (READ OPERATION FAILED)- send default value !!");
         // Sending back the default answer
         oDiagMsgBuffer().vSetPosResp();
         oDiagMsgBuffer().vSetDataLength(DATA_SIZE + (tU16) (dataVec.size()));
         for (tU16 i = 0; i < dataVec.size(); ++i)
         {
            (void) oDiagMsgBuffer().vSetDataU8(DATA_SIZE+i, 0x30);
         }
	  }
	  
	  vResReadyAndQuit();
   }
   else
   {
      DIA_TR_INF("dia_SrvHandlerVINIdentRead::vOnProcessRequest UNABLE TO READ ITEM (PROPERTY NOT PASSED AS PARAMETER !!");
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));
   }

}


