/*!
* \file       dia_SrvHandlerSoftwareSupplierIdentRead.cpp
*
* \brief      Service Handler for reading Software Supplier Information
*
* \details    Class file
*
* \author     Hme4kor
*
* \component  Diagnosis
*
* \ingroup
*
* \copyright  (c) 2018 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
*/

// TTFis: DIA_REQ UDS 03 22 F1 55

#ifndef __INCLUDED_SERVICE_HANDLER_SOFTWARE_SUPPLIER_IDENT_READ__
#include "project/services/customer/dia_SrvHandlerSoftwareSupplierIdentRead.h"
#endif 

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#define DATA_SIZE (1/*sizeof(SID)*/ + mDIDLen)
#define SUPPLIER_INFO_SIZE 2
#define SOFTWARE_SUPPLIER_NAME_PART1 0x00
#define SOFTWARE_SUPPLIER_NAME_PART2 0x03

//-----------------------------------------------------------------------------

dia_SrvHandlerSoftwareSupplierIdentRead::dia_SrvHandlerSoftwareSupplierIdentRead ( tCString name, tU8 sid, tU16 did )
    : dia_SrvHandlerGenericIdentRead(name,sid,did)
{
   dia_tclFnctTrace trc("dia_SrvHandlerSoftwareSupplierIdentRead::dia_SrvHandlerSoftwareSupplierIdentRead(tCString,tU8,tU16)");
}
//-----------------------------------------------------------------------------

dia_SrvHandlerSoftwareSupplierIdentRead::~dia_SrvHandlerSoftwareSupplierIdentRead ( void )
{
}

//-----------------------------------------------------------------------------

void
dia_SrvHandlerSoftwareSupplierIdentRead::vProcessRequest ( const std::vector<void*>& vecArgs )
{
   dia_tclFnctTrace trc("dia_SrvHandlerSoftwareSupplierIdentRead::vOnProcessRequest");

   // data length contains at least sid, ctrl byte and DID --> 4 bytes minimum
   tU16 dataLength = oDiagMsgBuffer().u16GetDataLength();
   if ( dataLength !=  (DATA_SIZE + 1) ) // one additional byte contains the message length
   {
      DIA_TR_INF("dia_SrvHandlerSoftwareSupplierIdentRead::vOnProcessRequest INVALID LENGTH. EXPECTED %d B BUT RECEIVED %d B !", (DATA_SIZE+1), dataLength);
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT));
      return;
   }

   if ( vecArgs.size() )
   {
	   const tU8 softwareSupplierInformation[SUPPLIER_INFO_SIZE + 1] = { SOFTWARE_SUPPLIER_NAME_PART1, SOFTWARE_SUPPLIER_NAME_PART2 }; //BOSCH:0x03
	   oDiagMsgBuffer().vSetPosResp();
	   oDiagMsgBuffer().vSetDataLength(DATA_SIZE + SUPPLIER_INFO_SIZE);

	   for (tU8 i = 0; i<SUPPLIER_INFO_SIZE; i++)
	   {
		   (tVoid)oDiagMsgBuffer().vSetDataU8(DATA_SIZE + i, softwareSupplierInformation[i]);
	   }
	  
	  vResReadyAndQuit();
   }
   else
   {
      DIA_TR_INF("dia_SrvHandlerSoftwareSupplierIdentRead::vOnProcessRequest UNABLE TO READ ITEM (PROPERTY NOT PASSED AS PARAMETER !!");
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));
   }

}


