/*!
 * \file       dia_SrvHandlerRuntimeSourceSXM.h
 *
 * \brief      Service handler that will read the run time source for SXM
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    customer diagnosis
 *
 * \author     Naik Ravi (MS/ECA2-XC)
 *
 * \date       20.05.2022
 *
 * \copyright  (c) 2022 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_DIA_SRV_HANDLER_RUN_TIME_SOURCE_SXM__
#define __INCLUDED_DIA_SRV_HANDLER_RUN_TIME_SOURCE_SXM__

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif


class dia_SrvHandlerReadRunTimeSourceSXM
   : public dia_ServiceHandlerUDS

{
	DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SrvHandlerReadRunTimeSourceSXM);
	DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandlerReadRunTimeSourceSXM);

public:
   //! class constructor
	dia_SrvHandlerReadRunTimeSourceSXM ( tCString name, tU8 sid, tU16 did );

   //! class destructor
   virtual ~dia_SrvHandlerReadRunTimeSourceSXM ( void );

   //! handle the received request
   virtual void vProcessRequest ( const std::vector<void*>& /*vecArgs*/ );

};

#endif /* __INCLUDED_DIA_SRV_HANDLER_RUN_TIME_SOURCE_AM__ */
