/**
 * \file    dia_SrvHandlerPrjSpecificIdentRegistryRead.h
 *
 * \brief   This file contains the definition of the dia_SrvHandlerPrjSpecificIdentRegistryRead class,
 *          that provides a project specific service handler that can be used to process
 *          identification requests that require to retrieve a property data from registry
 *
 * \author  ama8kor
 * \date    2018/08/27
 *
 * \copyright Robert Bosch Car Multimedia 2018
 */

#ifndef __INCLUDED_SERVICE_HANDLER_PRJ_SPECIFIC_REGISTRY_IDENT_READ__
#define __INCLUDED_SERVICE_HANDLER_PRJ_SPECIFIC_REGISTRY_IDENT_READ__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

// enum used for pointing to specific buffer index
enum dia_enNumberIndex
{
	DIA_NUM_INDEX_ZERO,
	DIA_NUM_INDEX_ONE,
	DIA_NUM_INDEX_TWO,
	DIA_NUM_INDEX_THREE,
    DIA_NUM_INDEX_FOUR,
    DIA_NUM_INDEX_FIVE
};

/**
 * \class   dia_SrvHandlerPrjSpecificIdentRegistryRead
 *
 * \brief   Generic service handler to process Identification request
 *
 *          This class provides a project specific service handler that can be used to process
 *          identification requests that require to retrieve a property data from registry
 *
 * \ingroup project specific registry read
 */

class dia_SrvHandlerPrjSpecificIdentRegistryRead
    : public dia_ServiceHandlerUDS
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SrvHandlerPrjSpecificIdentRegistryRead);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandlerPrjSpecificIdentRegistryRead);

public:
   /**
    *
    * \brief      class constructor
    *
    *             class constructor with name, service identifier and 1 byte
    *             data identifier
    *
    * \param[in]  name     name used to distinguish between multiple instances
    * \param[in]  sid      diagnostic service identifier (e.g. 0x22)
    * \param[in]  did      diagnostic data identifier (1 byte)
    *
    * \return     none
    */
   dia_SrvHandlerPrjSpecificIdentRegistryRead ( tCString name, tU8 sid, tU8 did );

   /**
    *
    * \brief      class constructor
    *
    *             class constructor with name, service identifier and 2 byte
    *             data identifier
    *
    * \param[in]  name     name used to distinguish between multiple instances
    * \param[in]  sid      diagnostic service identifier (e.g. 0x22)
    * \param[in]  did      diagnostic data identifier (2 byte)
    */
   dia_SrvHandlerPrjSpecificIdentRegistryRead ( tCString name, tU8 sid, tU16 did );
   /**
    *
    * \brief      class destructor
    *
    *             class destructor
    */
   virtual ~dia_SrvHandlerPrjSpecificIdentRegistryRead ( void );
   /**
    *
    * \brief      method called to start service processing
    *
    *             This method is used to start processing of a received diagnosis
    *             request. The additional parameters are parameters provided by
    *             the service handler itself during creation of its lookup key. The
    *             lookup key and up to two parameters are stored in the lookup table
    *             of a service dispatcher that dispatches incoming message to the
    *             associated service handler.
    *
    * \param[in]  pArname     name used to distinguish between multiple instances
    * \param[in]  sid      diagnostic service identifier (e.g. 0x22)
    * \param[in]  did      diagnostic data identifier (2 byte)
    *
    * \return     none
    */
   virtual void vProcessRequest ( const std::vector<tArgsType>& vecArgs );
   
};

#endif /* __INCLUDED_SERVICE_HANDLER_PRJ_SPECIFIC_REGISTRY_IDENT_READ__ */
