/*
 * dia_SrvHandlerPrjSpecificIdentRegistryRead.cpp
 *
 *  Created on: 27.08.2018
 *      Author: ama8kor
 */

// TTFis: DIA_REQ UDS 04 22 F1 51 
// TTFis: DIA_REQ UDS 04 22 F1 53 

#ifndef __INCLUDED_SERVICE_HANDLER_PRJ_SPECIFIC_REGISTRY_IDENT_READ__
#include "dia_SrvHandlerPrjSpecificIdentRegistryRead.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#include <stdlib.h>

#define DIA_U16_READDATA_BY_ID_REQUEST_LENGTH  ((tU16) (1 + mDIDLen))
#define DIA_C_CUST_SW_VER_CMC_RESP_LEN        (int)3
#define DIA_C_BASE_FORMAT_HEXADECIMAL         (int)16

using namespace dia;

//-----------------------------------------------------------------------------

dia_SrvHandlerPrjSpecificIdentRegistryRead::dia_SrvHandlerPrjSpecificIdentRegistryRead ( tCString name, tU8 sid, tU8 did )
   : dia_ServiceHandlerUDS(name,sid,(tU8) did)
{
#ifdef __DIA_UNIT_TESTING__
   dia_tclFnctTrace trc("dia_SrvHandlerPrjSpecificIdentRegistryRead::dia_SrvHandlerPrjSpecificIdentRegistryRead(tCString,tU8,tU8)");
#endif
}

//-----------------------------------------------------------------------------

dia_SrvHandlerPrjSpecificIdentRegistryRead::dia_SrvHandlerPrjSpecificIdentRegistryRead ( tCString name, tU8 sid, tU16 did )
   : dia_ServiceHandlerUDS(name,sid,did)
{
#ifdef __DIA_UNIT_TESTING__
   dia_tclFnctTrace trc("dia_SrvHandlerPrjSpecificIdentRegistryRead::dia_SrvHandlerPrjSpecificIdentRegistryRead(tCString,tU8,tU16)");
#endif
}

//-----------------------------------------------------------------------------

dia_SrvHandlerPrjSpecificIdentRegistryRead::~dia_SrvHandlerPrjSpecificIdentRegistryRead ( void )
{}

//-----------------------------------------------------------------------------

void
dia_SrvHandlerPrjSpecificIdentRegistryRead::vProcessRequest ( const std::vector<tArgsType>& vecArgs )
{
   dia_tclFnctTrace trc("dia_SrvHandlerPrjSpecificIdentRegistryRead::vOnProcessRequest");

   // data length contains at least sid, ctrl byte and DID --> 4 bytes minimum
   tU16 dataLength = oDiagMsgBuffer().u16GetDataLength();
   if ( dataLength !=  (DIA_U16_READDATA_BY_ID_REQUEST_LENGTH + 1) ) // one additional byte contains the message length
   {
      DIA_TR_INF("dia_SrvHandlerPrjSpecificIdentRegistryRead::vOnProcessRequest INVALID LENGTH. EXPECTED %d B BUT RECEIVED %d B !", (DIA_U16_READDATA_BY_ID_REQUEST_LENGTH+1), dataLength);
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT));
      return;
   }

   if ( vecArgs.size() )
   {
      tU32 propID = VoidCast<tU32>(vecArgs[0]);

      // data memory - holds ASCII data read from registry
      std::vector<tU8> dataVecIn;
	  
      // retrieve size of property
      tU16 length = dia_getPropertySize(propID);

      // temporary buffer to store the registry data that will be later used to convert from ascii to hex
      tU8 tmp_buf[length];
      
      dataVecIn.clear();
      dataVecIn.reserve(length);

      tDiaResult retCode = dia_getProperty(propID,dataVecIn);
  
      if ( retCode == DIA_SUCCESS )
      {
         // copy the registry data into the temporary buffer
         for(int j = 0; j < dataVecIn.size(); j++)
         {
            tmp_buf[j] = dataVecIn[j];
         }

         unsigned long xVal = strtoul(reinterpret_cast<const char*>(tmp_buf), 0, DIA_C_BASE_FORMAT_HEXADECIMAL);

         DIA_TR_INF("#### Version Info -> Year : %d | Calendar Week : %d | Patch Level : %d ####", (xVal >> 16), (tU8)(xVal >> 8), (tU8)xVal);

         // Sending back the positive answer
         oDiagMsgBuffer().vSetPosResp();
         oDiagMsgBuffer().vSetDataLength(static_cast<tU16>(DIA_U16_READDATA_BY_ID_REQUEST_LENGTH + DIA_C_CUST_SW_VER_CMC_RESP_LEN));
		 
         // Fill Response Buffer
         for(int j = 0; j < DIA_C_CUST_SW_VER_CMC_RESP_LEN; j++)
         {
            (void) oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DIA_U16_READDATA_BY_ID_REQUEST_LENGTH + j), (xVal >> (8 * (2-j))));
         }
         
         vResReadyAndQuit();
      }
      else
      {
         DIA_TR_INF("dia_SrvHandlerPrjSpecificIdentRegistryRead::vOnProcessRequest UNABLE TO READ ITEM (READ OPERATION FAILED) !!");
         vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));
      }
   }
   else
   {
      DIA_TR_INF("dia_SrvHandlerPrjSpecificIdentRegistryRead::vOnProcessRequest UNABLE TO READ ITEM (PROPERTY NOT PASSED AS PARAMETER !!");
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));
   }
}
