/*
 * dia_SrvHandlerPrjSpecificECUSerialNumberReadRead.cpp
 *
 *  Created on: Oct 23, 2018
 *      Author: mky6kor
 *   TTFis:\> DIA_REQ UDS 04 22 F1 8C
 */
#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif
#ifndef __INCLUDED_DIA_DEFS_PROJECTCONFIG_
#include <project/framework/config/dia_defsProjectConfig.h>
#endif
#ifndef __INCLUDED_SERVICE_HANDLER_PRJ_SPECIFIC_ECU_SERIALNUMBER_READ__
#include "dia_SrvHandlerPrjSpecificECUSerialNumberRead.h"
#endif

#define CMC_19_ECU_SERIAL_NUMBER_LENGTH 10
#define CMC_19_ECU_SERIAL_NUMBER_INCREMENT 3
#define DIA_U16_READDATA_BY_ID_REQUEST_LENGTH ((tU16) (1 + mDIDLen))

dia_SrvHandlerPrjSpecificECUSerialNumberRead::dia_SrvHandlerPrjSpecificECUSerialNumberRead(tCString name, tU8 sid, tU16 did )
: dia_ServiceHandlerUDS(name,sid,did)
{
	// TODO Auto-generated constructor stub
	dia_tclFnctTrace trc("dia_SrvHandlerPrjSpecificECUSerialNumberRead::dia_SrvHandlerPrjSpecificECUSerialNumberRead(tCString,tU8,tU16)");
}

dia_SrvHandlerPrjSpecificECUSerialNumberRead::~dia_SrvHandlerPrjSpecificECUSerialNumberRead() {
	// TODO Auto-generated destructor stub
	DIA_TR_INF("dia_SrvHandlerPrjSpecificECUSerialNumberRead::~dia_SrvHandlerPrjSpecificECUSerialNumberRead(void)");
}

void dia_SrvHandlerPrjSpecificECUSerialNumberRead::vProcessRequest ( const std::vector<tArgsType>& vecArgs  )
{
	dia_tclFnctTrace trc("dia_SrvHandlerPrjSpecificECUSerialNumberRead::vProcessRequest");

	tDiaResult retCode=DIA_FAILED;

	tU8 u8tempPropData[DIA_PROP_LENGTH_MAX] = {0};
	// initialize the data memory
	(void) ::memset(u8tempPropData,0,DIA_PROP_LENGTH_MAX);
	tU8 u8propData[DIA_PROP_LENGTH_MAX]={0x30};// Coverity Fix(CID:214209)
	// initialize the data memory
		std::fill_n(u8propData, DIA_PROP_LENGTH_MAX, 0x30);

	auto length = dia_getPropertySize(DIA_PROP_CM_ECU_SERIAL_NR);

	retCode = dia_getProperty(DIA_PROP_CM_ECU_SERIAL_NR,u8tempPropData,&length);

	if(retCode==DIA_SUCCESS)
	{
		for(tS16 s16Count=0; s16Count<length; ++s16Count)
		{
			u8propData[s16Count+CMC_19_ECU_SERIAL_NUMBER_INCREMENT] = u8tempPropData[s16Count];
		}
	}
	else
	{
		vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));
		DIA_TR_INF("dia_SrvHandlerPrjSpecificECUSerialNumberRead::vProcessRequest UNABLE TO READ ITEM ");
	}

	oDiagMsgBuffer().vSetPosResp();
	oDiagMsgBuffer().vSetDataLength(static_cast<tU16>(DIA_U16_READDATA_BY_ID_REQUEST_LENGTH + CMC_19_ECU_SERIAL_NUMBER_LENGTH));
	for (tS16 s16Count = 0; s16Count < CMC_19_ECU_SERIAL_NUMBER_LENGTH; ++s16Count)
	{
		(void) oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DIA_U16_READDATA_BY_ID_REQUEST_LENGTH+s16Count), u8propData[s16Count]);
	}
	vResReadyAndQuit();

}

