/*
 * dia_SrvHandlerPrjSpecificActiveDiagInfoRead.cpp
 *
 *  Created on: Nov 28, 2018
 *      Author: MKY6KOR
 */

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_MANAGER__
#include "common/framework/engine/dia_EngineManager.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include "common/framework/engine/dia_EngineServer.h"
#endif

#ifndef __INCLUDED_DIA_SESSION__
#include "common/framework/engine/dia_Session.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#ifndef __INCLUDED_SERVICE_HANDLER_PRJ_SPECIFIC_ACTIVE_DIAG_INFO_READ__
#include "dia_SrvHandlerPrjSpecificActiveDiagInfoRead.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include "common/framework/config/dia_defsConfig.h"
#endif

#define DATA_START 3
#define DATA_LENGTH 4


static const tU8 PartNo72[] = {55,54,50,48,51,53,48,48,55,50}; // 7620350072
static const tU8 PartNo77[] = {55,54,50,48,51,53,48,48,55,55}; // 7620350077

dia_SrvHandlerPrjSpecificActiveDiagInfoRead::dia_SrvHandlerPrjSpecificActiveDiagInfoRead(void)
: dia_ServiceHandlerUDS("dia_SrvHandlerPrjSpecificActiveDiagInfoRead",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,(tU16) DIA_C_U16_DID_CENTER_CMC_19_ACTIVE_DIAGNOSTIC_INFO)
{
	// TODO Auto-generated constructor stub
	dia_tclFnctTrace trc("dia_SrvHandlerPrjSpecificActiveDiagInfoRead::dia_SrvHandlerPrjSpecificActiveDiagInfoRead(void)");
}

dia_SrvHandlerPrjSpecificActiveDiagInfoRead::~dia_SrvHandlerPrjSpecificActiveDiagInfoRead() {
	// TODO Auto-generated destructor stub
	DIA_TR_INF("dia_SrvHandlerPrjSpecificActiveDiagInfoRead::~dia_SrvHandlerPrjSpecificActiveDiagInfoRead(void)");
}


void dia_SrvHandlerPrjSpecificActiveDiagInfoRead::vProcessRequest ( const std::vector<tArgsType>& vecArgs  )
{
	dia_tclFnctTrace trc("dia_SrvHandlerPrjSpecificActiveDiagInfoRead::vProcessRequest");

	tU8 identificationVersion = 0x01;
	tU8 identificationVariant = 0x01;
	tU8 identificationModeGateway=0x00;
	tU8 i,flag = 1;
	std::vector<tU8> partNumDev;

    tDiaResult retCode = dia_getProperty ( DIA_PROP_CM_VARIANT_ID, partNumDev);
	if(retCode == DIA_SUCCESS)
	{
		for(i = 0;i < 10; i++)
		 {
			if(PartNo72[i] != partNumDev[i])
			 {
				flag = 0;
				break;
			 }
		 }

		if(flag == 1) // only for variant 7620350072
		{
				identificationVersion = 0x00;
				identificationVariant = 0x08;
		}
		else{
		// Flag will be 0 for 7620350077. Now check for 762035077
		flag = 1;
		for (i = 0; i < 10; i++)
		{
			if(PartNo77[i] != partNumDev[i])
			{
				flag = 0;
				break;
			}
			if(flag == 1) //only for variant 7620350077
			{
				identificationVersion = 0x00;
				identificationVariant = 0x08;
			}
		}
		}

	}

	tU8 activeSesssion = getActiveSessionID();
	if (DIA_C_U8_UDS_SESSION_INVALID == activeSesssion)
	{
		DIA_TR_INF("dia_SrvHandlerPrjSpecificActiveDiagInfoRead::vProcessRequest FAILED TO GET ACTIVE DIAGNOSTIC SESSION !");
		vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));
	}
	else
	{
		oDiagMsgBuffer().vSetPosResp();
		oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);
		(void) oDiagMsgBuffer().vSetDataU8(DATA_START+DIA_EN_BYTE_0, identificationModeGateway);
		(void) oDiagMsgBuffer().vSetDataU8(DATA_START+DIA_EN_BYTE_1, identificationVariant);
		(void) oDiagMsgBuffer().vSetDataU8(DATA_START+DIA_EN_BYTE_2, identificationVersion);
		(void) oDiagMsgBuffer().vSetDataU8(DATA_START+DIA_EN_BYTE_3, activeSesssion);
		vResReadyAndQuit();
	}

}

tU8
dia_SrvHandlerPrjSpecificActiveDiagInfoRead::getActiveSessionID(void)
{
   dia_tclFnctTrace oTrace("dia_SrvHandlerPrjSpecificActiveDiagInfoRead::getActiveSessionID()");

   tU8 sessionID = DIA_C_U8_UDS_SESSION_INVALID; //invalid session ID

   dia_EngineServer* pEngine = 0;
   if ( getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&pEngine) != DIA_SUCCESS )
   {
      DIA_TR_ERR("dia_SrvHandlerPrjSpecificActiveDiagInfoRead::getActiveSessionID FAILED TO GET ACTIVE DIAGNOSTIC SESSION !!!!");
   }
   else
   {
      if (NULL!=pEngine)
      {
    	  sessionID = pEngine->getActiveSession()->getID();
      }
      else
      {
         DIA_TR_ERR("dia_SrvHandlerPrjSpecificActiveDiagInfoRead::getActiveSessionID pEngine is NULL.");
      }
   }

   DIA_TR_INF("dia_SrvHandlerPrjSpecificActiveDiagInfoRead::getActiveSessionID returned 0x%02X.", sessionID);

   return sessionID;
}
