/*!
* \file       dia_SrvHandlerHardwareSupplierIdentRead.cpp
*
* \brief      Service Handler for reading Software Supplier Information
*
* \details    Class file
*
* \author     Hme4kor
*
* \component  Diagnosis
*
* \ingroup
*
* \copyright  (c) 2018 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
*/

// TTFis: DIA_REQ UDS 03 22 F1 54

#ifndef __INCLUDED_SERVICE_HANDLER_HARDWARE_SUPPLIER_IDENT_READ__
#include "project/services/customer/dia_SrvHandlerHardwareSupplierIdentRead.h"
#endif 

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#define DATA_SIZE (1/*sizeof(SID)*/ + mDIDLen)
#define SUPPLIER_INFO_SIZE 2
#define HARDWARE_SUPPLIER_NAME_PART1 0x00
#define HARDWARE_SUPPLIER_NAME_PART2 0x03

//-----------------------------------------------------------------------------

dia_SrvHandlerHardwareSupplierIdentRead::dia_SrvHandlerHardwareSupplierIdentRead ( tCString name, tU8 sid, tU16 did )
    : dia_SrvHandlerGenericIdentRead(name,sid,did)
{
   dia_tclFnctTrace trc("dia_SrvHandlerHardwareSupplierIdentRead::dia_SrvHandlerHardwareSupplierIdentRead(tCString,tU8,tU16)");
}
//-----------------------------------------------------------------------------

dia_SrvHandlerHardwareSupplierIdentRead::~dia_SrvHandlerHardwareSupplierIdentRead ( void )
{
}

//-----------------------------------------------------------------------------

void
dia_SrvHandlerHardwareSupplierIdentRead::vProcessRequest ( const std::vector<void*>& vecArgs )
{
   dia_tclFnctTrace trc("dia_SrvHandlerHardwareSupplierIdentRead::vOnProcessRequest");

   // data length contains at least sid, ctrl byte and DID --> 4 bytes minimum
   tU16 dataLength = oDiagMsgBuffer().u16GetDataLength();
   if ( dataLength !=  (DATA_SIZE + 1) ) // one additional byte contains the message length
   {
      DIA_TR_INF("dia_SrvHandlerHardwareSupplierIdentRead::vOnProcessRequest INVALID LENGTH. EXPECTED %d B BUT RECEIVED %d B !", (DATA_SIZE+1), dataLength);
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT));
      return;
   }

   if ( vecArgs.size() )
   {
	   const tU8 hardwareSupplierInformation[SUPPLIER_INFO_SIZE + 1] = { HARDWARE_SUPPLIER_NAME_PART1, HARDWARE_SUPPLIER_NAME_PART2 }; //BOSCH:0x03
	   oDiagMsgBuffer().vSetPosResp();
	   oDiagMsgBuffer().vSetDataLength(DATA_SIZE + SUPPLIER_INFO_SIZE);

	   for (tU8 i = 0; i<SUPPLIER_INFO_SIZE; i++)
	   {
		   (tVoid)oDiagMsgBuffer().vSetDataU8(DATA_SIZE + i, hardwareSupplierInformation[i]);
	   }
	  
	  vResReadyAndQuit();
   }
   else
   {
      DIA_TR_INF("dia_SrvHandlerHardwareSupplierIdentRead::vOnProcessRequest UNABLE TO READ ITEM (PROPERTY NOT PASSED AS PARAMETER !!");
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));
   }

}


