/*!
 * \file       dia_SrvHandlerGenericReadFaultMemoryCMC.h
 *
 * \brief      Special handling for A-IVI project in Programming Session (NRC 0x12 instead of NRC 0x7E according to UDS)
 *
 * \details
 *
 * \component  Diagnosis
 *
 * \ingroup    Service Handler for Session Switch
 *
 * \copyright  (c) 2017 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef DIA_SRV_HANDLER_GENERIC_READ_FAULT_MEMORY_CMC_H_
#define DIA_SRV_HANDLER_GENERIC_READ_FAULT_MEMORY_CMC_H_

#define DIA_M_MAKE_ODOMETER_VALUE_RAW(A, B, C, D) (tU32)(((A<<24) | (B<<16)| (C<<8) | D))
#define DIA_M_MAKE_ODOMETER_VALUE_PHY(A) (tU32)(A / 8)
#define DIA_ODOMETER_MAX_VALID			 (tU16)(0xFFFD)
#define DIA_ODOMETER_FACTOR				 (tU8)0x10
#define DIA_MAX_READ_DTC_COUNTER		 (tU8)0xFE
#define DIA_HIST_INT_REC_LEN                   ((tU8)3)



#ifndef __INCLUDED_DIA_INTERFACE_ERRORLOG_LISTENER__
#include "common/services/uds/generic/dia_SrvHandlerGenericReadFaultMemory.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_VEHICLECLIENT_LISTENER__
#include "project/interfaces/dia_IVehicleClientListener.h"
#endif

class dia_SrvHandlerGenericReadFaultMemoryCMC
    : public dia_SrvHandlerGenericReadFaultMemory,
      public dia_IVehicleClientListenerImpl
{
    DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SrvHandlerGenericReadFaultMemoryCMC);
    DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandlerGenericReadFaultMemoryCMC);

public:
   //! class constructor
    dia_SrvHandlerGenericReadFaultMemoryCMC ( const tU8 u8DID );
   //! class destructor
   virtual ~dia_SrvHandlerGenericReadFaultMemoryCMC ( void );

   virtual void vProcessRequest ( const std::vector<void*>& vecArgs );

   virtual void vUpdateHistoricalInterrogationRecord(void);

   /*Update DTC Read Counter*/
   virtual void	vUpdateDTCReadCounter( std::vector <tU8> &dataVec);
   /*Update Odometer Value*/
   virtual void vUpdateOdometer();

   //! reply on getting total distance info from CAN
   virtual void vOnTotalVehDistDiag ( tU32 /*TotalVehDistDiagValue*/ );

private:
   virtual tU8 getActiveSessionID(void);

protected:
   std::vector<tU8> dataVec;
};


#endif /* DIA_SRV_HANDLER_GENERIC_READ_FAULT_MEMORY_CMC_H_ */
