/*
*  Created on: Jan 18, 2019
*      Author: hgr6kor
*
*!
* \file       dia_SrvHandlerCompatibilityListRead.cpp
*
* \brief      Service Handler for reading Compatibility List Information
*
* \details    Class file
*
* \component  Diagnosis
*
* \ingroup
*
* \copyright  (c) 2018 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
*/

// TTFis: DIA_REQ UDS 03 22 E0 00

#ifndef DIAG_PRJ_PROJECT_SERVICES_CUSTOMER_DIA_SRVHANDLERCOMPATIBILITYLISTREAD_H_
#include "project/services/customer/dia_SrvHandlerCompatibilityListRead.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#define DATA_SIZE (1/*sizeof(SID)*/ + mDIDLen)
#define COMPATIBILITY_LIST_SIZE 3
#define COMPATIBILITY_LIST_ECU_SW_MODE		0u
#define COMPATIBILITY_LIST_ECU_GATEWAY		0u
#define COMPATIBILITY_LIST_RESERVED_BITS	0u
#define COMPATIBILITY_LIST_CUR_DIAG_VER 	1
#define COMPATIBILITY_LIST_ECU_VARIANT  	1

//-----------------------------------------------------------------------------

dia_SrvHandlerCompatibilityListRead::dia_SrvHandlerCompatibilityListRead ( tCString name, tU8 sid, tU16 did )
    : dia_SrvHandlerGenericIdentRead(name,sid,did)
{
   dia_tclFnctTrace trc("dia_SrvHandlerCompatibilityListRead::dia_SrvHandlerCompatibilityListRead(tCString,tU8,tU16)");
}
//-----------------------------------------------------------------------------

dia_SrvHandlerCompatibilityListRead::~dia_SrvHandlerCompatibilityListRead ( void )
{
}

//-----------------------------------------------------------------------------

void
dia_SrvHandlerCompatibilityListRead::vProcessRequest ( const std::vector<void*>& vecArgs )
{
   dia_tclFnctTrace trc("dia_SrvHandlerCompatibilityListRead::vOnProcessRequest");

   if ( vecArgs.size() )
   {
	   const tU8 CompatibilityListInfo[COMPATIBILITY_LIST_SIZE] = {  (COMPATIBILITY_LIST_ECU_SW_MODE||COMPATIBILITY_LIST_ECU_GATEWAY||COMPATIBILITY_LIST_RESERVED_BITS),COMPATIBILITY_LIST_ECU_VARIANT, COMPATIBILITY_LIST_CUR_DIAG_VER };
	   oDiagMsgBuffer().vSetPosResp();
	   oDiagMsgBuffer().vSetDataLength(DATA_SIZE + COMPATIBILITY_LIST_SIZE);

	   for (tU8 i = 0; i<COMPATIBILITY_LIST_SIZE; i++)
	   {
		   (tVoid)oDiagMsgBuffer().vSetDataU8(DATA_SIZE + i, CompatibilityListInfo[i]);
	   }

	  vResReadyAndQuit();
   }
   else
   {
      DIA_TR_INF("dia_SrvHandlerCompatibilityListRead::vOnProcessRequest UNABLE TO READ ITEM (PROPERTY NOT PASSED AS PARAMETER !!");
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));
   }

}


