/*
 * dia_RtCtrlGetBT_SigQ_RSSI.h
 *
 *  Created on: Dec 20, 2016
 *      Author: ogm5kor
 */

#ifndef DIA_RTCTRLGETBT_SIGQ_RSSI_H_
#define DIA_RTCTRLGETBT_SIGQ_RSSI_H_

#ifndef __INCLUDED_DIA_COMMON_UDS_RTCTRL__
#include <common/framework/protocols/uds/rtctrl/dia_common_uds_rtctrl.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_BLUETOOTH_LISTENER__
#include <project/interfaces/dia_IBluetoothListener.h>
#endif

#define DIA_SIZE_OF_MAC_ADDRESS (6U)
#define RT_STATUS_RECORD    0x10

class dia_RtCtrlGetBT_SigQ_RSSI : public dia_Routine,
                                  public dia_IBluetoothListenerImpl

{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_RtCtrlGetBT_SigQ_RSSI);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_RtCtrlGetBT_SigQ_RSSI);

   private:
      tU8 macAddr[DIA_SIZE_OF_MAC_ADDRESS];

   public:
      //! start the specified routine
      virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class
      //! return control back to the ECU for the specified signal
      virtual tDiaResult requestResult ( std::vector<tU8>& results );
      //! handle timeout from UDS session object
      virtual void vOnServiceTimeout ( void );

      virtual void vOnBT_SigQ_RSSI ( const  tU8 u8SigQ, tU8 u8RSSI );

      virtual void vOnBT_SigQ_RSSIError(const tU32 errCode );
};

#endif /* DIA_RTCTRLGETBT_SIGQ_RSSI_H_ */
