/*!
 * \file       dia_RtCtrlChangeTpBlockSize.h
 *
 * \brief      service handler for routine control BOOT BS AND STMIN / BOOT Specific BS AND STMIN
 *
 * \details    this service requests the CSM to change the ISO-TP parameter BS
 *
 * \component  Diagnosis
 *
 * \ingroup    diaServicesProject
 *
 * \copyright  (c) 2017 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_CHANGE_TP_BLOCK_SIZE__
#define __INCLUDED_DIA_ROUTINE_CTRL_CHANGE_TP_BLOCK_SIZE__

#ifndef __INCLUDED_DIA_ROUTINE__
#include "common/framework/protocols/uds/rtctrl/dia_Routine.h"
#endif

class csm_tclCsmAccessUser;

class dia_RtCtrlChangeTpBlockSize
   : public dia_Routine
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_RtCtrlChangeTpBlockSize);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_RtCtrlChangeTpBlockSize);

public:
   dia_RtCtrlChangeTpBlockSize ( tCString name, tU16 udsID );

   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class
   //! return control back to the ECU for the specified signal
   virtual tDiaResult requestResult ( std::vector<tU8>& results );

protected:
   csm_tclCsmAccessUser*   m_pCsmAccessUser;
};

#endif /* __INCLUDED_DIA_ROUTINE_CTRL_CHANGE_TP_BLOCK_SIZE__ */
