/*!
 * \file       dia_RtCtrlChangeTpBlockSize.cpp
 *
 * \brief      service handler for routine control BOOT BS AND STMIN / BOOT Specific BS AND STMIN
 *
 * \details    this service requests the CSM to change the ISO-TP parameter BS
 *
 * \component  Diagnosis
 *
 * \ingroup    diaServicesProject
 *
 * \copyright  (c) 2017 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_COMMON_UDS_RTCTRL__
#include <common/framework/protocols/uds/rtctrl/dia_common_uds_rtctrl.h>
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_CHANGE_TP_BLOCK_SIZE__
#include "dia_RtCtrlChangeTpBlockSize.h"
#endif

#define CSM_S_IMPORT_INTERFACE_GENERIC_USER
#include "csm_if.h"

#define routineStatusRecord 0x10


//------------------------------------------------------------------------------

dia_RtCtrlChangeTpBlockSize::dia_RtCtrlChangeTpBlockSize (tCString name, tU16 udsID)
   : dia_Routine(name, udsID),
     m_pCsmAccessUser(NULL)
{
   dia_tclFnctTrace oTrace("dia_RtCtrlChangeTpBlockSize::dia_RtCtrlChangeTpBlockSize()");

   m_pCsmAccessUser = new csm_tclCsmAccessUser();
   if (m_pCsmAccessUser != NULL)
   {
      // register with CSM_Proxy
      m_pCsmAccessUser->vApplCallbackPreInit();
   }
}

//------------------------------------------------------------------------------

dia_RtCtrlChangeTpBlockSize::~dia_RtCtrlChangeTpBlockSize ( void )
{
   _BP_TRY_BEGIN
   {
      if(m_pCsmAccessUser)
     {
         delete m_pCsmAccessUser;
         m_pCsmAccessUser = NULL;
      }
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_RtCtrlChangeTpBlockSize::~dia_RtCtrlChangeTpBlockSize !!!");
      NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
dia_RtCtrlChangeTpBlockSize::start ( std::vector<tU8>& params, tU8 /*timerValue*/ )
{
   dia_tclFnctTrace oTrace("dia_RtCtrlChangeTpBlockSize::start()");

   tDiaResult retCode = DIA_SUCCESS;
   tU8 u8AllianceBootBSDefinedValue = 0;

   // prepare processing of the routine
   vInitialize();

   switch ( params.size() )
   {
   case 0: //Switch BS to 0
      break;

   case 1:
      switch (params[0])
      {
      case 0:
      case 1:
      case 4:
      case 8:
      case 16:
      case 24:
      case 32:
      case 48:
         u8AllianceBootBSDefinedValue = params[0];
         break;

      default:
         retCode = DIA_E_OUT_OF_RANGE;
         break;
      }
      break;

   default:
      retCode = DIA_E_OUT_OF_RANGE;
      break;
   }

   if (retCode == DIA_SUCCESS)
   {
      // create the CSM_Proxy Class

      if (m_pCsmAccessUser != NULL)
      {
         tCSM_ADDR_ISO_TP abAddressField = {
               0x00,//CSM_C_ADDRESS_FIELD_LCTRL_SET_ISOTP_BS_REMOTE,/** Task 239541 **/
               0xFF//CSM_C_ADDRESS_FIELD_LCTRL_INVALID/** Task 239541 **/
         };

         tU8 abData[] = {
               0x00,//CSM_C_ISOTP_BS_CHN_00,/** Task 239541 **/
               u8AllianceBootBSDefinedValue
         };

         tS32 s32Result = m_pCsmAccessUser->s32DataReq ( 0x00,//CSM_C_PTYPE_RN_CAN_LOCAL_CTRL,/** Task 239541 **/
                  (const void*) &abAddressField, &abData[0], sizeof(abData) );

         if (s32Result)
         {
            DIA_TR_ERR("dia_RtCtrlChangeTpBlockSize::start --- CSM_Proxy::s32DataReq failed with 0x%x!!!", s32Result);
            retCode = DIA_FAILED;
         }
         else
         {
            eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
            mIsResultReady = TRUE;
         }
      }
      else
      {
         DIA_TR_ERR("dia_RtCtrlChangeTpBlockSize::start --- CSM_Proxy object not available!!!");
         retCode = DIA_FAILED;
      }
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_RtCtrlChangeTpBlockSize::requestResult ( std::vector<tU8>& results )
{
   dia_tclFnctTrace oTrace("dia_RtCtrlChangeTpBlockSize::requestResult()");

   tDiaResult retCode = DIA_E_ROUTINE_SUBFUNCTION_NOT_SUPPORTED;

   DIA_TR_INF("dia_RtCtrlChangeTpBlockSize::requestResult: mStatus = %d", mStatus);

   results.clear();
   if ( !(mResults.empty()) )
   {
      DIA_TR_INF("requestResult --- 1");
      std::vector<tU8>::iterator iter = mResults.begin();
      for ( ; iter != mResults.end(); iter++ )
      {
         results.push_back(*iter);
      }
      mResults.clear();
      retCode = DIA_SUCCESS;
   }
   else
   {
      DIA_TR_INF("requestResult --- 2");
      switch ( mStatus )
      {
      case DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK:
      case DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK:
         {
            results.push_back(routineStatusRecord);
            mIsResultReady = FALSE;
            retCode = DIA_SUCCESS;
         }
         break;

      default:
         DIA_TR_INF("requestResult --- 4");
         break;
      }
   }

   return retCode;
}

