/*!
 * \file       dia_FactoryPluginSubsystemLogoInstallation.h
 *
 * \brief      subsystem logo installation service handler
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    cis subsystem hmi logo installation
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       23.03.2020
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_RTCTRL_SUBSYSTEM_LOGO_INSTALLATION__
#define __INCLUDED_DIA_RTCTRL_SUBSYSTEM_LOGO_INSTALLATION__

#ifndef __INCLUDED_DIA_ROUTINE__
#include "common/framework/protocols/uds/rtctrl/dia_Routine.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SUBSYSTEM_LOGO_INSTALLATION_LISTENER__
#include "project/interfaces/dia_ISubsystemLogoInstallationListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SESSION_LISTENER__
#include <common/interfaces/dia_ISessionListener.h>
#endif

#ifndef __INCLUDED_DIA_DEFINES_SUBSYSTEM_LOGO_INSTALLATION__
#include <project/framework/cis/logoinstallation/dia_defsSubsystemLogoInstallation.h>
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_MANAGER__
#include "project/framework/cis/logoinstallation/dia_SubsystemLogoInstallationManager.h"
#endif

class dia_RoutineCtrlSubsystemLogoInstallation
	: public dia_Routine,
	  public dia_ISubsystemLogoInstallationListenerImpl,
	  public dia_ISessionListenerImpl
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_RoutineCtrlSubsystemLogoInstallation);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_RoutineCtrlSubsystemLogoInstallation);

public:
   
   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue = DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class
   
   virtual tDiaResult requestResult  ( std::vector<tU8>& results );
   
   virtual tDiaResult requestResult  ( void ) override ;
   
   //! called by the session control object to notify about a session change
   virtual void vOnSessionChanged ( tU8 newSession, tU8 oldSession );
   

protected:

   //! CMC Hu startup logo change
   virtual tDiaResult cmcStartuplogoChange( tU8 logoOption );
   //! register for session changes
   virtual tDiaResult registerSessionChange( void );
   //! unregister for session changes
   virtual tDiaResult unregisterSessionChange( void );
   
   //virtual void vOnHMIStartupLogoRequestUpdate ( dia_eIdentifyEntitiesRoutineStatus /* status */);
   //static const std::map<const dia_eIdentifyEntitiesRoutineStatus, const dia_eRoutineStatus> _HMI_Startup_logo_RoutineStatus_Map;

private:
   bool _started;
   //! local lgoo option ID
   tU8  mLogoOptionID;
};
#endif /* __INCLUDED_DIA_RTCTRL_SUBSYSTEM_LOGO_INSTALLATION__ */
