/*!
 * \file       dia_FactoryPluginSubsystemLogoInstallation.h
 *
 * \brief      subsystem logo installation service handler
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    cis subsystem hmi logo installation
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       23.03.2020
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef  __INCLUDED_DIA_RTCTRL_SUBSYSTEM_LOGO_INSTALLATION__
#include "project/services/customer/dia_RoutineCtrlSubsystemLogoInstallation.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_UDS_RTCTRL__
#include <common/framework/protocols/uds/rtctrl/dia_common_uds_rtctrl.h>
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_MANAGER__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineCtrlManager.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include <common/framework/engine/dia_EngineServer.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_MANAGER__
#include <common/framework/engine/dia_EngineManager.h>
#endif

#ifndef __INCLUDED_DIA_SESSION__
#include <common/framework/engine/dia_Session.h>
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_MANAGER__
#include "project/framework/cis/logoinstallation/dia_SubsystemLogoInstallationManager.h"
#endif

#ifndef __INCLUDED_DIA_FILE_DIR__
#include <common/framework/application/dia_FileDir.h>
#endif

#ifndef __INCLUDED_DIA_FILE__
#include "common/framework/application/dia_File.h"
#endif

static tU8 sRoutineResultMapping[DIA_EN_RTCTRL_STATUS_COUNT] = {
		0xFF, // DIA_EN_RTCTRL_STATUS_UNKNOWN
		0xFF, // DIA_EN_RTCTRL_STATUS_IDLE
		0x03, // DIA_EN_RTCTRL_STATUS_IN_PROGRESS
		0x00, // DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK
		0x01, // DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK
		0x02, // DIA_EN_RTCTRL_STATUS_ABORTED
		0xFF  // DIA_EN_RTCTRL_STATUS_TIMED_OUT
};

//------------------------------------------------------------------------------

/*
const std::map<const dia_eIdentifyEntitiesRoutineStatus, const dia_eRoutineStatus> dia_RoutineCtrlSubsystemLogoInstallation::_HMI_Startup_logo_RoutineStatus_Map =
{
	{ DIA_EN_IDENTIFY_ENTITIES_UNKNOWN, 	DIA_EN_RTCTRL_STATUS_ABORTED			},
	{ DIA_EN_IDENTIFY_ENTITIES_RUNNING, 	DIA_EN_RTCTRL_STATUS_IN_PROGRESS		},
	{ DIA_EN_IDENTIFY_ENTITIES_NOK, 		DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK	},
	{ DIA_EN_IDENTIFY_ENTITIES_OK, 			DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK	},
	{ DIA_EN_IDENTIFY_ENTITIES_ABORTED, 	DIA_EN_RTCTRL_STATUS_ABORTED			},
	{ DIA_EN_IDENTIFY_ENTITIES_TIMED_OUT, 	DIA_EN_RTCTRL_STATUS_TIMED_OUT			}
};
*/
//-----------------------------------------------------------------------------------------------

#include <sys/wait.h>

static const std::string CMC_Setra_logo("/var/opt/bosch/persistent/avdecc/cisinstallation/Setra_Logo_Monitoranzeige_800x480px.mp4");
static const std::string CMC_Benz_logo("/var/opt/bosch/persistent/avdecc/cisinstallation/MBmBusClaim800x480px_191118.mp4");
static const std::string CMC_Current_logo("/var/opt/bosch/persistent/avdecc/oem_logo.mp4");
static const std::string CMC_Original_logo("/var/opt/bosch/persistent/avdecc/bk_oem_logo.mp4");

#define CMC_STARTUP_LOGO_OPTION_SETRA          (( tU8) 0x00)
#define CMC_STARTUP_LOGO_OPTION_BENZ 		   (( tU8) 0x01)


//-------------------------------------------------------------------------------------------------------
dia_RoutineCtrlSubsystemLogoInstallation::dia_RoutineCtrlSubsystemLogoInstallation( void )
: dia_Routine("dia_RoutineCtrlSubsystemLogoInstallation", DIA_C_U16_DID_CENTER_CMC_19_CIS_HMI_STARTUP_LOGO_INSTALLATION, DIA_EN_RTCTRL_ID_PROJECT_15, DIA_EN_RTCTRL_TYPE_LONG_TERM),
_started(false),
mLogoOptionID(0)
{
	dia_tclFnctTrace oTrace("dia_RoutineCtrlSubsystemLogoInstallation::dia_RoutineCtrlSubsystemLogoInstallation");
}
//------------------------------------------------------------------------------

dia_RoutineCtrlSubsystemLogoInstallation::~dia_RoutineCtrlSubsystemLogoInstallation( void )
{
	_BP_TRY_BEGIN
    {
		DIA_TR_INF("dia_RoutineCtrlSubsystemLogoInstallation::~dia_RoutineCtrlSubsystemLogoInstallation ");
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_RoutineCtrlSubsystemLogoInstallation::~dia_RoutineCtrlSubsystemLogoInstallation !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}
//-------------------------------------------------------------------------------------------------------
tDiaResult
dia_RoutineCtrlSubsystemLogoInstallation::start ( std::vector<tU8>& params, tU8 /*timerValue*/ )
{
	dia_tclFnctTrace oTrace("dia_RoutineCtrlSubsystemLogoInstallation::start");
	// prepare processing of the routine
	vInitialize();

	tDiaResult retCode = DIA_FAILED;

	mLogoOptionID = params[0];
	//! get the instance of CIS HMI Startup Logo manager
	dia_SubsystemLogoInstallationManager* pStartuplogoManager = getInstanceOfSubsystemLogoInstallationManager();

	if( !pStartuplogoManager )
	{
		// Sending back the negative response since CIS HMI Startup Logo manager is not available
		DIA_TR_ERR("dia_RoutineCtrlSubsystemLogoInstallation::start FAILED (NO ACCESS TO STARTUP LOGO MANAGER) !!");
		eSetStatus(DIA_EN_RTCTRL_STATUS_ABORTED);
		mIsResultReady = TRUE;
	}
	else
	{
		tU8 logo_id = params[0];
		retCode = pStartuplogoManager->startLogoInstallation(logo_id);	
	}
	
	switch(retCode)
	{
		case DIA_E_SUBSYSTEM_LOGO_ALREADY_REQUESTED:
		case DIA_E_SUBSYSTEM_LOGO_INSTALLATION_RUNNING:
		case DIA_SUCCESS:
		{
			eSetStatus(DIA_EN_RTCTRL_STATUS_IN_PROGRESS);
			// set the flag to be used incase request result called first
			_started = true;
			DIA_TR_INF("dia_RoutineCtrlSubsystemLogoInstallation::DIA_EN_RTCTRL_STATUS_IN_PROGRESS");
			
			retCode = DIA_SUCCESS;
		}
		break;
		
		case DIA_E_SUBSYSTEM_LOGO_INSTALLATION_INCORRECT_CONDITIONS:
		case DIA_E_SUBSYSTEM_LOGO_INSTALLATION_ABORTED:
		case DIA_FAILED:
		{
			eSetStatus(DIA_EN_RTCTRL_STATUS_ABORTED);
			DIA_TR_INF("dia_RoutineCtrlSubsystemLogoInstallation::DIA_EN_RTCTRL_STATUS_ABORTED");
			
			retCode = DIA_FAILED;
		}
		break;
		
		default:
		break;
	}

	//negative answer doesn't need any bytes in output buffer
	if (DIA_FAILED != retCode)
	{
		// one byte expected
		mResults.push_back(sRoutineResultMapping[eGetStatus()]);
		mIsResultReady = TRUE;
	}

	DIA_TR_INF("dia_RoutineCtrlSubsystemLogoInstallation::start retCode = 0x%08X", retCode);

	return retCode;
}

//--------------------------------------------------------------------------------------------------------

tDiaResult
dia_RoutineCtrlSubsystemLogoInstallation::requestResult ( void )
{
	dia_tclFnctTrace oTrace("dia_RoutineCtrlSubsystemLogoInstallation::requestResult(void)");

	tDiaResult retCode = DIA_FAILED;
	tU8 status = 0x01;
	
	// prepare processing of the routine
	vInitialize();

	if(_started == false)
	{
		return DIA_E_SEQUENCE_ERROR;
	}

	// get the instance of CIS HMI Startup Logo manager
	dia_SubsystemLogoInstallationManager* pStartuplogoManager = getInstanceOfSubsystemLogoInstallationManager();
	if( pStartuplogoManager )
	{
		//! Set the listener to get informed about the identified Subsystem later
		//if (setSysAdapterListener<dia_ISubsystemLogoInstallationListener>(this) == DIA_SUCCESS)
		//{
			retCode = pStartuplogoManager->requestLogoInstallationResults();
			
			switch(retCode)
			{
				case DIA_E_SUBSYSTEM_LOGO_INSTALLATION_RUNNING:
				{
					eSetStatus(DIA_EN_RTCTRL_STATUS_IN_PROGRESS);
					status = 0x00;
					DIA_TR_INF("::requestResult --> DIA_EN_RTCTRL_STATUS_IN_PROGRESS");
				}
				break;
		
				case DIA_E_SUBSYSTEM_LOGO_INSTALLATION_DOIP_CLIENT_NOT_AVAILABLE:
				case DIA_E_SUBSYSTEM_LOGO_INSTALLATION_ABORTED:
				{
					eSetStatus(DIA_EN_RTCTRL_STATUS_ABORTED);
					_started = false;
					DIA_TR_INF("::requestResult --> DIA_EN_RTCTRL_STATUS_ABORTED");
				}
				break;
				
				case DIA_E_SUBSYSTEM_LOGO_INSTALLATION_COMPLETED_NOK:
				{
					eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
					_started = false;
					DIA_TR_INF("::requestResult --> DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK");
				}
				break;
				
				case DIA_E_SUBSYSTEM_LOGO_INSTALLATION_COMPLETED_OK:
				{
					eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
					status = 0x00;
					_started = false;
					DIA_TR_INF("::requestResult --> DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK");
				}
				break;
			}

			if (retCode != DIA_E_SUBSYSTEM_LOGO_INSTALLATION_RUNNING )
			{
				/* Copy the New logo to CMC Hu*/
				retCode = cmcStartuplogoChange( mLogoOptionID );
				if(retCode == DIA_FAILED )
				{
					eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
				}

			}
		//}
		//else
		//{
			//DIA_TR_ERR("dia_RoutineCtrlSubsystemLogoInstallation --> querySysAdapterInterface returned NULL PTR");
		//}
	}
	else
	{
		DIA_TR_ERR("dia_RoutineCtrlSubsystemLogoInstallation --> FAILED (NO ACCESS TO SUBSYSTEM MANAGER) !!");
	}
	
	mResults.push_back(sRoutineResultMapping[eGetStatus()]);
	mResults.push_back(status);
	mIsResultReady = TRUE;
	
	return DIA_SUCCESS;
}

//-------------------------------------------------------------------------------------------------------
tDiaResult
dia_RoutineCtrlSubsystemLogoInstallation::requestResult ( std::vector<tU8>& results )
{
	dia_tclFnctTrace oTrace("dia_RoutineCtrlSubsystemLogoInstallation::requestResult");

	tDiaResult retCode = DIA_E_SEQUENCE_ERROR;
	results.clear();

	if ( !(mResults.empty()) )
	{
		/* this code is executed in case of reply for start request only */
		DIA_TR_INF("dia_RoutineCtrlSubsystemLogoInstallation::requestResult --- 1");

		std::vector<tU8>::iterator iter = mResults.begin();
		for ( ; iter != mResults.end(); iter++ )
		{
			results.push_back(*iter);
		}
		// clear buffer, such reply is necessary once
		mResults.clear();
		// prepare processing of the routine
		vInitialize();
		// keep the result until new calculation is started
		retCode = DIA_SUCCESS;
	}

	DIA_TR_INF("dia_RoutineCtrlSubsystemLogoInstallation::requestResult %s", (DIA_SUCCESS == retCode ? "DIA_SUCCESS": "DIA_E_SEQUENCE_ERROR"));
	return retCode;
}
//--------------------------------------------------------------------------------------------------------------------------------
/*
void dia_RoutineCtrlSubsystemLogoInstallation::vOnHMIStartupLogoRequestUpdate (dia_eIdentifyEntitiesRoutineStatus status)
{
	dia_tclFnctTrace oTrace("dia_RoutineCtrlSubsystemLogoInstallation::vOnHMIStartupLogoRequestUpdate");
	vInitialize();
	
	(void) unsetSysAdapterListener<dia_IHMIStartuplogoListener>(this);
	
	auto it = _HMI_Startup_logo_RoutineStatus_Map.find(status);
	
	//! Populate the response results with status 
	if(it != _HMI_Startup_logo_RoutineStatus_Map.end())
	{
		eSetStatus(it->second);
		mResults.push_back(sRoutineResultMapping[eGetStatus()]);
	}
	
	switch ( status )
	{
		case DIA_EN_IDENTIFY_ENTITIES_ABORTED:
		{
			_started = false;
			DIA_TR_INF("dia_RoutineCtrlSubsystemLogoInstallation::vOnHMIStartupLogoRequestUpdate -- Subsystems Identification Aborted!");
		}
		break;
		
		case DIA_EN_IDENTIFY_ENTITIES_NOK:
		{
			_started = false;
			DIA_TR_INF("dia_RoutineCtrlSubsystemLogoInstallation::vOnHMIStartupLogoRequestUpdate -- Subsystems Identification Completed, NoK!");
		}
		break;
		
		case DIA_EN_IDENTIFY_ENTITIES_OK:
		{
			_started = false;
			DIA_TR_INF("dia_RoutineCtrlSubsystemLogoInstallation::vOnHMIStartupLogoRequestUpdate -- Subsystems Identification Complete, Ok!");
		}
		break;
		
		case DIA_EN_IDENTIFY_ENTITIES_RUNNING:
		{
			DIA_TR_INF("dia_RoutineCtrlSubsystemLogoInstallation::vOnHMIStartupLogoRequestUpdate -- Subsystems Identification in Progress!");
		}
		break;
		
		default:
		{
			_started = false;
			DIA_TR_INF("dia_RoutineCtrlSubsystemLogoInstallation::vOnHMIStartupLogoRequestUpdate -- Subsystems Identification in Unknown state!");
		}
		break;
	}

	mIsResultReady = TRUE;
    dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);
}
*/
//-----------------------------------------------------------------------------

tDiaResult
dia_RoutineCtrlSubsystemLogoInstallation::registerSessionChange ( void )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlSubsystemLogoInstallation::registerSessionChange");

   tDiaResult retVal = DIA_FAILED;

   dia_EngineServer* pEngine = 0;
   if (( getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&pEngine) == DIA_SUCCESS ) && pEngine)
   {
      if( pEngine->getSessionController()->addListener(this))
      {
         retVal = DIA_SUCCESS;
      }
   }

   if(DIA_SUCCESS != retVal)
   {
      DIA_TR_ERR("!!! dia_RoutineCtrlSubsystemLogoInstallation::registerSessionChange => ERROR: Unable to register for Session changes");
   }

   return retVal;
}

//-----------------------------------------------------------------------------

void
dia_RoutineCtrlSubsystemLogoInstallation::vOnSessionChanged ( tU8 newSession, tU8 oldSession )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlSubsystemLogoInstallation::vOnSessionChanged()");

	// reset the flag just in case
	_started = false;
   
}

//-----------------------------------------------------------------------------

tDiaResult
dia_RoutineCtrlSubsystemLogoInstallation::unregisterSessionChange ( void )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlSubsystemLogoInstallation::unregisterSessionChange");

   tDiaResult retVal = DIA_FAILED;

   dia_EngineServer* pEngine = 0;
   if (( getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&pEngine) == DIA_SUCCESS ) && pEngine)
   {
      if( pEngine->getSessionController()->removeListener(this))
      {
         retVal = DIA_SUCCESS;
      }
   }

   if(DIA_SUCCESS != retVal)
   {
      DIA_TR_ERR("!!! dia_RoutineCtrlSubsystemLogoInstallation::unregisterSessionChange => ERROR: Unable to deregister for Session changes");
   }

   return retVal;
}
//-----------------------------------------------------------------------------

tDiaResult
dia_RoutineCtrlSubsystemLogoInstallation::cmcStartuplogoChange( tU8 logoOption )
{
	dia_tclFnctTrace oTrace("dia_RoutineCtrlSubsystemLogoInstallation::cmcStartuplogoChange");

	   tDiaResult retVal = DIA_FAILED;

	dia_File cmc_logo_original_sourceFile(CMC_Current_logo);
	dia_File cmc_Original_logo_BkFile(CMC_Original_logo);
	dia_File cmc_logo1_sourceFile(CMC_Setra_logo);
	dia_File cmc_logo2_sourceFile(CMC_Benz_logo);

	std::string cmc_Original_logo_rename = "cp " + CMC_Current_logo + " " + CMC_Original_logo;
	std::string cmc_startuplogo1_copy = "cp " + CMC_Setra_logo + " " + CMC_Current_logo;
	std::string cmc_startuplogo2_copy = "cp " + CMC_Benz_logo + " " + CMC_Current_logo;


	/*Rename existing orginal logo*/
	if(!cmc_Original_logo_BkFile.doesExist())
	{
		if(cmc_logo_original_sourceFile.doesExist())
		{
			DIA_TR_INF("Source File: \"%s\" exists.", CMC_Current_logo.c_str());
			int ret = system(cmc_Original_logo_rename.c_str());
			DIA_TR_ERR("  +-->Return value of system() command is:%d",ret);
			// Evaluate the system command execution result
			if ( WIFSIGNALED(ret) && ((WTERMSIG(ret) == SIGINT) || (WTERMSIG(ret) == SIGQUIT)) )
			{
				DIA_TR_ERR("  +--> SYSTEM COMMAND EXECUTION FAILED FOR Move COMMAND");
			}
			if(ret == 0)
			{
				DIA_TR_INF("CMC_Original_filerename Successful!!!");
			}
		}
		else
		{
			DIA_TR_INF("CMC_Original logo doesn't exist!!!");
		}
	}


	if(logoOption == CMC_STARTUP_LOGO_OPTION_SETRA) // Logo1
	{
		DIA_TR_INF("CMC Hmi startup logo1 copy :%d",logoOption);
		if(cmc_logo1_sourceFile.doesExist())
		{
			int retlogo1 = system(cmc_startuplogo1_copy.c_str());
			DIA_TR_ERR("  +-->Return value of system() command is:%d",retlogo1);
			// Evaluate the system command execution result
			if ( WIFSIGNALED(retlogo1) && ((WTERMSIG(retlogo1) == SIGINT) || (WTERMSIG(retlogo1) == SIGQUIT)) )
			{
				DIA_TR_ERR("  +--> SYSTEM COMMAND EXECUTION FAILED FOR Copy logo1 COMMAND");
				retVal = DIA_FAILED;
			}
			else
			{
				retVal = DIA_SUCCESS;
				DIA_TR_INF("CMC Hmi startup logo1 copy done Successful!!!");
			}
		}
	}
	else if(logoOption == CMC_STARTUP_LOGO_OPTION_BENZ) // Logo2
	{
		DIA_TR_INF("CMC Hmi startup logo2 copy :%d",logoOption);
		if(cmc_logo2_sourceFile.doesExist())
		{
			int retlogo2 = system(cmc_startuplogo2_copy.c_str());
			DIA_TR_ERR("  +-->Return value of system() command is:%d",retlogo2);
			// Evaluate the system command execution result
			if ( WIFSIGNALED(retlogo2) && ((WTERMSIG(retlogo2) == SIGINT) || (WTERMSIG(retlogo2) == SIGQUIT)) )
			{
				DIA_TR_ERR("  +--> SYSTEM COMMAND EXECUTION FAILED FOR Copy logo2 COMMAND");
				retVal = DIA_FAILED;
			}
			else
			{
				retVal = DIA_SUCCESS;
				DIA_TR_INF("CMC Hmi startup logo2 copy done Successful!!!");
			}
		}
	}
	else
	{
		retVal = DIA_FAILED;
		DIA_TR_INF("CMC_hmistartuplogo invalid option!!! %d",logoOption);

	}
	return retVal;
}



