/*
 * dia_RoutineCtrlReloadSupplierDeliveryState.h
 * Brief Description: Routine Service handler will copy default config data item into current config data item
 * Created on: Aug 28, 2019
 * Author: URM7KOR
 */

#ifndef DIA_ROUTINECTRLRELOADSUPPLIERDELIVERYSTATE_H_
#define DIA_ROUTINECTRLRELOADSUPPLIERDELIVERYSTATE_H_

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/depricated/dia_common_core.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE__
#include "common/framework/protocols/uds/rtctrl/dia_Routine.h"
#endif

namespace dia
{
class dia_RoutineCtrlReloadSupplierDeliveryState
	: public dia_Routine
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_RoutineCtrlReloadSupplierDeliveryState);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_RoutineCtrlReloadSupplierDeliveryState);

   public:
   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); 
   virtual tU32 getMaxProcessingTime ( void ) const { return 30000; }
   virtual tDiaResult requestResult ( std::vector<tU8>& results );
   
   protected:
   //! copy default config data item into current config data item
   tDiaResult setDefaultConfigItem(tU32, tU32) const;

   //! read config item
   tDiaResult readConfigItem(std::vector<tU8>&, tU32) const;

   //! write config item
   tDiaResult writeConfigItem(const std::vector<tU8>&, tU32) const;
};
}

#endif /* DIA_ROUTINECTRLRELOADSUPPLIERDELIVERYSTATE_H_ */
