/*
 * dia_RoutineCtrlCopyInstallationLogFileToUSB.cpp
 * brief:Implementation of copying CIS Installation Logfile from target to USB.
 * component:Diagnosis
 * Created on: May 30, 2019
 * Author: urm7kor
 * copyright  (c) 2017 Robert Bosch GmbH
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_COMMON_UDS_RTCTRL__
#include <common/framework/protocols/uds/rtctrl/dia_common_uds_rtctrl.h>
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_MANAGER__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineCtrlManager.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif
#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif
#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_FILE_DIR__
#include <common/framework/application/dia_FileDir.h>
#endif

#ifndef __INCLUDED_DIA_FILE__
#include "common/framework/application/dia_File.h"
#endif
#ifndef __INCLUDED_DIA_ROUTINE_CTRL_COPY_INSTALLATION_LOG_FILE_TO_USB_H__
#include "dia_RoutineCtrlCopyInstallationLogFileToUSB.h"
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fstream>     //lint !e537 : repeatedly included header file without standard include guard
#include <stdlib.h>    //lint !e537 !e451 : repeatedly included header file without standard include guard
#include <sys/wait.h>

static const std::string CIS_INST_LOGFILE_PATH("/var/opt/bosch/persistent/avdecc/doipcmcinstallresult.xml");
static const std::string CIS_INST_USB_DESTINATION_PATH_1("/media/AAM_dev_sda1/cmc_diag/");
static const std::string CIS_INST_USB_DESTINATION_PATH_2("/media/AAM_dev_sdb1/cmc_diag/");
#define DIA_C_U8_ROUTINE_RESULT_COMPLETED_OK       ( (tU8) 0x00)
#define DIA_C_U8_ROUTINE_RESULT_COMPLETED_NOK      ( (tU8) 0x01)

namespace dia
{
//-----------------------------------------------------------------------------------
dia_RoutineCtrlCopyInstallationLogFileToUSB::dia_RoutineCtrlCopyInstallationLogFileToUSB( void )
   :dia_Routine("dia_RoutineCtrlCopyInstallationLogFileToUSB",(tU16) DIA_C_U16_DID_CENTER_CMC_19_COPY_INSTALLATION_LOGFILE_TO_USB, DIA_EN_RTCTRL_TYPE_SHORT_TERM ),
    InStartRoutine(FALSE)
{
	dia_tclFnctTrace oTrace("dia_RoutineCtrlCopyInstallationLogFileToUSB::dia_RoutineCtrlCopyInstallationLogFileToUSB");
	mType=DIA_EN_RTCTRL_TYPE_LONG_TERM;
}
//--------------------------------------------------------------------------------------
dia_RoutineCtrlCopyInstallationLogFileToUSB::~dia_RoutineCtrlCopyInstallationLogFileToUSB(void) {
}
//-------------------------------------------------------------------------------------------
tDiaResult
dia_RoutineCtrlCopyInstallationLogFileToUSB::start ( std::vector<tU8>& /*params*/, tU8 /*timerValue*/ )
{
	dia_tclFnctTrace oTrace("dia_RoutineCtrlCopyInstallationLogFileToUSB::start()");
	InStartRoutine = TRUE;
	tDiaResult retCode = DIA_FAILED;

	// prepare processing of the routine
	vInitialize();
	eSetStatus(DIA_EN_RTCTRL_STATUS_IN_PROGRESS);
	dia_File cissourceFile(CIS_INST_LOGFILE_PATH);
	dia_FileDir cisDestination1(CIS_INST_USB_DESTINATION_PATH_1);
	dia_FileDir cisDestination2(CIS_INST_USB_DESTINATION_PATH_2);
	std::string cmd_string1 = "cp " + CIS_INST_LOGFILE_PATH + " " + CIS_INST_USB_DESTINATION_PATH_1;
	std::string cmd_string2 = "cp " + CIS_INST_LOGFILE_PATH + " " + CIS_INST_USB_DESTINATION_PATH_2;
	DIA_TR_INF(" +-->Command String1 is : \"%s\"!!!", cmd_string1.c_str());
	DIA_TR_INF(" +-->Command String2 is : \"%s\"!!!", cmd_string2.c_str());

	if(cissourceFile.doesExist()&& cisDestination1.doesExist() )
	{
		DIA_TR_INF("Source File: \"%s\" exists.", CIS_INST_LOGFILE_PATH.c_str());
		DIA_TR_INF("Destination1 path: \"%s\" exists.", CIS_INST_USB_DESTINATION_PATH_1.c_str());
		int ret = system(cmd_string1.c_str());
		DIA_TR_ERR("  +-->Return value of system() command is:%d",ret);
		// Evaluate the system command execution result
		if ( WIFSIGNALED(ret) && ((WTERMSIG(ret) == SIGINT) || (WTERMSIG(ret) == SIGQUIT)) )
		{
			DIA_TR_ERR("  +--> SYSTEM COMMAND EXECUTION FAILED FOR COPY COMMAND");
			retCode = DIA_FAILED;
		}

		if(ret == 0)
		{
			DIA_TR_INF("dia_RoutineCtrlCopyInstallationLogFileToUSB::File Copying Successful!!!");
			eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
			retCode = DIA_SUCCESS;
		}
		else{
			DIA_TR_INF("dia_RoutineCtrlCopyInstallationLogFileToUSB::File Copying UnSuccessful!!!");
			retCode = DIA_FAILED;

		}
		mIsResultReady = TRUE;
	}
	else if(cissourceFile.doesExist()&& cisDestination2.doesExist())
	{
		DIA_TR_INF("Source File: \"%s\" exists.", CIS_INST_LOGFILE_PATH.c_str());
		DIA_TR_INF("Destination2 path: \"%s\" exists.", CIS_INST_USB_DESTINATION_PATH_2.c_str());
		int ret = system(cmd_string2.c_str());
		DIA_TR_ERR("  +-->Return value of system() command is:%d",ret);
		// Evaluate the system command execution result
		if ( WIFSIGNALED(ret) && ((WTERMSIG(ret) == SIGINT) || (WTERMSIG(ret) == SIGQUIT)) )
		{
			DIA_TR_ERR("  +--> SYSTEM COMMAND EXECUTION FAILED FOR COPY COMMAND");
			retCode = DIA_FAILED;
		}

		if(ret == 0)
		{
			DIA_TR_INF("dia_RoutineCtrlCopyInstallationLogFileToUSB::File Copying Successful!!!");
			eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
			retCode = DIA_SUCCESS;
		}
		else{
			DIA_TR_INF("dia_RoutineCtrlCopyInstallationLogFileToUSB::File Copying UnSuccessful!!!");
			retCode = DIA_FAILED;
		}
		mIsResultReady = TRUE;
	}
	else
	{
		DIA_TR_INF("dia_RoutineCtrlCopyInstallationLogFileToUSB::Either Source Path or Destination path not Exit!!!");
		eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
		retCode = DIA_SUCCESS;
		mIsResultReady = TRUE;
	}
	return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_RoutineCtrlCopyInstallationLogFileToUSB::requestResult ( std::vector<tU8>& results )
{
	DIA_TR_INF("dia_RoutineCtrlCopyInstallationLogFileToUSB::requestResult()");
	dia_eRoutineStatus eRoutineStatusAfter = eGetStatus();
	if(InStartRoutine)
	{
		DIA_TR_INF("dia_RoutineCtrlCopyInstallationLogFileToUSB::request for start_Routine!!!");
		results.push_back(mapStatus2UDSResult());
		InStartRoutine = FALSE;
	}
	else
	{
		DIA_TR_INF("dia_RoutineCtrlCopyInstallationLogFileToUSB::request for result_Routine!!!");
		if(eRoutineStatusAfter == DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK)
		{
			results.push_back(mapStatus2UDSResult());
			results.push_back(DIA_C_U8_ROUTINE_RESULT_COMPLETED_OK);
		}
		else
		{
			results.push_back(mapStatus2UDSResult());
			results.push_back(DIA_C_U8_ROUTINE_RESULT_COMPLETED_NOK);
		}
	}
	results.insert(results.end(), mResults.begin(), mResults.end());
	return DIA_SUCCESS;
}
}//namespace dia
