
/*!
 * \file       dia_RoutineCtrlConnectToSpecificSubSystem.h
 *
 * \brief      Connect To Specific Sub System used for subsystem diagnosis
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    subsystem diagnosis
 *
 * \author     Harish N G (RBEI/ECA2)
 *
 * \date       16.10.2019
 *
 * \copyright  (c) 2019 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_CONNECT_SPECIFIC_SUBSYSTEM_H_
#define __INCLUDED_DIA_ROUTINE_CTRL_CONNECT_SPECIFIC_SUBSYSTEM_H_

#ifndef __INCLUDED_DIA_ROUTINE__
#include "common/framework/protocols/uds/rtctrl/dia_Routine.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_CMC_DOIP_LISTENER__
#include "project/interfaces/dia_ISubsystemDiagnosisListener.h"
#endif


class dia_RoutineCtrlConnectToSpecificSubSystem
	: public dia_Routine,
	  public dia_ISubsystemDiagnosisListenerImpl
{

	DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_RoutineCtrlConnectToSpecificSubSystem);
	DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_RoutineCtrlConnectToSpecificSubSystem);

public :

	virtual tDiaResult start(std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE );

	virtual tDiaResult requestResult ( std::vector<tU8>& results );
	//! handle timeout from UDS session object
	virtual void vOnServiceTimeout ( void );
	
	//! retrieve the value of the maximum processing time in ms
   virtual tU32 getMaxProcessingTime ( void ) const { return 60000; }


protected:
	//! there was an update in the connected request
     virtual void vOnConnectToSubsystemRequestUpdate ( tDiaResult& success );


};

#endif /* __INCLUDED_DIA_ROUTINE_CTRL_CONNECT_SPECIFIC_SUBSYSTEM_H_ */
