
/*!
 * \file       dia_RoutineCtrlConnectToSpecificSubSystem.cpp
 *
 * \brief      Connect To Specific Sub System used for subsystem diagnosis
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    subsystem diagnosis
 *
 * \author     Harish N G (RBEI/ECA2)
 *
 * \date       16.10.2019
 *
 * \copyright  (c) 2019 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
#ifndef __INCLUDED_DIA_COMMON_UDS_RTCTRL__
#include <common/framework/protocols/uds/rtctrl/dia_common_uds_rtctrl.h>
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_MANAGER__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineCtrlManager.h"
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_MANAGER__
#include "project/framework/cis/subsystem/dia_SubsystemDiagnosisManager.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_CONNECT_SPECIFIC_SUBSYSTEM_H_
#include "dia_RoutineCtrlConnectToSpecificSubSystem.h"
#endif

//---------------------------------------------------------------------------------------------------------------------------

dia_RoutineCtrlConnectToSpecificSubSystem::dia_RoutineCtrlConnectToSpecificSubSystem(void)
: dia_Routine("dia_RoutineCtrlConnectToSpecificSubSystem", DIA_C_U16_DID_CENTER_CMC_19_SUB_SYSTEM_CONNECT, DIA_EN_RTCTRL_ID_PROJECT_15, DIA_EN_RTCTRL_TYPE_LONG_TERM)
{
	dia_tclFnctTrace oTrace("dia_RoutineCtrlConnectToSpecificSubSystem::dia_RoutineCtrlConnectToSpecificSubSystem");
}

//---------------------------------------------------------------------------------------------------------------------------

dia_RoutineCtrlConnectToSpecificSubSystem::~dia_RoutineCtrlConnectToSpecificSubSystem(void)
{
	DIA_TR_INF("dia_RoutineCtrlConnectToSpecificSubSystem::~dia_RoutineCtrlConnectToSpecificSubSystem");
}

//---------------------------------------------------------------------------------------------------------------------------

tDiaResult
dia_RoutineCtrlConnectToSpecificSubSystem::start ( std::vector<tU8>& params, tU8 /*timerValue*/ )
{
	dia_tclFnctTrace oTrace("dia_RoutineCtrlConnectToSpecificSubSystem::start()");

	tDiaResult retCode = DIA_FAILED;

	// prepare processing of the routine
	vInitialize();

	//! copy the request data into local buffer
	std::vector<tU8> requestData;
	requestData = params;


	//! get the instance of subsystem manager 
	dia_SubsystemDiagnosisManager* pManager = getInstanceOfSubsystemDiagnosisManager();


	if (pManager!= NULL)
	{
		(void) setSysAdapterListener<dia_ISubsystemDiagnosisListener>(this);

		if (pManager->connectToSubsystem(requestData) == DIA_SUCCESS)
		{
			DIA_TR_INF("dia_RoutineCtrlConnectToSpecificSubSystem::start Successfully Sent request");
			retCode = DIA_SUCCESS;
		}
		else
		{
			DIA_TR_ERR("dia_RoutineCtrlConnectToSpecificSubSystem::start connectToSubsystem --- SEND TO DOIP SERVER FAILED !!!");
			(void) unsetSysAdapterListener<dia_ISubsystemDiagnosisListener>(this);
			eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
			mIsResultReady = TRUE;
		}
	}
	else
	{
		DIA_TR_ERR("dia_RoutineCtrlConnectToSpecificSubSystem::start --- pManager is NULL.");
		eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
		mIsResultReady = TRUE;
	}
	
	return retCode;
}

//---------------------------------------------------------------------------------------------------------------------------
void
dia_RoutineCtrlConnectToSpecificSubSystem::vOnConnectToSubsystemRequestUpdate(tDiaResult& success )
{
	dia_tclFnctTrace oTrace("dia_RoutineCtrlConnectToSpecificSubSystem::vOnConnectToSubsystemRequestUpdate");
	if(DIA_SUCCESS == success)
	{
		DIA_TR_INF("dia_RoutineCtrlConnectToSpecificSubSystem::vOnConnectToSubsystemRequestUpdate Successfully Connected");
		eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
		(void) unsetSysAdapterListener<dia_ISubsystemDiagnosisListener>(this);
	}
	else
	{
		eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
		DIA_TR_ERR("dia_RoutineCtrlConnectToSpecificSubSystem::vOnConnectToSubsystemRequestUpdate Negative response received from Doip Server!!");
	}
	mIsResultReady = TRUE;
	dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);
}

//---------------------------------------------------------------------------------------------------------------------------

void dia_RoutineCtrlConnectToSpecificSubSystem::vOnServiceTimeout ( void )
{
	dia_tclFnctTrace oTrace("dia_RoutineCtrlIdentifySubSystem::vOnServiceTimeout ( void )");
	(void) unsetSysAdapterListener<dia_ISubsystemDiagnosisListener>(this);
}

//---------------------------------------------------------------------------------------------------------------------------

tDiaResult
dia_RoutineCtrlConnectToSpecificSubSystem::requestResult ( std::vector<tU8>& results )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlConnectToSpecificSubSystem::requestResult()");
   results.clear();
   results.push_back(mapStatus2UDSResult());
   results.insert(results.end(), mResults.begin(), mResults.end());

   return DIA_SUCCESS;
}




