/*
 * dia_RoutineCtrlCheckProgrammingDependencies.cpp
 *
 *  Created on: 05.01.2017
 *      Author: abe6kor
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_EXT_DIAGLOG_IF__
#include "project/framework/application/ext_diaglog_if.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ERRORLOG__
#include "common/interfaces/dia_IErrorLog.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_CHECK_PROGRAMMING_DEPENDENCIES__
#include "dia_RoutineCtrlCheckProgrammingDependencies.h"
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER_UDS__
#include "common/framework/protocols/uds/dia_MessageBufferUDS.h"
#endif

#ifndef __INCLUDED_DIA_CMD_START_TEST__
#include "common/framework/test/dia_CmdStartTest.h"
#endif

#ifndef __INCLUDED_DIA_COMMAND_CONTROLLER__
#include "common/framework/application/dia_CommandController.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include "common/framework/protocols/uds/dia_defsUds.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#define TESTFAILED                        ((tU8) 0x01)
#define TESTNOTCOMPLETEDSINCELASTCLEAR    ((tU8) 0x10)

static const tU8  RSRRoutineInfo = 0x10;     /* defined by the customer*/

//---------------------------------------------------------------------------------------------------------------------

dia_RoutineCtrlCheckProgrammingDependencies::dia_RoutineCtrlCheckProgrammingDependencies()
   : dia_Routine("RoutineCtrlCheckProgrammingDependencies",DIA_C_U16_ID_AIVI_RTCTRL_CHECK_PROGRAMMING_DEPENDENCIES)
{
   dia_tclFnctTrace oTrace("dia::dia_RoutineCtrlCheckProgrammingDependencies::dia_RoutineCtrlCheckProgrammingDependencies");
}

//---------------------------------------------------------------------------------------------------------------------

dia_RoutineCtrlCheckProgrammingDependencies::~dia_RoutineCtrlCheckProgrammingDependencies ( void )
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_IErrorLogListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("dia::dia_RoutineCtrlCheckProgrammingDependencies::~dia_RoutineCtrlCheckProgrammingDependencies - Exception caught!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}
//-----------------------------------------------------------------------------

void
dia_RoutineCtrlCheckProgrammingDependencies::vOnServiceTimeout ( void )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlCheckProgrammingDependencies::vOnServiceTimeout()");

   (void) unsetSysAdapterListener<dia_IRoutineControlListener>(this);

   dia_IRoutineControl* pRtCtrlInterface = 0;
   tDiaResult retCode = querySysAdapterInterface<dia_IRoutineControl>(&pRtCtrlInterface);
   if ( (retCode != DIA_SUCCESS) || !pRtCtrlInterface )
   {
      DIA_TR_ERR("querySysAdapterInterface for dia_IRoutineControl failed");
      DIA_ASSERT_ALWAYS();
   }
   else
   {
      std::map<dia_UID, bool>::iterator itRoutine;
      for (itRoutine = mRoutineResults.begin(); itRoutine != mRoutineResults.end(); itRoutine++)
      {
         //Check for unfinished routines
         dia_UID uidRoutine = itRoutine->first;
         if (itRoutine->second == false)
         {
            dia_Routine* pRoutine = 0;
            retCode = pRtCtrlInterface->queryRoutine(uidRoutine, &pRoutine);
            if ((retCode != DIA_SUCCESS) || !pRoutine)
            {
               DIA_TR_ERR("queryRoutine for uid=0x%x failed", uidRoutine);
               DIA_ASSERT_ALWAYS();
            }
            else
            {
               DIA_TR_ERR("Forwarding vOnServiceTimeout to %s", pRoutine->getName());
               pRoutine->vOnServiceTimeout();
            }
         }
      }
   }
}

//------------------------------------------------------------------------------

tDiaResult
dia_RoutineCtrlCheckProgrammingDependencies::start ( std::vector<tU8>& params, tU8 /*timerValue*/ )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlCheckProgrammingDependencies::start");
   tDiaResult retCode = DIA_FAILED;
   tU8 mask = TESTFAILED | TESTNOTCOMPLETEDSINCELASTCLEAR;

   // prepare processing of the routine
   vInitialize();

   if(getDTCbyStatusMask(mask) == DIA_SUCCESS)
   {
      DIA_TR_INF("dia_RoutineCtrlCheckProgrammingDependencies::start --1");
      eSetStatus(DIA_EN_RTCTRL_STATUS_IN_PROGRESS);
      retCode = DIA_SUCCESS;
   }
   else
   {
      DIA_TR_INF("dia_RoutineCtrlCheckProgrammingDependencies::FAILED");
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
      mIsResultReady = TRUE;
   }
   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_RoutineCtrlCheckProgrammingDependencies::getDTCbyStatusMask(tU8 u8mask)
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlCheckProgrammingDependencies::getDTCbyStatusMask()");

   DIA_TR_INF("dia_RoutineCtrlCheckProgrammingDependencies::getDTCbyStatusMask DTC Mask=0x%02X.", u8mask);

   tBool errorDetected = TRUE;
   dia_IErrorLog* pInterface = 0;
   if ((querySysAdapterInterface<dia_IErrorLog>(&pInterface) == DIA_SUCCESS) && pInterface)
   {
      DIA_TR_INF("dia_RoutineCtrlCheckProgrammingDependencies::getDTCbyStatusMask interface got.");
      (void) setSysAdapterListener<dia_IErrorLogListener>(this);

      //response will be delivered in vOnReadDTCbyStatusMaskResult
      if (pInterface->getDTCbyStatusMask(DIAGLOG_MEMORY_REPROGRAMMING, u8mask) == DIA_SUCCESS)
      {
         DIA_TR_INF("dia_RoutineCtrlCheckProgrammingDependencies::getDTCbyStatusMask passed.");
         errorDetected = FALSE;
      }
      else
      {
         DIA_TR_ERR("### getStatusByDTC FAILED ####");
      }
   }

   if ( errorDetected )
   {
      DIA_TR_INF("dia_RoutineCtrlCheckProgrammingDependencies::getDTCbyStatusMask unset system adapter listener.");
      (void) unsetSysAdapterListener<dia_IErrorLogListener>(this);

      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
      mIsResultReady = TRUE;
   }

   DIA_TR_INF("dia_RoutineCtrlCheckProgrammingDependencies::getStatusByDTC returned %s.", (errorDetected ? "DIA_FAILED": "DIA_SUCCESS"));

   return (errorDetected ? DIA_FAILED: DIA_SUCCESS);
}

//------------------------------------------------------------------------------

void
dia_RoutineCtrlCheckProgrammingDependencies::vOnReadDTCbyStatusMaskResult(const tU8 u8DTCStatusAvailabilityMask, std::list<tdia_IErrorLogResult>& ErrorLogList)
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlCheckProgrammingDependencies::vOnReadStatusByDTCResult()");
   tDiaResult retCode = DIA_SUCCESS;

   DIA_TR_INF( "u8DTCStatusAvailabilityMask = 0x%02X.", u8DTCStatusAvailabilityMask);
   DIA_TR_INF( "ErrorLogList.size()=%d.", ErrorLogList.size());

   m_u32logicalBlockIdDTC.clear();

   //Set initial status to OK
   eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
   mIsResultReady = TRUE;

   if(!(ErrorLogList.size()))
   {
      //Empty list means all DTC have passed and there is no DTC with TestNotRun
   }
   else
   {
      for (std::list<tdia_IErrorLogResult>::iterator it = ErrorLogList.begin(); it != ErrorLogList.end(); it++)
      {
         DIA_TR_INF( "DTC 0x%06X found and its status is 0x%02X.", it->u32DTC, it->u8Status);

         if (it->u8Status & TESTFAILED)
         {
            DIA_TR_INF("TestFailed bit is set");
            //If any DTC has a status with bit TestFailed to 1, return a negative response with NRC 0x26 FPEORA.
            eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
         }
         else if (it->u8Status & TESTNOTCOMPLETEDSINCELASTCLEAR)
         {
            DIA_TR_INF("TestNotCompletedSinceLastClear bit is set");
            //Prepare to run the corresponding test
            m_u32logicalBlockIdDTC.push_back(it->u32DTC);
         }
         else
         {
            DIA_ASSERT_ALWAYS();
         }
      }
   }

   if (m_u32logicalBlockIdDTC.size())
   {
      mIsResultReady = FALSE;

      mRoutineResults.clear();

#if 1
      //Trigger RunDTC test beginning with first element from the list
      m_itLogicalBlockIdDTC = m_u32logicalBlockIdDTC.begin();
      if (DIA_SUCCESS == runDTCTest(*m_itLogicalBlockIdDTC))
      {
         m_itLogicalBlockIdDTC++;
      }
      else
      {
         DIA_ASSERT_ALWAYS();
      }
#else
      for (m_itLogicalBlockIdDTC = m_u32logicalBlockIdDTC.begin(); m_itLogicalBlockIdDTC != m_u32logicalBlockIdDTC.end(); m_itLogicalBlockIdDTC++)
      {
         retCode = runDTCTest(*m_itLogicalBlockIdDTC);
         if (retCode != DIA_SUCCESS)
         {
            DIA_TR_ERR("Failed to runDTCTest for DTC=0x%x with retCode=%d", *m_itLogicalBlockIdDTC, retCode);
         }
      }
#endif
   }
   else
   {
      (void) unsetSysAdapterListener<dia_IErrorLogListener>(this);
      dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);
   }
}

//------------------------------------------------------------------------------

void
dia_RoutineCtrlCheckProgrammingDependencies::vOnClearResult(void)
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlCheckProgrammingDependencies::vOnClearResult()");

   if (m_itLogicalBlockIdDTC != m_u32logicalBlockIdDTC.end())
   {
      //Trigger RunDTC test with next element from the list
      if (DIA_SUCCESS == runDTCTest(*m_itLogicalBlockIdDTC))
      {
         m_itLogicalBlockIdDTC++;
      }
      else
      {
         DIA_ASSERT_ALWAYS();
      }
   }
   else
   {
      (void) unsetSysAdapterListener<dia_IErrorLogListener>(this);
   }
}


//------------------------------------------------------------------------------

tDiaResult
dia_RoutineCtrlCheckProgrammingDependencies::runDTCTest(tU32 u32DTC)
{
   tDiaResult retCode = DIA_FAILED;

   dia_IRoutineControl* pRtCtrlInterface = 0;
   retCode = querySysAdapterInterface<dia_IRoutineControl>(&pRtCtrlInterface);
   if ( (retCode != DIA_SUCCESS) || !pRtCtrlInterface )
   {
      DIA_TR_ERR("querySysAdapterInterface for dia_IRoutineControl failed");
      DIA_ASSERT_ALWAYS();
   }
   else
   {
      dia_Routine* pRoutine = 0;

      //CID - 139994 Fix
      std::string strRoutine = dia_composeStlString("dia_RoutineCheckLogicalBlockDtc%06X", u32DTC);
      tU32 uidRoutine = dia_getHashCodeFromString(strRoutine);

      retCode = pRtCtrlInterface->queryRoutine(uidRoutine, &pRoutine);
      if ((retCode != DIA_SUCCESS) || !pRoutine)
      {
         DIA_TR_ERR("queryRoutine for name='%s' / uid=0x%x failed", strRoutine.c_str(), uidRoutine);
         DIA_ASSERT_ALWAYS();
      }
      else
      {
         mRoutineResults[uidRoutine] = false;

         std::vector<tU8> params;
         params.push_back((tU8) (u32DTC >> 16));
         params.push_back((tU8) (u32DTC >> 8));
         params.push_back((tU8) (u32DTC & 0x00FF));

         (tVoid) setSysAdapterListener<dia_IRoutineControlListener>(this);

         retCode = pRoutine->start(params, DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE);
      }
   }

   return retCode;
}

//------------------------------------------------------------------------------

void dia_RoutineCtrlCheckProgrammingDependencies::vOnRoutineUpdate ( dia_Routine& routine )
{
   dia_tclFnctTrace trc("dia_RoutineCtrlCheckProgrammingDependencies::vOnRoutineUpdate");

   std::map<dia_UID, bool>::iterator itRoutine = mRoutineResults.find(routine.getUID());

   if ( (itRoutine != mRoutineResults.end()) && routine.bIsResultReady() )
   {
#if 0
      (void) unsetSysAdapterListener<dia_IRoutineControlListener>(this);
#endif

      std::vector<tU8> results;
      tDiaResult retCode = routine.requestResult(results);
      if ( retCode == DIA_SUCCESS )
      {
         for (unsigned i = 0; i < results.size(); i++)
         {
            DIA_TR_INF("results[%d] = 0x%x", i, results[i]);
         }

         if ((results.size() == 2) && (results[0] == RSRRoutineInfo))
         {
            if (results[1] & TESTFAILED)
            {
               DIA_TR_INF("TestFailed bit is set");
               //If any DTC has a status with bit TestFailed to 1, return a negative response with NRC 0x26 FPEOR
               eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
            }

#if 0
            if (m_itLogicalBlockIdDTC != m_u32logicalBlockIdDTC.end())
            {
               //Trigger RunDTC test with next element from the list
               if (DIA_SUCCESS == runDTCTest(*m_itLogicalBlockIdDTC))
               {
                  m_itLogicalBlockIdDTC++;
               }
               else
               {
                  DIA_ASSERT_ALWAYS();
               }
            }
            else
            {
               mIsResultReady = TRUE;
               dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);
            }
#else
            itRoutine->second = true;

            bool complete = true;
            for (itRoutine = mRoutineResults.begin(); itRoutine != mRoutineResults.end(); itRoutine++)
            {
               if (itRoutine->second == false)
               {
                  complete = false;
                  break;
               }
            }

            if (complete)
            {
               (void) unsetSysAdapterListener<dia_IRoutineControlListener>(this);
               mIsResultReady = TRUE;
               dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);
            }
#endif
         }
         else
         {
            DIA_ASSERT_ALWAYS();
         }
      }
      else
      {
         DIA_TR_ERR("Failed to get routine results");
      }
   }
   else
   {
      DIA_TR_ERR("No routine results available");
   }
}

//------------------------------------------------------------------------------

tDiaResult
dia_RoutineCtrlCheckProgrammingDependencies::requestResult ( std::vector<tU8>& results )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlCheckProgrammingDependencies::requestResult()");
   tDiaResult retCode = DIA_E_ROUTINE_SUBFUNCTION_NOT_SUPPORTED;

   DIA_TR_INF("dia_RoutineCtrlCheckProgrammingDependencies::requestResult: mStatus = %d", mStatus);

   results.clear();
   if ( !(mResults.empty()) )
   {
      DIA_TR_INF("dia_RoutineCtrlCheckProgrammingDependencies::requestResult --- 1");
      std::vector<tU8>::iterator iter = mResults.begin();
      for ( ; iter != mResults.end(); iter++ )
      {
         results.push_back(*iter);
      }
      mResults.clear();
      retCode = DIA_SUCCESS;
   }
   else
   {
      DIA_TR_INF("dia_RoutineCtrlCheckProgrammingDependencies::requestResult --- 2");

      switch ( mStatus )
      {
         case DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK:
         {
            DIA_TR_INF("DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK");
            mIsResultReady = FALSE;
            retCode = DIA_E_FAILURE_PREVENTS_EXECUTION_OF_REQUESTED_ACTION;
         }
         break;

         case DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK:
         {
            DIA_TR_INF("DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK");
            results.push_back(RSRRoutineInfo);
            mIsResultReady = FALSE;
            retCode = DIA_SUCCESS;
         }
         break;

         default:
         {
            DIA_TR_INF("dia_RoutineCtrlCheckProgrammingDependencies::requestResult --- 4");
            DIA_TR_INF("dia_RoutineCtrlCheckProgrammingDependencies::requestResult mStatus = %d.", mStatus);
         }
         break;
      }
   }

   return retCode;
}
