#ifndef __INCLUDED_DIA_ROUTINE_CTRL_CIS_SW_UPDATE_STAGE2_H__
#define __INCLUDED_DIA_ROUTINE_CTRL_CIS_SW_UPDATE_STAGE2_H__

#ifndef __INCLUDED_DIA_ROUTINE__
#include "common/framework/protocols/uds/rtctrl/dia_Routine.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SWUPDATEPRJ_LISTENER__
#include "project/interfaces/dia_ISWUpdatePrjListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SPM_LISTENER__
#include "common/interfaces/dia_ISpmListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DISPLAYPATTERNAIVI_LISTENER__
#include "project/interfaces/dia_IDisplayPatternAIVIListener.h"
#endif

class dia_RoutineCtrlCISSWUpdateStage2
      : public dia_Routine,
      public dia_ISWUpdatePrjListenerImpl,
      public dia_ISpmListenerImpl,
      public dia_IDisplayPatternAIVIListenerImpl
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_RoutineCtrlCISSWUpdateStage2);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_RoutineCtrlCISSWUpdateStage2);

public:
   virtual void vOnServiceTimeout (void); 

   virtual void restartsystem ();
   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue = DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class

   virtual tDiaResult requestResult  ( std::vector<tU8>& results );

   virtual void  vOnAbortCondition  ( tU8 stage2hmiresults );

   virtual void  vOnRebootContinue  ( tU8 stage2hmiresults );

protected:

   virtual void vOnAbortStatus (bool resultStage2);
   virtual void vOnCISswUpdateProcessStage2Result( tBool resultStage2 );

private:

   static const tU32 UPDATE_OPTION_REBOOT   = 0;
   static const tU32 UPDATE_OPTION_ABORT    = 1;
   tBool errorDetected;
   //tU8 mSystemRestartMode;
   tU8 mSWUpdateOption;

   static const tU32 DEFAULT_RESULT   = 0xFF;

   // Result value to map CDD value;
   tU8 mResultStage2;
};
#endif /* __INCLUDED_DIA_ROUTINE_CTRL_CIS_SW_UPDATE_STAGE2_H__*/