/*
 * \file       dia_RoutineCtrlCISSWUpdateStage2.cpp
 */

#ifndef __INCLUDED_DIA_COMMON_UDS_RTCTRL__
#include <common/framework/protocols/uds/rtctrl/dia_common_uds_rtctrl.h>
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_MANAGER__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineCtrlManager.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include <common/framework/engine/dia_EngineServer.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_MANAGER__
#include <common/framework/engine/dia_EngineManager.h>
#endif

#ifndef __INCLUDED_DIA_SESSION__
#include <common/framework/engine/dia_Session.h>
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_MANAGER__
#include "project/framework/cis/subsystem/dia_SubsystemDiagnosisManager.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_CIS_SW_UPDATE_STAGE2_H__
#include "project/services/customer/dia_RoutineCtrlCISSWUpdateStage2.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_CIS_SW_UPDATE_STAGE1_H__
#include "project/services/customer/dia_RoutineCtrlCISSWUpdateStage1.h"
#endif

//---------------------------------------------------------------------------------------------------------------------

dia_RoutineCtrlCISSWUpdateStage2::dia_RoutineCtrlCISSWUpdateStage2(void)
   :dia_Routine("dia_RoutineCtrlCISSWUpdateStage2", DIA_C_U16_DID_CENTER_CMC_19_CIS_SW_UPDATE_STAGE2, DIA_EN_RTCTRL_ID_PROJECT_15, DIA_EN_RTCTRL_TYPE_LONG_TERM),
   mSWUpdateOption(0),
   errorDetected(TRUE),
   mResultStage2(0)
{
   DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage2::dia_RoutineCtrlCISSWUpdateStage2");
   /*
   CID 13224679 (#1 of 1): Uninitialized scalar field (UNINIT_CTOR)
   Fix: initialized variable in the constructor
   */
}

//---------------------------------------------------------------------------------------------------------------------

dia_RoutineCtrlCISSWUpdateStage2::~dia_RoutineCtrlCISSWUpdateStage2 ( void )
{
   _BP_TRY_BEGIN
   {
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("dia_RoutineCtrlCISSWUpdateStage2::~dia_RoutineCtrlCISSWUpdateStage2 - Exception caught!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------
void
dia_RoutineCtrlCISSWUpdateStage2::vOnServiceTimeout ( void )
{
   DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage2::vOnServiceTimeout()");
}

//------------------------------------------------------------------------------

tDiaResult
dia_RoutineCtrlCISSWUpdateStage2::start ( std::vector<tU8>& params, tU8 /*timerValue*/ )
{
   DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage2::start()");

   // prepare processing of the routine
   vInitialize();

   tDiaResult retCode = DIA_FAILED;
   // NRC check for parameter list sent from tester
   if (params.size() != 1)
   {
      DIA_TR_INF("INVALID PARAMETER SIZE");
      return DIA_FAILED;
   }  

   mSWUpdateOption =static_cast<tU8>(params[0]);
   mResultStage2 = DEFAULT_RESULT;

   dia_eRoutineStatus stage1Status = dia_RoutineCtrlCISSWUpdateStage1::RtctrlStatus;

   if(stage1Status == DIA_EN_RTCTRL_STATUS_IN_PROGRESS)
   {
      DIA_TR_INF("Stage-1 SW-Update is still in progress/aborted. Stage-2 will not be triggered.");
      return DIA_FAILED;
   }
   else
   {
      dia_ISWUpdatePrj* pInterface = 0;
      if (querySysAdapterInterface<dia_ISWUpdatePrj>(&pInterface) == DIA_SUCCESS)
      {
         if (pInterface)
         {
            if(UPDATE_OPTION_REBOOT == mSWUpdateOption)
            {
               //Expose Diagnosis Interface to HMI:send status request
               dia_IDisplayPatternAIVI* pDisplayPatternInterface = NULL;
               tDiaResult queryResult = querySysAdapterInterface<dia_IDisplayPatternAIVI>(&pDisplayPatternInterface);
               if (DIA_SUCCESS==queryResult)
               {
                  if (pDisplayPatternInterface)
                  {
                     (void) setSysAdapterListener<dia_IDisplayPatternAIVIListener>(this);
                     pDisplayPatternInterface->setCISswUpdateStage2ProcessStatus(TRUE);
                     eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
                     retCode=DIA_SUCCESS;
                     DIA_TR_ERR("dia_RoutineCtrlCISSWUpdateStage2::start pDisplayPatternInterface is OK.");
                  }
                  else
                  {
                     (void) unsetSysAdapterListener<dia_IDisplayPatternAIVIListener>(this);
                     eSetStatus(DIA_EN_RTCTRL_STATUS_ABORTED);
                     DIA_TR_ERR("dia_RoutineCtrlCISSWUpdateStage2::start pDisplayPatternInterface is NULL.");
                  }
               }
            }
            else if(UPDATE_OPTION_ABORT == mSWUpdateOption)
            {
               (tVoid) setSysAdapterListener<dia_ISWUpdatePrjListener>(this);
               if (pInterface->sendAbortRequest() == DIA_SUCCESS) 
               {
                  DIA_TR_INF("dia_RoutineCtrlCISSWUpdate2::start():sendAbortRequest() OK!");
                  eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK); 
                  retCode=DIA_SUCCESS;  
               }
               else
               {
                  (void) unsetSysAdapterListener<dia_ISWUpdatePrjListener>(this);
                  DIA_TR_ERR("dia_RoutineCtrlCISSWUpdateStage2::start():sendAbortRequest() failed with Errors!");
                  eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
                  retCode=DIA_SUCCESS;
               }
            }
            else
            {
               DIA_TR_INF("INVALID PARAMETERS");
               return DIA_FAILED;
            }
         }
         else
         {
            DIA_TR_ERR("dia_RoutineCtrlCISSWUpdateStage2::start --- pInterface is NULL.");
         }
      }
      else
      {
         DIA_TR_ERR("dia_RoutineCtrlCISSWUpdateStage2::start querySysAdapterInterface<dia_ISWUpdatePrjListener> ERROR!");
      }
   }
   

   DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage2::start retCode = 0x%08X", retCode);

   return retCode;

}

//-----------------------------------------------------------------------------

tDiaResult
dia_RoutineCtrlCISSWUpdateStage2::requestResult ( std::vector<tU8>& results )
{
   DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage2::requestResult()");

   tDiaResult retCode = DIA_SUCCESS;

   results.clear();

   switch ( mStatus )
   {
   case DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK:
   {
      DIA_TR_INF("requestResult: DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK"); //Fix for Coverity CID : 16462311  
      results.push_back(0x00);
      results.push_back(mResultStage2);
      //restartsystem();
   }
      break;
   case DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK:
   {
      DIA_TR_INF("requestResult: DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK"); //Fix for Coverity CID : 16462311
      results.push_back(0x01);
      results.push_back(0xFF);
      break;
   }
   default:
      DIA_TR_ERR("INCORRECT STATUS: 0x%x", mStatus);
      retCode = DIA_E_SEQUENCE_ERROR;
      break;
   }
   return retCode;
}

//------------------------------------------------------------------------------

void
dia_RoutineCtrlCISSWUpdateStage2::vOnAbortStatus (bool resultStage2)
{
   mResultStage2 = 0xFF;
   mIsResultReady = TRUE;
   dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);
   DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage2::vOnAbortStatus()");
   (void) unsetSysAdapterListener<dia_ISWUpdatePrjListener>(this);
   //Fix for Coverity CID : 16462314
   DIA_TR_INF("ResultStage2= %d", resultStage2);   
   DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage2::vOnAbortStatus:Abort Response =%d:",resultStage2);
   restartsystem();
}

void 
dia_RoutineCtrlCISSWUpdateStage2::restartsystem()
{
   tBool errorDetected = TRUE;

   dia_ISpm* pInterface = OSAL_NULL;
   tDiaResult diaResult = querySysAdapterInterface<dia_ISpm>(&pInterface);

   if (diaResult == DIA_SUCCESS)
   {
      if (pInterface)
      {
         (void) setSysAdapterListener<dia_ISpmListener>(this);

         DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage2::restartsystem SENDING RESTART MODE_ECU_FAST.");
         //are we supposed to call this restart????
         //mSystemRestartMode = DIA_EN_SPM_RESTART_MODE_ECU_FAST;
         //dia_eSpmRestartMode restartMode = DIA_EN_SPM_RESTART_MODE_UNKNOWN;DIA_EN_SPM_CORE_RESTART_MODE_ECU_FAST
         if (pInterface->signalSystemRestart(DIA_EN_SPM_RESTART_MODE_ECU_FAST) == DIA_SUCCESS)
         {
            DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage2::restartsystem signalSystemRestart successful");
            errorDetected = FALSE;
         }
         else
         {
            (void) unsetSysAdapterListener<dia_ISpmListener>(this);
            DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage2::restartsystem signalSystemRestart failed");
            DIA_TR_ERR(" ---  SEND TO SPM SERVER FAILED!!!!");
         }
      }
      else
      {
         DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage2::restartsystem pInterface NULL");
      }
   }
   else
   {
      DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage2::restartsystem querySysAdapterInterface failed");
   }

   if ( errorDetected )
   {
      DIA_TR_ERR(" ---  SEND TO SPM SERVER FAILED!!!!");
      DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage2::restartsystem errorDetected is true");
      //return DIA_FAILED;
   }
   
   // mIsResultReady is not set to TRUE, because answer will be sent when service handler has got confirmation from SPM
   // mStatus is not set, because answer will be sent when service handler has got confirmation from SPM
   
}

void
dia_RoutineCtrlCISSWUpdateStage2::vOnCISswUpdateProcessStage2Result( tBool resultStage2 )
{
   DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage2::vOnCISswUpdateProcessStage2Result(tU8)");

   (void) unsetSysAdapterListener<dia_IDisplayPatternAIVIListener>(this);

   DIA_TR_INF("ResultStage2 %d", resultStage2);
   //00-->Sw update continue;01 -->Sw update abort and restart ;
   if( resultStage2 )
   {
      DIA_TR_INF("DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK. SWUpdateStage2 to continue");
      //continue value
      mResultStage2 = 0x00;
      mIsResultReady = TRUE;
      dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);
      //Calling continue method
      vOnRebootContinue(mResultStage2);
   }
   else
   {
      DIA_TR_INF("DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK. SWUpdateStage2 to abort and restart");
      mResultStage2 = 0x01;
      //calling abort and reboot
      mIsResultReady = TRUE;
      dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);
      vOnAbortCondition(mResultStage2);
   }

}

void
dia_RoutineCtrlCISSWUpdateStage2::vOnAbortCondition(tU8 stage2hmiresults)
{
   tDiaResult retCode = DIA_FAILED;
   dia_ISWUpdatePrj* pInterface = 0;
   if (querySysAdapterInterface<dia_ISWUpdatePrj>(&pInterface) == DIA_SUCCESS)
   {
      if (pInterface)
      {
         (tVoid) setSysAdapterListener<dia_ISWUpdatePrjListener>(this);
         if (pInterface->sendAbortRequest() == DIA_SUCCESS)
         {
            DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage2::vOnAbortCondition():sendAbortRequest() OK!");
            eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
            retCode=DIA_SUCCESS;
         }
         else
         {
            (void) unsetSysAdapterListener<dia_ISWUpdatePrjListener>(this);
            DIA_TR_ERR("dia_RoutineCtrlCISSWUpdateStage2::vOnAbortCondition():sendAbortRequest() failed with Errors!");
            eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
            retCode=DIA_SUCCESS;
         }
      }
   }
}

void
dia_RoutineCtrlCISSWUpdateStage2::vOnRebootContinue(tU8 stage2hmiresults)
{
   tDiaResult retCode = DIA_FAILED;
   dia_ISWUpdatePrj* pInterface = 0;
   if (querySysAdapterInterface<dia_ISWUpdatePrj>(&pInterface) == DIA_SUCCESS)
   {
      if (pInterface)
      {
         (tVoid) setSysAdapterListener<dia_ISWUpdatePrjListener>(this);

         //Registration for UpdateError
         if (pInterface->setAllowRecoveryModeRequest(TRUE) == DIA_SUCCESS)
         {
            DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage2::vOnRebootContinue():setAllowRecoveryModeRequest() OK!");
            eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
            retCode=DIA_SUCCESS;
         }
         else
         {
            (void) unsetSysAdapterListener<dia_ISWUpdatePrjListener>(this);
            DIA_TR_ERR("dia_RoutineCtrlCISSWUpdateStage2::vOnRebootContinue():setAllowRecoveryModeRequest() failed with Errors!");
            eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
            retCode=DIA_SUCCESS;
         }
      }
   }
}