/*
 * \file       dia_RoutineCtrlCISSWUpdateStage1.h
 *
 */

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_CIS_SW_UPDATE_STAGE1_H__
#define __INCLUDED_DIA_ROUTINE_CTRL_CIS_SW_UPDATE_STAGE1_H__

#ifndef __INCLUDED_DIA_ROUTINE__
#include "common/framework/protocols/uds/rtctrl/dia_Routine.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SWUPDATEPRJ_LISTENER__
#include "project/interfaces/dia_ISWUpdatePrjListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DISPLAYPATTERNAIVI_LISTENER__
#include "project/interfaces/dia_IDisplayPatternAIVIListener.h"
#endif

class dia_RoutineCtrlCISSWUpdateStage1
      : public dia_Routine,
      public dia_ISWUpdatePrjListenerImpl,
      public dia_IDisplayPatternAIVIListenerImpl
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_RoutineCtrlCISSWUpdateStage1);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_RoutineCtrlCISSWUpdateStage1);
   
public:

   virtual void vOnServiceTimeout ( void );
   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue = DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class

   virtual tDiaResult requestResult  ( std::vector<tU8>& results );
   
   static dia_eRoutineStatus RtctrlStatus;

protected:

   virtual void vOnUpdateErrors(dia_eSWUpdatePrjError eError, bool vCheck );

   virtual void vOnCISswUpdateProcessResult( tBool resultStage1 );

   virtual void vOnUpdateReleaseFilterStatus(tU32 releaseFilter);

private:

   static const tU32 DEFAULT_STATUS   = -1;
   static const tU32 DEFAULT_RESULT   = 2;

   bool mStarted;
   tU8 mSWUpdateStatus;
   tU8 mResultStage1;
   tU8 mSWUpdateOption;

};
#endif /* __INCLUDED_DIA_ROUTINE_CTRL_CIS_SW_UPDATE_STAGE1_H__*/
