/*
 * dia_ReadConfigItem.h
 *
 *  Created on: Dec 20, 2016
 *      Author: hld5kor
 *
 *TTFis:\> DIA_REQ CMD 0 F 0061 3 01
 *TTFis:\> DIA_REQ CMD 0 F 0061 1 01
 *TTFis:\> DIA_REQ CMD 0 F 0061 4 01
 *
 * -----------------------------------------------------------------------------------
 * Date 			| Author			 | Modification                               |
 * 06.09.16    		| hld5kor	  		 | AIVI-26969                                 |
 * ------------------------------------------------------------------------------------
 */

#ifndef __DIA_READCONFIGITEM_H___
#define __DIA_READCONFIGITEM_H___

#ifndef __INCLUDED_DIA_FC_DIAGNOSIS_PROJECT_IF__
#include "project/fc_diagnosis_project_if.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_CONFIGITEM_LISTENER__
#include "common/interfaces/dia_IConfigItemListener.h"
#endif

#ifndef __INCLUDED_DIA_PROPERTY_BAG__
#include "common/framework/config/dia_PropertyBag.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_NOTIFIER__
#include "common/framework/config/dia_ConfigNotifier.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_AIVI_SECURITY_LISTENER__
#include "project/interfaces/dia_IAIVISecurityListener.h"
#endif


class dia_IConfigItemListener;
using namespace std;
//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_ReadConfigItem
    : public dia_PropertyBag,
      public dia_IConfigItem,
      public dia_ConfigNotifier,
      public dia_IEngineClient,
      public dia_IAIVISecurityListenerImpl
{
	DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_ReadConfigItem);
public:

     //! constructor
     dia_ReadConfigItem( void );
	 
     //! class destructor
     virtual ~dia_ReadConfigItem ( void );

     //! open the property bag
     virtual tDiaResult open ( tVoid );
     //! open the property bag
     virtual tDiaResult close ( tVoid );
	 
     //-------------------------------------------------------------------------
     //
     // overloaded methods from dia_IConfigItem
     //
     //-------------------------------------------------------------------------
  
     //! get the ConfigItemEntry Data synchronously
     virtual tDiaResult getConfigItem ( tU32 ConfigItem, tU8** ConfItemData, tU16* ConfigItemDatalength );
     //! get the ConfigItemEntry Data asynchronously
     virtual tDiaResult getConfigItem ( tU32 ConfigItem, dia_IConfigItemListener* pListener, void* cookie );
     //! set the ConfigItemEntry Data synchronously
     virtual tDiaResult setConfigItem ( tU32 ConfigItem, const std::vector<tU8>& ConfItemData );
     //! set the ConfigItemEntry Data asynchronously
     virtual tDiaResult setConfigItem ( tU32 ConfigItem, const std::vector<tU8>& ConfItemData, dia_IConfigItemListener* pListener, void* cookie );
     //! get the Property Details and read Data
     virtual tDiaResult getPropertyDetails ( tU32 PropID );
     //! register a listener for the given ConfigItem
     virtual tDiaResult addConfigItemListener ( tU32 ConfigItem, dia_IConfigItemListener* pListener );
     //! unregister a listener for the given ConfigItem
     virtual tDiaResult removeConfigItemListener ( tU32 ConfigItem, dia_IConfigItemListener* pListener );

     //-------------------------------------------------------------------------
     //
     // Overloaded dia_ConfigNotifier methods
     //
     //-------------------------------------------------------------------------

     //! notification that property propID has been changed
     virtual tDiaResult onPropertyUpdate ( tU32 propID );

     //-------------------------------------------------------------------------
     //
     // overloaded methods from dia_IEngineClient
     //
     //-------------------------------------------------------------------------

     virtual tDiaResult getCallback ( tU32 propID, tDiaResult getStatus, tU8* buff, tU32 buffLen );
     virtual tDiaResult setCallbackU8 ( tU32 propID, tDiaResult setStatus );
     virtual tDiaResult setCallback ( tU32 propID, tDiaResult setStatus, tU8* buff, tU32 buffLen );

     //! Signal to inform requester about the ECU Serial Number Data Identifier
     virtual void vOnEcuSerialNumber ( const std::vector<tU8>& );

protected:

     //! deprecated default constructor
     //dia_ReadConfigItem ( void );

	 //! load the Property Item list
	 tVoid loadPropItem(void);
	 
	 //! get the Property Id based on the ConfigItem
     tU32  getPropItem(tU32 ConfigItem);

protected:
    //! repository of GPIO keys
    //std::map<tU32,const tChar*> mGPIOKeyRep;
    //! repository of registry paths
    //std::map<tU32,const tChar*> mRegPathRep;
    //! repository of registry keys
    //std::map<tU32,const tChar*> mRegKeyRep;
	 //! repository of ConfigItem and PropID
     std::map<tU32,tU32> mConfigItemProp;
	 
	 // data memory
	 std::vector<tU8> PropDataVec;
	 
	 std::map<tU32,dia_IConfigItemListener*> mConfigItemListenerRep;

	 struct Async
	 {
	    dia_IConfigItemListener* pListener;
	    void* cookie;
	 };

    std::map<tU32,Async> mConfigItemRead;
    std::map<tU32,Async> mConfigItemWrite;

	 tU16 dataLength;

};

#endif /*__DIA_READCONFIGITEM_H___*/
