/*
 * dia_MultiplexNetworkDiagRead.h
 *
 */

#ifndef DIA_MULTIPLEXNETWORKDIAGREAD_H_
#define DIA_MULTIPLEXNETWORKDIAGREAD_H_

#ifndef __INCLUDED_DIA_NISSAN_INTERFACE_LISTENER_VCAN__
#include "project/interfaces/dia_INissanVCanInfoListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ERRORLOG_LISTENER__
#include "common/interfaces/dia_IErrorLogListener.h"
#endif

#define RSID_START                          ((tU8)   4) // index where data starts in the DiagMsgBufferUds
#define RSID_LENGTH                         ((tU8) 140) // number of bytes in the data part

class dia_MultiplexNetworkDiagRead
    : public dia_ServiceHandlerUDS,
      public dia_NissanVCanInfoListenerImpl,
      public dia_IErrorLogListenerImpl
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_MultiplexNetworkDiagRead);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_MultiplexNetworkDiagRead);
//   DECL_SERVICE_HANDLER_METHODS(dia_MultiplexNetworkDiagRead);

public:
   virtual void vProcessRequest ( const std::vector<void*>& /*vecArgs*/ );
   //! VCAN network info
   virtual void vOnVCanInfo ( const dia_NissanVCanInfo& nwInfo );
   //! VCAN network info raw bytes
   virtual void vOnVCanInfo ( const std::list<tU8>& deviceInfoList );
   //! notify ITC info
   virtual void vOnITCInfo ( const std::vector<dia_tITCInfo>& );

protected:
   virtual void vAssemblePositiveResponse ( void );
   void   vGetITCInfo();
   void   vAssembleDiagByte(tU8, tU32, tU8);
protected:
   tU8 completionMask;
   //! list of devices. Content First 2bit are status flags. Next 6bit contain the aging counter.
   tU8 responseData[RSID_LENGTH];
};

#endif /* DIA_MULTIPLEXNETWORKDIAGREAD_H_ */
