/*
 * \file        dia_NissanEcuResetKeyOnOffReset.cpp
 *
 * \brief       {insert brief description here}
 *
 * \details     {insert file description here}
 *
 * \author      kaa1hi, stc2hi
 * \date        May 13, 2015
 *
 * \copyright   Robert Bosch Car Multimedia 2015
 */

#ifndef __INCLUDED_DIA_APPCONTROLLER__
#include "common/framework/application/dia_AppController.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_ECURESET_MANAGER__
#include "common/framework/protocols/uds/ecureset/dia_EcuResetManager.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#include "dia_NissanEcuResetKeyOnOffReset.h"

//------------------------------------------------------------------------------

dia_NissanEcuResetKeyOnOffReset::dia_NissanEcuResetKeyOnOffReset ( tCString name, dia_ResetType resetType )
   : dia_EcuResetKeyOnOffReset ( name, resetType )
{
   dia_tclFnctTrace oTrace("dia_NissanEcuResetKeyOnOffReset::dia_NissanEcuResetKeyOnOffReset()");
}

//------------------------------------------------------------------------------

dia_NissanEcuResetKeyOnOffReset::~dia_NissanEcuResetKeyOnOffReset ( void )
{
}

//------------------------------------------------------------------------------

tDiaResetResponse
dia_NissanEcuResetKeyOnOffReset::handleRequest ( void )
{
   dia_tclFnctTrace oTrace("dia_NissanEcuResetKeyOnOffReset::handleRequest()");

   tDiaResult forceflushResult = DIA_FAILED;
   bool testTriggered = false;

   std::vector<void*> args;

   //Trigger Configuration Hash calculation (dia_TestConfigHash)
   dia_TestController* pTestCtrl = getInstanceOfTestController();
   if ( pTestCtrl )
   {
      std::list<dia_Test*> testRep;
      if (DIA_SUCCESS==pTestCtrl->queryTests(DIA_EN_TESTCONDITION_KEY_OFF_ON_RESET, testRep))
      {
         tU32 numTests = testRep.size();
         tU32 expectedUID = dia_getHashCodeFromString("dia_TestConfigHash");

         DIA_TR_INF("dia_NissanEcuResetKeyOnOffReset::handleRequest: Size of mTestRep = %d", numTests);

         for (tU32 i = 0; i < numTests; i++)
         {
            dia_Test* pCurrentTest = testRep.front();
            testRep.pop_front();

            if (pCurrentTest && (pCurrentTest->getTestType() == DIA_EN_TEST_TYPE_SERVICE))
            {
               if (pCurrentTest->getTestUID()==expectedUID)
               {
                  dia_TestService* pTestService = static_cast<dia_TestService*>(pCurrentTest);

                  DIA_TR_INF("Executing TestService (Name = '%s')", pTestService->getName());

                  pTestService->setEmbeddedMode(TRUE);
                  pTestService->vProcessRequest(args);

                  testTriggered = true;
               }
               else
               {
                  DIA_TR_INF("UID: act 0x%08X != exp 0x%08X. Skip (\"%s\")", pCurrentTest->getTestUID(), expectedUID, pCurrentTest->getTestName());
               }
            }
            else
            {
               if (pCurrentTest==NULL)
               {
                  DIA_TR_ERR("dia_NissanEcuResetKeyOnOffReset::handleRequest: NULL ptr in test repository");
               }
               else
               {
                  DIA_TR_INF("dia_NissanEcuResetKeyOnOffReset::handleRequest: Type different than DIA_EN_TEST_TYPE_SERVICE");
               }
            }
         }
      }
      else
      {
         DIA_TR_ERR("dia_NissanEcuResetKeyOnOffReset::handleRequest: KeyOnOffReset condition not found.");
      }
   }

   if (false==testTriggered)
   {
      DIA_TR_ERR("dia_NissanEcuResetKeyOnOffReset::handleRequest: ERROR No test executed before Key-Off-On");
   }

   //Perform flush for all bags.
   dia_ConfigManager* pConfigMgr = getInstanceOfConfigManager();
   if ( pConfigMgr )
   {
      DIA_TR_INF("dia_NissanEcuResetKeyOnOffReset::handleRequest - Flush for all bags");

      forceflushResult = pConfigMgr->forceFlush();
      if (DIA_SUCCESS!=forceflushResult)
      {
         DIA_TR_ERR("dia_NissanEcuResetKeyOnOffReset::handleRequest - Flush FAILED.");
      }
   }
   else
   {
      DIA_TR_ERR("dia_NissanEcuResetKeyOnOffReset::handleRequest - Flush ");
   }

   if (DIA_SUCCESS==forceflushResult)
   {
      DIA_TR_INF("dia_NissanEcuResetKeyOnOffReset::handleRequest - Flushing of all bags was successful.");
   }
   else
   {
      DIA_TR_ERR("dia_NissanEcuResetKeyOnOffReset::handleRequest - SEND NEGATIVE RESPONSE.");
      return DIA_RESET_NEG_RESPONSE;
   }

   dia_ISystemSettings* pInterface = 0;
   tDiaResult retCode = queryInterface<dia_ISystemSettings>(&pInterface);
   if ( (retCode == DIA_SUCCESS) && pInterface )
   {
      // TODO: Clarify whether to use DIA_C_UID_SYSTEM_SETTING_TYPE_ALIGNMENT or DIA_C_UID_SYSTEM_SETTING_TYPE_CALIBRATION.
      // DO NOT use DIA_C_UID_SYSTEM_SETTING_TYPE_CUSTOMER because this is mapped to a DefaultSetting(Customer) but we don't
      // want to activate default values but actual values from the customer!!!
      if ( DIA_SUCCESS == pInterface->processSystemSetting(DIA_C_UID_SYSTEM_SETTING_TYPE_ALIGNMENT,*this,this) )
      {
         DIA_TR_INF("dia_NissanEcuResetKeyOnOffReset::handleRequest => u32StartSystemSet is success!!!");
         return DIA_RESET_WAIT_FOR_SPM;
      }
      else
      {
         DIA_TR_ERR("dia_NissanEcuResetKeyOnOffReset::handleRequest => processSystemSetting FAILED!!!");
      }
   }

   return DIA_RESET_NEG_RESPONSE;
}

//------------------------------------------------------------------------------

void
dia_NissanEcuResetKeyOnOffReset::onSystemSettingProcessed( dia_UID /*typeID*/, const dia_SystemSettingExtendedData& /*extData*/, tDiaResult resultCode, void* cookie )
{
   dia_tclFnctTrace oTrace("dia_NissanEcuResetKeyOnOffReset::onSystemSettingProcessed()");

   if ( cookie != ((void*) this) ) return;

   if (resultCode == DIA_SUCCESS)
   {
      DIA_TR_INF("dia_NissanEcuResetKeyOnOffReset::onSystemSettingProcessed (COMPLETED_OK");

#if 0
      //Register itself as RunLevelListener to receive the Application State change to RunLevel 2 (ON)
      dia_AppController* pAppCtrl = getInstanceOfAppController();
      if ( pAppCtrl )
      {
         pAppCtrl->addRunlevelListener(this);
      }
      else
      {
         DIA_TR_ERR("!!! dia_NissanEcuResetKeyOnOffReset::onSystemSettingProcessed => ERROR: Unable to register for RunLevel changes");
      }

      // Make typical KeyOffOn reset
      (void) dia_EcuResetKeyOnOffReset::handleRequest();
#else
      //Execute a HardReset of both the application and the communication processor
      dia_ISpm* pInterface = OSAL_NULL;
      if ( (querySysAdapterInterface<dia_ISpm>(&pInterface) == DIA_SUCCESS) && pInterface)
      {
         (void) setSysAdapterListener<dia_ISpmListener>(this);
         if (pInterface->signalSystemReset(DIA_EN_SPM_CORE_RESTART_MODE_ECU_FAST) != DIA_SUCCESS)
         {
            DIA_TR_ERR("dia_NissanEcuResetKeyOnOffReset::onSystemSettingProcessed --- signalSystemRestart SEND TO SPM SERVER FAILED");
         }
      }
#endif
   }
   else
   {
      DIA_TR_INF("dia_NissanEcuResetKeyOnOffReset::onSystemSettingProcessed (COMPLETED_AND_NOK");
   }

   //This will send the response (either positive or negative depending on resultCode)
   getInstanceOfEcuResetManager()->vOnEcuResetUpdate(this, resultCode);
}

//------------------------------------------------------------------------------

void
dia_NissanEcuResetKeyOnOffReset::vOnRunLevelChanged ( dia_enRunlevel newLevel, dia_enRunlevel oldLevel )
{
   dia_tclFnctTrace oTrace("dia_NissanEcuResetKeyOnOffReset::vOnRunLevelChanged()");

   if ( (oldLevel == DIA_EN_RUNLEVEL_1/*Off*/) && (newLevel == DIA_EN_RUNLEVEL_2/*Normal*/) )
   {
//      getInstanceOfAppController()->removeRunlevelListener(this);

#if 0
      //Send the positive response
      getInstanceOfEcuResetManager()->vOnEcuResetUpdate(this, DIA_SUCCESS);
#else
      //Execute a HardReset of both the application and the communication processor
      dia_ISpm* pInterface = OSAL_NULL;
      if ( (querySysAdapterInterface<dia_ISpm>(&pInterface) == DIA_SUCCESS) && pInterface)
      {
         (void) setSysAdapterListener<dia_ISpmListener>(this);
         if (pInterface->signalSystemReset(DIA_EN_SPM_CORE_RESTART_MODE_ECU_FAST) != DIA_SUCCESS)
         {
            DIA_TR_ERR("dia_NissanEcuResetKeyOnOffReset::vOnRunLevelChanged --- signalSystemRestart SEND TO SPM SERVER FAILED");
         }
      }
#endif
   }
}

//------------------------------------------------------------------------------

void
dia_NissanEcuResetKeyOnOffReset::vOnSystemRestart ( tDiaResult result )
{
   dia_tclFnctTrace oTrace("dia_NissanEcuResetKeyOnOffReset::vOnSystemRestart()");

   (void) unsetSysAdapterListener<dia_ISpmListener>(this);

   DIA_TR_INF("dia_NissanEcuResetKeyOnOffReset::vOnSystemRestart returned %s", (DIA_SUCCESS==result) ? "DIA_SUCCESS" : "different than DIA_SUCCESS" );

#if 0
   getInstanceOfEcuResetManager()->vOnEcuResetUpdate(this, result);
#else
   DIA_ASSERT(DIA_SUCCESS==result);
#endif
}

//------------------------------------------------------------------------------

