/*
 * dia_MMNetworkDiagRead.h
 *
 */

#ifndef DIA_MMNETWORKDIAGREAD_H_
#define DIA_MMNETWORKDIAGREAD_H_

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/depricated/dia_common_core.h"
#endif

#ifndef __INCLUDED_DIA_NISSAN_INTERFACE_LISTENER_MCAN__
#include "project/interfaces/dia_INissanMCanInfoListener.h"
#endif

#ifndef __INCLUDED_DIA_NISSAN_INTERFACE_LISTENER_BUS_STATE__
#include "project/interfaces/dia_INissanBusStateListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TCU_LISTENER__
#include "project/interfaces/dia_ITCUListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ERRORLOG_LISTENER__
#include "common/interfaces/dia_IErrorLogListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SWC_LISTENER__
#include "project/interfaces/dia_ISWControlListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_IT_COMMANDER_LISTENER__
#include "project/interfaces/dia_IITCommanderListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_REAR_CONTROL_SWITCH_LISTENER__
#include "project/interfaces/dia_IRearControlSwitchListener.h"
#endif


class dia_MMNetworkDiagRead
    : public dia_ServiceHandlerUDS,
      public dia_NissanMCanInfoListenerImpl,
      public dia_NissanBusStateListenerImpl,
      public dia_TCUListenerImpl,
      public dia_IErrorLogListenerImpl,
	  public dia_ISWControlListenerImpl,
	  public dia_ITCommanderListenerImpl,
	  public dia_RearControlSwitchListenerImpl
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_MMNetworkDiagRead);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_MMNetworkDiagRead);
//   DECL_SERVICE_HANDLER_METHODS(dia_MMNetworkDiagRead);

public:
   virtual void vProcessRequest ( const std::vector<void*>& vecArgs );
   //! notify MCAN network info
   virtual void vOnMCanInfo ( const dia_NissanMCanInfo& nwInfo );   //! notify network bus status
   virtual void vOnConnectionInfo ( const dia_TCUConnectionInfo& nwInfo );
   virtual void vOnConnectionInfo ( const dia_ITCommanderConnectionInfo& );
   virtual void vOnConnectionInfo ( const dia_RcsConnectionInfo& );
   virtual void vOnBusStateInfo ( const dia_NissanBusState& busState );
   //! notify ITC info
   virtual void vOnITCInfo ( std::vector<dia_tITCInfo> const& );
   //! notify SWC connection info
   virtual void vOnSWCConnectionInfo ( const dia_SWCConnectionInfo& );
protected:
   virtual void vAssemblePositiveResponse ( void );
   void   vGetITCInfo ( void );
   void   vAssembleDiagByte(tU8, tU32, tU8);
   tU8    u8MergeStatus(tU8, tU8) const;
   void   vUpdateClusterAbsentState ( void );

protected:
   //!
   tU8 completionMask;
   //!
   tU8 responseData[256];
   //! 
   tU8 m_clusterAbsentState;
   //! 
   tU8 m_SWCAbsentState;
   //!
   bool bIsMeterInfo;
   //!
   bool bIsSWCInfo;

};

#endif /* DIA_MMNETWORKDIAGREAD_H_ */
