/*
 * dia_MMNetworkDiagRead.cpp
 *
 *  Created on: 22.09.2010
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/depricated/dia_common_core.h"
#endif

#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include "vd_diaglog_if.h"

#include "project/interfaces/dia_INissanVCanInfo.h"
#include "project/interfaces/dia_INissanMCanInfo.h"

#ifndef __INCLUDED_DIA_INTERFACE_SWC__
#include "project/interfaces/dia_ISWControl.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ERROR_LOG__
#include "common/interfaces/dia_IErrorLog.h"
#endif

#include "dia_MultimediaNetworkDiagRead.h"

const tU8 RSID_START                        = 4;   // index where data starts in the DiagMsgBufferUds
const tU8 RSID_LENGTH                       = 140; // number of bytes in the data part

const tU8 DIA_INDEX_BUS_OFF                 = 2;
const tU8 DIA_INDEX_CMF_MUTE                = 3;
const tU8 DIA_INDEX_ABSENT_CSW              = 5;
const tU8 DIA_INDEX_ABSENT_RCS              = 7;
const tU8 DIA_INDEX_ABSENT_CLUSTER          = 29;
const tU8 DIA_INDEX_ABSENT_TCU              = 41;

const tU8 DIA_ABSENT_TYPE_ABSENT_CONFIRMED  = 0xc0;
const tU8 DIA_ABSENT_TYPE_MASKED            = 0xff;

const tU8 DIA_ABSENT_STATE_CLUSTER          = 0x01;
const tU8 DIA_ABSENT_STATE_TCU              = 0x02;
const tU8 DIA_ABSENT_STATE_ITCOMM           = 0x04;
const tU8 DIA_ABSENT_STATE_RCS              = 0x08;
const tU8 DIA_BUS_STATE_COMPLETE            = 0x80;
const tU8 DIA_COMPLETION_MASK               = (DIA_ABSENT_STATE_CLUSTER|
                                                DIA_ABSENT_STATE_TCU|
                                                DIA_ABSENT_STATE_ITCOMM|
                                                DIA_ABSENT_STATE_RCS|
                                                DIA_BUS_STATE_COMPLETE);



#define DIA_EN_NISSAN_ECU_MCAN_MUTE_AUD (ITC_AIVI_MCAN_METER_AUD_CMF_MUTE_ERR - ITC_AIVI_MCAN_START)
#define DIA_EN_NISSAN_ECU_MCAN_MUTE_SWC (ITC_AIVI_MCAN_METER_SWC_CMF_MUTE_ERR - ITC_AIVI_MCAN_START)
#define DIA_EN_NISSAN_ECU_MCAN_MUTE_NAV (ITC_AIVI_MCAN_METER_NAV_CMF_MUTE_ERR - ITC_AIVI_MCAN_START)


static tU8 msgDefaultContent[RSID_LENGTH] = {
    0x12, 0x47, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xff, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

//------------------------------------------------------------------------------

dia_MMNetworkDiagRead::dia_MMNetworkDiagRead ( void )
   : dia_ServiceHandlerUDS("dia_MMNetworkDiagRead",
         DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,
         DIA_C_U16_DID_AIVI_MULTIMEDIA_NETWORK_DIAG,
           // Because of the many involved components a longer service handler timeout is needed.
           3*DIA_C_U32_MAX_PROCESSING_TIME_SERVICE_UDS),
           completionMask(0x00),
          m_clusterAbsentState(DIA_ABSENT_TYPE_MASKED),
         m_SWCAbsentState(DIA_ABSENT_TYPE_MASKED),
         bIsMeterInfo(false),
         bIsSWCInfo(false)
{
   dia_tclFnctTrace oTrace("dia_MMNetworkDiagRead::dia_MMNetworkDiagRead()");
   (void) ::memset(&responseData[0],0,256);
}

//------------------------------------------------------------------------------

dia_MMNetworkDiagRead::~dia_MMNetworkDiagRead ( void )
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_INissanMCanInfoListener>(this);
      (void) unsetSysAdapterListener<dia_INissanBusStateListener>(this);
      (void) unsetSysAdapterListener<dia_ITCUListener>(this);
      (void) unsetSysAdapterListener<dia_IErrorLogListener>(this);
     (void) unsetSysAdapterListener<dia_ISWControlListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_MMNetworkDiagRead::~dia_MMNetworkDiagRead !!!");
      NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------
//  Msg contents:
//      byte[0] = Number of bytes in message
//      byte[1] = Service ID
//      byte[2] = DID

void
dia_MMNetworkDiagRead::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_MMNetworkDiagRead::vProcessRequest");

   (void) setSysAdapterListener<dia_INissanMCanInfoListener>(this);
   (void) setSysAdapterListener<dia_INissanBusStateListener>(this);
   (void) setSysAdapterListener<dia_ISWControlListener>(this);

   completionMask = 0x00;

   (void) ::memcpy(&responseData[0],&msgDefaultContent[0],RSID_LENGTH);

   // check if we have received the right coding value length
   tU16 dataLength = oDiagMsgBuffer().u16GetDataLength();
   if ( dataLength != RSID_START )
   {
       vSendNegativeResponse(DIA_E_U8_UDS_SUBFUNCTION_NOT_SUPPORTED);
       return;
   }

   //----------- Bus and Mute State

   dia_INissanVCanInfo* pVInfo = OSAL_NULL;
   querySysAdapterInterface<dia_INissanVCanInfo>(&pVInfo);
   if ( pVInfo && (pVInfo->getNissanVCANInfo() == DIA_SUCCESS) )
   {
       DIA_TR_INF("dia_MMNetworkDiagRead::vProcessRequest - Successfully sent getNissanVCANInfo request");
   }
   else
   {
       DIA_TR_ERR("dia_MMNetworkDiagRead::vProcessRequest - getNissanVCANInfo request failed. Pointer: 0x%p", pVInfo);
       vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
       return;
   }

   //----------- Absent State of Cluster

   dia_INissanMCanInfo* pMInfo = OSAL_NULL;
   querySysAdapterInterface<dia_INissanMCanInfo>(&pMInfo);

   if ( pMInfo && (pMInfo->getNissanMCANInfo() == DIA_SUCCESS) )
   {
       DIA_TR_INF("dia_MMNetworkDiagRead::vProcessRequest - Successfully sent getNissanMCANInfo request");
   }
   else
   {
       DIA_TR_ERR("dia_MMNetworkDiagRead::vProcessRequest - getNissanMCANInfo request failed. Pointer: 0x%p", pMInfo);
       vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }

   //----------- Absent State of SWC (from vd_clock)

   dia_ISWControl* pSWCInfo = OSAL_NULL;
   querySysAdapterInterface<dia_ISWControl>(&pSWCInfo);

   if ( pSWCInfo && (pSWCInfo->getSWCConnectionInfo() == DIA_SUCCESS) )
   {
       DIA_TR_INF("dia_MMNetworkDiagRead::vProcessRequest - Successfully sent getSWCConnectionInfo request");
   }
   else
   {
       DIA_TR_ERR("dia_MMNetworkDiagRead::vProcessRequest - getSWCConnectionInfo request failed. Pointer: %x", (tU32) pSWCInfo);
       vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }


   //----------- Absent State of TCU

   dia_ITCU* pTCUInfo = OSAL_NULL;
   if ( (querySysAdapterInterface<dia_ITCU>(&pTCUInfo) == DIA_SUCCESS) && pTCUInfo )
   {
      (void) setSysAdapterListener<dia_ITCUListener>(this);

      if (pTCUInfo->getConnectionInfo() == DIA_SUCCESS)
      {
         DIA_TR_INF("dia_MMNetworkDiagRead::vProcessRequest - Successfully sent getConnectionInfo request to TCU");
      }
   }
   else
   {
      DIA_TR_ERR("dia_MMNetworkDiagRead::vProcessRequest - getConnectionInfo(TCU) request failed. Pointer: %x", (tU32) pTCUInfo);
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }

   //----------- Absent State of ITCommander

   dia_IITCommander* pITCommanderInfo = OSAL_NULL;
   if ( (querySysAdapterInterface<dia_IITCommander>(&pITCommanderInfo) == DIA_SUCCESS) && pITCommanderInfo )
   {
      (void) setSysAdapterListener<dia_IITCommanderListener>(this);

      if (pITCommanderInfo->getConnectionInfo() == DIA_SUCCESS)
      {
         DIA_TR_INF("dia_MMNetworkDiagRead::vProcessRequest - Successfully sent getConnectionInfo request to ITCommander");
      }
   }
   else
   {
      DIA_TR_ERR("dia_MMNetworkDiagRead::vProcessRequest - getConnectionInfo(ITComm) request failed. Pointer: %x", (tU32) pITCommanderInfo);
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }

   //----------- Absent State of RearControlSwitch

   dia_IRearControlSwitch* pRcsInfo = OSAL_NULL;
   if ( (querySysAdapterInterface<dia_IRearControlSwitch>(&pRcsInfo) == DIA_SUCCESS) && pRcsInfo )
   {
      (void) setSysAdapterListener<dia_IRearControlSwitchListener>(this);

      if (pRcsInfo->getRcsConnectionInfo() == DIA_SUCCESS)
      {
         DIA_TR_INF("dia_MMNetworkDiagRead::vProcessRequest - Successfully sent getConnectionInfo request to RearControlSwitch");
      }
   }
   else
   {
      DIA_TR_ERR("dia_MMNetworkDiagRead::vProcessRequest - getConnectionInfo(RCS) request failed. Pointer: %x", (tU32) pRcsInfo);
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

//void
//dia_MMNetworkDiagRead::vOnTimeout ( void )
//{
//   dia_tclFnctTrace trc("dia_MMNetworkDiagRead::vOnTimeout");
//
//   vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
//}
//
//-----------------------------------------------------------------------------

void
dia_MMNetworkDiagRead::vOnMCanInfo ( const dia_NissanMCanInfo& nwInfo )
{
    (void) unsetSysAdapterListener<dia_INissanMCanInfoListener>(this);

    DIA_TR_INF("dia_MMNetworkDiagRead::vOnMCanInfo - absent state AUD: %x", nwInfo.u8AbsentState(DIA_EN_NISSAN_ECU_MCAN_AUD));
    DIA_TR_INF("dia_MMNetworkDiagRead::vOnMCanInfo - absent state SWC: %x", nwInfo.u8AbsentState(DIA_EN_NISSAN_ECU_MCAN_SWC));
    DIA_TR_INF("dia_MMNetworkDiagRead::vOnMCanInfo - absent state NAV: %x", nwInfo.u8AbsentState(DIA_EN_NISSAN_ECU_MCAN_NAV));
    DIA_TR_INF("dia_MMNetworkDiagRead::vOnMCanInfo - absent state NAV Gen2: %x", nwInfo.u8AbsentState(DIA_EN_NISSAN_ECU_MCAN_NAV_GEN2));
    tU8 val = u8MergeStatus(nwInfo.u8AbsentState(DIA_EN_NISSAN_ECU_MCAN_AUD), nwInfo.u8AbsentState(DIA_EN_NISSAN_ECU_MCAN_NAV));
    m_clusterAbsentState = u8MergeStatus(val, nwInfo.u8AbsentState(DIA_EN_NISSAN_ECU_MCAN_NAV_GEN2));

    DIA_TR_INF("dia_MMNetworkDiagRead::vOnMCanInfo - absent state merged: %x", m_clusterAbsentState);

    bIsMeterInfo = true;
    vUpdateClusterAbsentState();
}

//-----------------------------------------------------------------------------

void
dia_MMNetworkDiagRead::vUpdateClusterAbsentState ( void )
{
   dia_tclFnctTrace trc("dia_MMNetworkDiagRead::vUpdateClusterAbsentState");
   if ((bIsSWCInfo == true) && (bIsMeterInfo == true))
   {
      m_clusterAbsentState = u8MergeStatus(m_clusterAbsentState,m_SWCAbsentState);
      DIA_TR_INF("dia_MMNetworkDiagRead::vUpdateClusterAbsentState - absent state merged: %x", m_clusterAbsentState);
      responseData[DIA_INDEX_ABSENT_CLUSTER] = m_clusterAbsentState;
      bIsMeterInfo = false;
       bIsSWCInfo = false;
      completionMask |= DIA_ABSENT_STATE_CLUSTER;
      if ( completionMask == DIA_COMPLETION_MASK )
       {
         vGetITCInfo();
       }
   }
   else
   {
      DIA_TR_INF("vUpdateClusterAbsentState - absent state for both SWC and Meter not yet available");
   }

}

//-----------------------------------------------------------------------------
void
dia_MMNetworkDiagRead::vOnBusStateInfo ( const dia_NissanBusState& busState )
{
    (void) unsetSysAdapterListener<dia_INissanBusStateListener>(this);

    responseData[DIA_INDEX_BUS_OFF] = busState.getDiagByte(DIA_EN_NISSAN_BUS_MCAN);
#if 0
    responseData[DIA_INDEX_CMF_MUTE] = busState.getDiagByte(DIA_EN_NISSAN_MUTE_MCAN);
#else
    DIA_TR_INF("dia_MMNetworkDiagRead::vOnBusStateInfo - mute state AUD: %x", busState.getMCanMuteState(DIA_EN_NISSAN_ECU_MCAN_MUTE_AUD));
    DIA_TR_INF("dia_MMNetworkDiagRead::vOnBusStateInfo - mute state SWC: %x", busState.getMCanMuteState(DIA_EN_NISSAN_ECU_MCAN_MUTE_SWC));
    DIA_TR_INF("dia_MMNetworkDiagRead::vOnBusStateInfo - mute state NAV: %x", busState.getMCanMuteState(DIA_EN_NISSAN_ECU_MCAN_MUTE_NAV));
    tU8 val = u8MergeStatus(busState.getMCanMuteState(DIA_EN_NISSAN_ECU_MCAN_MUTE_AUD), busState.getMCanMuteState(DIA_EN_NISSAN_ECU_MCAN_MUTE_SWC));
#if 0 //STC2HI: Need to clarify
    val = u8MergeStatus(val, busState.getMCanMuteState(DIA_EN_NISSAN_ECU_MCAN_MUTE_NAV)); //Not supported for scope 1
#endif
    DIA_TR_INF("dia_MMNetworkDiagRead::vOnBusStateInfo - mute state merged: %x", val);
    responseData[DIA_INDEX_CMF_MUTE] = val;
#endif

    completionMask |= DIA_BUS_STATE_COMPLETE;
    if ( completionMask == DIA_COMPLETION_MASK )
    {
        vGetITCInfo();
    }
}

//-----------------------------------------------------------------------------

void
dia_MMNetworkDiagRead::vOnConnectionInfo ( const dia_TCUConnectionInfo& nwInfo )
{
   dia_tclFnctTrace trc("dia_MMNetworkDiagRead::vOnConnectionInfo(TCU)");

   (void) unsetSysAdapterListener<dia_ITCUListener>(this);

   tU8 val = nwInfo.getAbsentState();

   DIA_TR_INF("dia_MMNetworkDiagRead::vOnConnectionInfo - absent state TCU: 0x%x", val);

   responseData[DIA_INDEX_ABSENT_TCU] = val;
   completionMask |= DIA_ABSENT_STATE_TCU;
   if ( completionMask == DIA_COMPLETION_MASK )
   {
       vGetITCInfo();
   }
}

//-----------------------------------------------------------------------------
void
dia_MMNetworkDiagRead::vOnSWCConnectionInfo ( const dia_SWCConnectionInfo& swcInfo)
{
   dia_tclFnctTrace trc("dia_MMNetworkDiagRead::vOnSWCConnectionInfo(dia_SWCConnectionInfo)");

   (void) unsetSysAdapterListener<dia_ISWControlListener>(this);

   m_SWCAbsentState = swcInfo.getAbsentState();

   DIA_TR_INF("dia_MMNetworkDiagRead::vOnConnectionInfo - absent state TCU: 0x%x", m_SWCAbsentState);

   bIsSWCInfo = true;
   vUpdateClusterAbsentState();
}

//-----------------------------------------------------------------------------

void
dia_MMNetworkDiagRead::vOnConnectionInfo ( const dia_ITCommanderConnectionInfo& nwInfo)
{
   dia_tclFnctTrace trc("dia_MMNetworkDiagRead::vOnConnectionInfo(ITComm)");

   (void) unsetSysAdapterListener<dia_IITCommanderListener>(this);

   tU8 val = nwInfo.getAbsentState();

   DIA_TR_INF("dia_MMNetworkDiagRead::vOnConnectionInfo - absent state ITCommander: 0x%x", val);

   responseData[DIA_INDEX_ABSENT_CSW] = val;
   completionMask |= DIA_ABSENT_STATE_ITCOMM;
   if ( completionMask == DIA_COMPLETION_MASK )
   {
       vGetITCInfo();
   }
}

//-----------------------------------------------------------------------------

void
dia_MMNetworkDiagRead::vOnConnectionInfo ( const dia_RcsConnectionInfo& nwInfo)
{
   dia_tclFnctTrace trc("dia_MMNetworkDiagRead::vOnConnectionInfo(RCS)");

   (void) unsetSysAdapterListener<dia_IRearControlSwitchListener>(this);

   tU8 val = nwInfo.getAbsentState();

   DIA_TR_INF("dia_MMNetworkDiagRead::vOnConnectionInfo - absent state RearControlSwitch: 0x%x", val);

   responseData[DIA_INDEX_ABSENT_RCS] = val;
   completionMask |= DIA_ABSENT_STATE_RCS;
   if ( completionMask == DIA_COMPLETION_MASK )
   {
       vGetITCInfo();
   }
}

//-----------------------------------------------------------------------------

void
dia_MMNetworkDiagRead::vAssemblePositiveResponse ( void )
{
    oDiagMsgBuffer().vSetPosResp();
    oDiagMsgBuffer().vSetDataLength(RSID_LENGTH+3);

    for ( tU16 i=0; i<RSID_LENGTH; ++i)
    {
       (void) oDiagMsgBuffer().vSetDataU8(i+3, responseData[i]);
    }

    vResReadyAndQuit();
}

//-----------------------------------------------------------------------------

void
dia_MMNetworkDiagRead::vGetITCInfo ( void )
{
   dia_tclFnctTrace trc("dia_MMNetworkDiagRead::vGetITCInfo");

   dia_IErrorLog* pErrorLog = OSAL_NULL;
   if ((DIA_SUCCESS == querySysAdapterInterface<dia_IErrorLog>(&pErrorLog)) && pErrorLog)
   {
      std::vector<tU16> oITCList;
      oITCList.push_back(VDL_ITC_MCAN_BUS_OFF);

   #if 1
      oITCList.push_back(ITC_AIVI_MCAN_METER_AUD_CMF_MUTE_ERR);
      oITCList.push_back(ITC_AIVI_MCAN_METER_SWC_CMF_MUTE_ERR);
      oITCList.push_back(ITC_AIVI_MCAN_METER_NAV_CMF_MUTE_ERR); //Not supported for scope 1
   #else
      oITCList.push_back(ITC_AIVI_MCAN_METER_AUD_MPDT_MUTE_ERR);
   #endif

      tU8 u8Index = DIA_INDEX_ABSENT_CLUSTER;
      if (responseData[u8Index] != 0xFF)
      {
         tU8 counterValue = responseData[u8Index] & 0x3F;
         if (counterValue == 0)
         {
            oITCList.push_back(ITC_AIVI_MCAN_METER_AUD_COM_ERR);
            oITCList.push_back(ITC_AIVI_MCAN_METER_SWC_COM_ERR);
            oITCList.push_back(ITC_AIVI_MCAN_METER_NAV_COM_ERR);
            oITCList.push_back(ITC_AIVI_MCAN_METER_NAV_GEN2_COM_ERR);
         }
      }

      u8Index = DIA_INDEX_ABSENT_TCU;
      if (responseData[u8Index] != 0xFF)
      {
         tU8 counterValue = responseData[u8Index] & 0x3F;
         if (counterValue == 0)
         {
            oITCList.push_back(ITC_AIVI_MCAN_TCU_COM_ERR);
         }
      }

      u8Index = DIA_INDEX_ABSENT_CSW;
      if (responseData[u8Index] != 0xFF)
      {
         tU8 counterValue = responseData[u8Index] & 0x3F;
         if (counterValue == 0)
         {
            oITCList.push_back(ITC_AIVI_MCAN_IT_COMM_COM_ERR);
         }
      }

      u8Index = DIA_INDEX_ABSENT_RCS;
      if (responseData[u8Index] != 0xFF)
      {
         tU8 counterValue = responseData[u8Index] & 0x3F;
         if (counterValue == 0)
         {
            oITCList.push_back(ITC_AIVI_MCAN_REAR_SW_COM_ERR);
         }
      }

      (void) setSysAdapterListener<dia_IErrorLogListener>(this);

      if ( pErrorLog->getItcInformation(DIAGLOG_MEMORY_CUSTOMER|DIAGLOG_MEMORY_BOSCH, oITCList) == DIA_SUCCESS )
      {
         DIA_TR_INF("dia_MMNetworkDiagRead::vGetITCInfo - getItcInformation oITCList.size()=%d", oITCList.size());
         if (oITCList.size()>0)
         {
            DIA_TR_INF("dia_MMNetworkDiagRead::vGetITCInfo - getItcInformation oITCList[0]=0x%04X.", oITCList[0]);
         }
      }
      else
      {
         DIA_TR_ERR("dia_MMNetworkDiagRead::vGetITCInfo - getItcInformation request failed.");
         (void) unsetSysAdapterListener<dia_IErrorLogListener>(this);
         vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      }
   }
   else
   {
      DIA_TR_ERR("dia_MMNetworkDiagRead::vGetITCInfo - getItcInformation request failed. Pointer: %x", (tU32) pErrorLog);
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}
//-----------------------------------------------------------------------------

void dia_MMNetworkDiagRead::vOnITCInfo ( const std::vector<dia_tITCInfo>& roITCInfoList)
{
    dia_tclFnctTrace trc("dia_MMNetworkDiagRead::vOnITCInfo");

    (void) unsetSysAdapterListener<dia_IErrorLogListener>(this);

    DIA_TR_INF("dia_MMNetworkDiagRead::vOnITCInfo roITCInfoList.size() %d", roITCInfoList.size());

    for(::size_t i = 0; i < roITCInfoList.size(); ++i)
    {
        switch(roITCInfoList[i].m_u16ITC)
        {
        case VDL_ITC_MCAN_BUS_OFF:
            vAssembleDiagByte(DIA_INDEX_BUS_OFF, roITCInfoList[i].m_u32AgeingCounter,  roITCInfoList[i].m_u8Status);
            break;
        case ITC_AIVI_MCAN_METER_AUD_COM_ERR:
            vAssembleDiagByte(DIA_INDEX_ABSENT_CLUSTER, roITCInfoList[i].m_u32AgeingCounter, roITCInfoList[i].m_u8Status);
            break;
        case ITC_AIVI_MCAN_METER_SWC_COM_ERR:
            vAssembleDiagByte(DIA_INDEX_ABSENT_CLUSTER, roITCInfoList[i].m_u32AgeingCounter,  roITCInfoList[i].m_u8Status);
            break;
        case ITC_AIVI_MCAN_METER_NAV_COM_ERR:
            vAssembleDiagByte(DIA_INDEX_ABSENT_CLUSTER, roITCInfoList[i].m_u32AgeingCounter, roITCInfoList[i].m_u8Status);
            break;

        case ITC_AIVI_MCAN_METER_NAV_GEN2_COM_ERR:
           vAssembleDiagByte(DIA_INDEX_ABSENT_CLUSTER, roITCInfoList[i].m_u32AgeingCounter, roITCInfoList[i].m_u8Status);
           break;
#if 1
        case ITC_AIVI_MCAN_METER_AUD_CMF_MUTE_ERR:
            vAssembleDiagByte(DIA_INDEX_CMF_MUTE, roITCInfoList[i].m_u32AgeingCounter,  roITCInfoList[i].m_u8Status);
            break;
        case ITC_AIVI_MCAN_METER_SWC_CMF_MUTE_ERR:
            vAssembleDiagByte(DIA_INDEX_CMF_MUTE, roITCInfoList[i].m_u32AgeingCounter,  roITCInfoList[i].m_u8Status);
            break;
#if 0 //STC2HI: Need to clarify
        case ITC_AIVI_MCAN_METER_NAV_CMF_MUTE_ERR:
            vAssembleDiagByte(DIA_INDEX_CMF_MUTE, roITCInfoList[i].m_u32AgeingCounter, roITCInfoList[i].m_u8Status);
            break;
#endif
#else
        case ITC_AIVI_MCAN_METER_AUD_MPDT_MUTE_ERR:
            vAssembleDiagByte(DIA_INDEX_CMF_MUTE, roITCInfoList[i].m_u32AgeingCounter, roITCInfoList[i].m_u8Status);
            break;
#endif
        case ITC_AIVI_MCAN_TCU_COM_ERR:
            vAssembleDiagByte(DIA_INDEX_ABSENT_TCU, roITCInfoList[i].m_u32AgeingCounter, roITCInfoList[i].m_u8Status);
            break;

        case ITC_AIVI_MCAN_IT_COMM_COM_ERR:
            vAssembleDiagByte(DIA_INDEX_ABSENT_CSW, roITCInfoList[i].m_u32AgeingCounter, roITCInfoList[i].m_u8Status);
            break;

        case ITC_AIVI_MCAN_REAR_SW_COM_ERR:
           vAssembleDiagByte(DIA_INDEX_ABSENT_RCS, roITCInfoList[i].m_u32AgeingCounter, roITCInfoList[i].m_u8Status);
            break;

        default:
            break;
        }
    }

    vAssemblePositiveResponse();
}
//-----------------------------------------------------------------------------

void dia_MMNetworkDiagRead::vAssembleDiagByte(tU8 u8Index, tU32 u32AgeingCounter, tU8 u8Status)
{
    dia_tclFnctTrace trc("dia_MMNetworkDiagRead::vAssembleDiagByte");
    const tU8 c_maxAge = 40;
    const tU8 c_confirmedBit = 0x08;
    const tU8 c_faultCountMask = 0x3f;
    const tU8 c_confirmedMask = 0xc0;
    const tU8 c_maskedMask = 0xff;

    DIA_TR_INF("dia_MMNetworkDiagRead::vAssembleDiagByte - Pos [%d], AgeingCounter=0x%02x, Status=0x%02x.", u8Index, u32AgeingCounter, u8Status);

    // byte is masked so return
    if (responseData[u8Index] == c_maskedMask)
    {
      DIA_TR_INF("dia_MMNetworkDiagRead::vAssembleDiagByte - byte is masked so return.");
      return;
    }

    tU32 faultCount = 0;
    // if error is confirmed in diaglog compute M_xxx
    if (u8Status & c_confirmedBit)
    {
      faultCount = (u32AgeingCounter == c_maxAge) ? 1 : c_maxAge - u32AgeingCounter;
    }

    tU8 diagByte = faultCount & c_faultCountMask;
    tU8 oldFaultCount = responseData[u8Index] & c_faultCountMask;

    DIA_TR_INF("dia_MMNetworkDiagRead::vAssembleDiagByte - oldFaultCount: %x", oldFaultCount);
    DIA_TR_INF("dia_MMNetworkDiagRead::vAssembleDiagByte - Index: %x", u8Index);
    DIA_TR_INF("dia_MMNetworkDiagRead::vAssembleDiagByte - Age: %x", u32AgeingCounter);
    DIA_TR_INF("dia_MMNetworkDiagRead::vAssembleDiagByte - Status: %x", u8Status);
    DIA_TR_INF("dia_MMNetworkDiagRead::vAssembleDiagByte - fc: %x", faultCount);
    DIA_TR_INF("dia_MMNetworkDiagRead::vAssembleDiagByte - db: %x", diagByte);

    responseData[u8Index] &= c_confirmedMask;

    //Merge the fault counter for SWC/AUD/NAV (take the highest one)
    responseData[u8Index] |= (diagByte > oldFaultCount)? diagByte: oldFaultCount;
}

tU8 dia_MMNetworkDiagRead::u8MergeStatus(tU8 val1, tU8 val2) const
{
   DIA_TR_INF("dia_MMNetworkDiagRead::u8MergeStatus(tU8 val1, tU8 val2)");

   tU8 result = DIA_ABSENT_TYPE_MASKED;

   //If val1 and val2 are FF
   if((val1 == DIA_ABSENT_TYPE_MASKED) && (val2 == DIA_ABSENT_TYPE_MASKED))
   {
     DIA_TR_INF("dia_MMNetworkDiagRead::u8MergeStatus val1 and val2 are 0xFF");
      return result;
   }

   if(DIA_ABSENT_TYPE_MASKED == val1)
   {
      DIA_TR_INF("dia_MMNetworkDiagRead::u8MergeStatus val1 is 0xFF");
      result = val2;
   }
   else if(DIA_ABSENT_TYPE_MASKED == val2 )
   {
      DIA_TR_INF("dia_MMNetworkDiagRead::u8MergeStatus val2 is 0xFF");
      result = val1;
   }
   else
   {
      DIA_TR_INF("dia_MMNetworkDiagRead::u8MergeStatus Merge val1 and val2");
      result = val1 | val2;
   }

   result &= DIA_ABSENT_TYPE_ABSENT_CONFIRMED;
   return result;
}
