/*
 * dia_IOCtrlTunerSettings.h
 *
 *  Created on: 05.11.2015
 *      Author: shw2abt
 */

#ifndef dia_IOCtrl_TUNERSETTINGS_H_
#define dia_IOCtrl_TUNERSETTINGS_H_

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL_RESTRICTED_TO_REMOTE_CONTROL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignalRestrictedToRemoteControl.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_AMFMTUNER_LISTENER__
#include "common/interfaces/dia_ITunerAMFMListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TUNERMASTER_LISTENER__
#include "common/interfaces/dia_ITunerMasterListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TUNERDABCONTROL_LISTENER__
#include "common/interfaces/dia_ITunerDABControlListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_AUDIOSOURCE_LISTENER__
#include "common/interfaces/dia_IAudioSourceListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_REMOTECONTROL_LISTENER__
#include <common/interfaces/dia_IRemoteControlListener.h>
#endif

#ifndef __INCLUDED_DIA_AUDIO_MANAGER_CLIENT__
#include <common/framework/platform/cmd/dia_AudioManagerClient.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TIMER_LISTENER__
#include <common/interfaces/dia_ITimerListener.h>
#endif


class dia_IOCtrlTunerSettings;

typedef tDiaResult (dia_IOCtrlTunerSettings::* /*const*/ FP)(tU32);

typedef enum
{
   TUNER_TYPE_UNKNOWN = 0x00,
   TUNER_TYPE_FM1 = 0x01,
   TUNER_TYPE_FM2 = 0x02,
   TUNER_TYPE_AM  = 0x11,
   TUNER_TYPE_DAB = 0x21
} TunerType;

typedef enum
{
   JOB_RETURN_CODE_UNKNOWN = 0,
   JOB_RETURN_CODE_OK_AND_WAIT_FOR_NEXT_TASK,   /* task has been triggered, but the task queue is not empty */
   JOB_RETURN_CODE_OK_AND_NO_NEXT_TASKS,        /* last task has been triggered, there is no tasks in the queue */
   JOB_RETURN_CODE_NO_TASK_TO_BE_TRIGGERED,     /* no task to be triggered */
   JOB_RETURN_CODE_ERROR                        /* undefined error */
} JobReturnCode;

class dia_IOCtrlTunerSettings
   : public dia_IOCtrlSignal,
     public dia_ITunerAMFMListenerImpl,
     public dia_ITunerMasterListenerImpl,
     public dia_ITunerDABControlListenerImpl,
     public dia_IAudioSourceListenerImpl,
     public dia_IRemoteControlListenerImpl,
     public dia::AudioManagerClient,
     public dia_ITimerListener
{
public:
   //! class constructor
   dia_IOCtrlTunerSettings ( void );
   //! class destructor
   virtual ~dia_IOCtrlTunerSettings ( void );

   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );
   //!
   virtual void handleTimeout ( void );
   //! overwrite super-class function. For this service shall be none freeze/return-control signal
   virtual bool isFrozen ( void ) const {return true;}

   // **************************************************************************
   // overloaded methods from dia_IRemoteControlListenerImpl base class
   // **************************************************************************
   //! remote control mode has been changed to the given mode
   virtual void vOnRemoteControlModeChanged ( dia_eRemoteCtrlMode newMode, dia_eRemoteCtrlMode prevMode );

   // **************************************************************************
   // overloaded methods from dia_ITunerAMFMListenerImpl base class
   // **************************************************************************
   //! Signal to inform requester about success of the track change request
   virtual void vOnTunerAMFMFrequency_Set ( tDiaResult success );

   // **************************************************************************
   // overloaded methods from dia_ITunerMasterListenerImpl base class
   // **************************************************************************
   //! result on the selectActiveTuner_Set call
   virtual void vOnTunerAMFMActiveTuner_Set ( tDiaResult success );

   // **************************************************************************
   // overloaded methods from dia_ITunerDABControlListenerImpl base class
   // **************************************************************************
   //! result on the tunerDAB_ServiceID_Set call.
   virtual void vOnTunerDABServiceID_Set ( tDiaResult success );

   // **************************************************************************
   // overloaded methods from dia_IAudioSourceListenerImpl base class
   // **************************************************************************
   //! incorrect result on the setTunerSource call.
   virtual void vOnAudioConnectionFailure ( tDiaResult errInfo );
   //! correct result on the setTunerSource call.
   virtual void vOnAudioSourceConnectionDone( tDiaResult res );

   // **************************************************************************
   // overloaded methods from dia_IAudioSourceListenerImpl base class
   // **************************************************************************
   //! notification from dia::AudioManagerClient about the result of the audio source switch request
   virtual void onAudioSourceSetResult ( dia_eAudioSource sourceID, tDiaResult resultCode );
   //! notification from dia::AudioManagerClient about the result of get for the current audio source
   virtual void onAudioSourceGetResult ( dia_eAudioSource sourceID );

protected:
   // **************************************************************************
   // overloaded methods from dia_ITimerListener base class
   // **************************************************************************
   virtual void vOnTimerElapsed ( dia_TimerID id );

private:
   //vector of function pointers with one parameter.
   std::vector< std::pair <FP,tU32/*function parameter*/> > performActions;

   //! function to set the active AM/FM tuner
   tDiaResult setTunerToActive( tU32 /*dia_eTuner*/ newTuner);
   //! set AM/FM frequency at tuner (frequency value in Hz)
   tDiaResult setTunerFrequencyAMFM(tU32 newFrequencyHz);
   //! function to handle DAB frequency value merge and send to tuner
   tDiaResult setTunerFrequencyDAB(tU32 serviceID);
   //! return true if DAB is active (reads respective KDS property (SYSTEM_INFO_COMMON) and decides if DAB is in current device active or not).
   bool isDabActive() const;
   //! set current active source to force HMI to switch to it.
   tDiaResult setTunerSource(tU32 /*dia_eAudioSource*/ newSource);
   //! send next request, check if queue is empty.
   JobReturnCode doNextJob();

   //! frequency of AM/FM tuner from diagnosis request
   tU32 mFreqAMFM;
   //! frequency of DAB tuner from diagnosis request
   tU32 mFreqDAB;
   //! requested source id
   dia_eAudioSource mRequestedSourceID;
   //! type of tuner from diagnosis request
   TunerType mTunerType;
   //! is CN at the beginning?
   bool mIsCN;
   //! true if system remote control is active without HMI.
   bool mIsSystemRemoteActiveWithoutHMI;
   //! timer used for System Remote Control deactivation (e.g. 20 seconds)
   dia_Timer mTimer;
   //! duration of Remote System Control (in milliseconds)
   tU32 mDurationSystemRemoteControlInMSeconds;
   //! Original source ID (for restoring)
   dia_eAudioSource mOrigSourceID;
   //! true if Source ID needs to be restored
   bool mIsSourceRestoring;

protected:
   //! handler for "Return control to ECU"
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );
   //! set tuner (shall be called if System Remote Control is enabled)
   virtual tDiaResult setTuner ( void );
   //! activate Remote Control without HMI (confirmation call in vOnRemoteControlModeChanged)
   virtual tDiaResult activateRemoteControl ( void );
   //! deactivate Remote Control without HMI (confirmation call in vOnRemoteControlModeChanged)
   virtual tDiaResult deactivateRemoteControl ( void );
   //! start timer for System Remote Control deactivation.
   virtual void startTimer();
   //! stop timer for System Remote Control deactivation.
   virtual void stopTimer();
};


#endif /* dia_IOCtrl_TUNERSETTINGS_H_ */
