/*
 * dia_IOCtrlSystemAmpOnOutput.cpp
 *
 *  Created on: 04.09.2015
 *      Author: sbr5kor
//TTFis:> DIA_REQ UDS 07 2F 90 09 03 01
 *                                  (01..FF) -> System / Amp on output on
 *                                  (00)     -> System / Amp on output off
 *      --------------------------------------------------------------------------------------
 *      Date        Author	    Modification
 *
 *      08.01.2016	bsu9kor		Fixed return control to ECU Bug. (NCG3D-6388)
 *
 *      ---------------------------------------------------------------------------------------
 */

#include "project/services/customer/dia_IOCtrlSystemAmpOnOutput.h"
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

#define CTRL_VALUE_SIZE 1
#define DATA_LENGTH 3

#define ACTIVATE_SYSTEM_AMP_ON_OUTPUT   0x01
#define DEACTIVATE_SYSTEM_AMP_ON_OUTPUT 0x00

#define DIA_PROP_GPIO_SYSTEM_AMP_ON_OUTPUT_SIZE 0x01
//------------------------------------------------------------------------------

dia_IOCtrlSystemAmpOnOutput::dia_IOCtrlSystemAmpOnOutput ( void )
   : dia_IOCtrlSignal (
		 "dia_IOCtrlSystemAmpOnOutput",
		 DIA_C_U16_DID_AIVI_SYSTEM_AMP_ON_OUTPUT,
		 CTRL_VALUE_SIZE, // Length in Byte
         DIA_EN_IOCTRL_CTRLMODE_TESTER, // No freeze is necessary ; Tester is responsible for preconditions
         DIA_EN_IOCTRL_MONITORING_MODE_SHORT_TERM_ADJUSTMENT
        )
{
}
//------------------------------------------------------------------------------

dia_IOCtrlSystemAmpOnOutput::~dia_IOCtrlSystemAmpOnOutput ( void )
{
}
//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlSystemAmpOnOutput::handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlSystemAmpOnOutput::handleRequest()");
   tU8 ampOnOutputValue = DEACTIVATE_SYSTEM_AMP_ON_OUTPUT;
   tDiaResult retCode = DIA_SUCCESS;

   DIA_TR_INF("dia_IOCtrlSystemAmpOnOutput::handleRequest ctrlValue->size() = %d .", ctrlValue->size());

   switch(ctrlValue->at(0)){
      case 0x00:
    	  ampOnOutputValue = DEACTIVATE_SYSTEM_AMP_ON_OUTPUT;
         DIA_TR_INF("dia_IOCtrlRearCameraActivation::handleRequest DEACTIVATE System Amp On Output 0x%02x.", ctrlValue->at(0));
         break;
      default:
    	  DIA_TR_INF("dia_IOCtrlRearCameraActivation::handleRequest ACTIVATE System Amp On Output 0x%02x !", ctrlValue->at(0));
         ampOnOutputValue = ACTIVATE_SYSTEM_AMP_ON_OUTPUT;
         break;
   }
   // now initialize the counter for the timer
   vSetTimer(timerValue); //IVI specific
   mIsResultReady = FALSE;

   // write System Amp On Output
   if (controlSystemAmpOnOutput (ampOnOutputValue) == DIA_SUCCESS)
   {
	   mIsResultReady = TRUE;
	   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
   }
   else
   {
	   retCode = DIA_FAILED;
   }

   // NO_ERROR allows the service handler to return immediately
   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlSystemAmpOnOutput::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlSystemAmpOnOutput::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;

   if ( eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE )
   {
      if ( (status == DIA_EN_IOCTRL_STATUS_INACTIVE) || (status == DIA_EN_IOCTRL_STATUS_INACTIVE_TIMEOUT))
      {
         // we have to wait for the response
         mIsResultReady = FALSE;
         status = DIA_EN_IOCTRL_STATUS_INACTIVE;
      }
      // write System Amp On Output
      if (controlSystemAmpOnOutput (DEACTIVATE_SYSTEM_AMP_ON_OUTPUT) == DIA_SUCCESS)
      {
    	  mIsResultReady = TRUE;
    	  DIA_TR_INF("dia_IOCtrlSystemAmpOnOutput::vOnTerminate(): ABLE TO WRITE GPIO data");
      }
      else
      {
    	  DIA_TR_INF("dia_IOCtrlSystemAmpOnOutput::vOnTerminate(): UNABLE TO WRITE GPIO data");
      }

   }
   // this ioctrl is controlled by the external tester
   eSetMode(DIA_EN_IOCTRL_CTRLMODE_ECU);

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}
//-----------------------------------------------------------------------------

void
dia_IOCtrlSystemAmpOnOutput::handleTimeout ( void )
{
   dia_tclFnctTrace trc("dia_IOCtrlSystemAmpOnOutput::handleTimeout");
}
//-----------------------------------------------------------------------------

tDiaResult
dia_IOCtrlSystemAmpOnOutput::controlSystemAmpOnOutput ( const tU8 ctrlValue ) const
{
   dia_tclFnctTrace trc("dia_IOCtrlSystemAmpOnOutput::controlSystemAmpOnOutput");

   tDiaResult retCode = DIA_SUCCESS;

   tU16 size = dia_getPropertySize(DIA_PROP_GPIO_SYSTEM_AMP_ON_OUTPUT);
   tU8 data[DIA_PROP_GPIO_SYSTEM_AMP_ON_OUTPUT_SIZE] = {0};

   data[0] = ctrlValue;

   // write System Amp On Output
   if (DIA_SUCCESS != dia_setProperty(DIA_PROP_GPIO_SYSTEM_AMP_ON_OUTPUT, data, size))
   {
	   retCode = DIA_FAILED;
	   DIA_TR_INF("dia_IOCtrlSystemAmpOnOutput::controlSystemAmpOnOutput(): UNABLE TO WRITE GPIO data");
   }
   return retCode;
}
