/*
 * dia_IOCtrlSpeakerTest.cpp
 *
 *  Created on: 09.09.2015
 *      Author: shw2abt
 */
//TTFis:> DIA_REQ UDS 07 2F 90 0B 03 00/01-FF

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_IOCTRL_TIMER__
#include <common/framework/protocols/uds/ioctrl/dia_IOCtrlTimer.h>
#endif

#ifndef __INCLUDED_DIA_RANDOM_GENERATOR__
#include <common/framework/utils/dia_RandomGenerator.h>
#endif

#include "project/services/customer/dia_IOCtrlSpeakerTest.h"
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

//#define DATA_START 3
#define DATA_LENGTH 1

//------------------------------------------------------------------------------

dia_IOCtrlSpeakerTest::dia_IOCtrlSpeakerTest(void) :
      dia_IOCtrlSignal("dia_IOCtrlSpeakerTest",
            DIA_C_U16_DID_AIVI_SPEAKER_TEST,
            DATA_LENGTH, // Length in Byte
            DIA_EN_IOCTRL_CTRLMODE_TESTER, // No freeze is necessary ; Tester is responsible for preconditions
            DIA_EN_IOCTRL_MONITORING_MODE_SHORT_TERM_ADJUSTMENT
            ),
            mLastAudioMode(DIA_EN_AUDIO_TEST_MODE_UNKNOWN)
{
   mTimer.s32Create();
}

//------------------------------------------------------------------------------

dia_IOCtrlSpeakerTest::~dia_IOCtrlSpeakerTest ( void )
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_IAudioTestListener>(this);
      mTimer.s32Delete();
      mTimer.removeTimerListener(this);
   }
   _BP_CATCH_ALL
   {
       DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlSpeakerTest::~dia_IOCtrlSpeakerTest !!!");
       DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END

}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlSpeakerTest::handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlSpeakerTest::handleRequest()");
   tBool errorDetected = TRUE;

   mLastAudioMode = DIA_EN_AUDIO_TEST_MODE_UNKNOWN;

   if ((ctrlValue->size()>0) && (ctrlValue->at(0)==0x00))
   {
      /*OFF*/
      DIA_TR_INF("dia_IOCtrlTweeterTest::handleRequest Set audio mode to OFF.");
      mLastAudioMode = DIA_EN_AUDIO_TEST_MODE_OFF;
   }
   else
   {
      /* ON */
      DIA_TR_INF("dia_IOCtrlTweeterTest::handleRequest Set audio mode to ON .");
      mLastAudioMode = DIA_EN_AUDIO_TEST_MODE_ON;
   }

   dia_IAudioTest* pInterface = 0;
   if (querySysAdapterInterface < dia_IAudioTest > (&pInterface) == DIA_SUCCESS)
   {
      if (pInterface)
      {
         (void) setSysAdapterListener < dia_IAudioTestListener > (this);
         if (pInterface->startLoudspeakerTest(mLastAudioMode) == DIA_SUCCESS)
         {
            errorDetected = FALSE;
         }
         else
         {
            DIA_TR_INF("dia_IOCtrlSpeakerTest::handleRequest startLoudspeakerTest failed .");
         }
      }
      else
      {
         DIA_TR_INF("dia_IOCtrlSpeakerTest::handleRequest pInterface failed .");
      }
   }
   else
   {
      DIA_TR_INF("dia_IOCtrlSpeakerTest::handleRequest querySysAdapterInterface failed .");
   }

   if (errorDetected)
   {
      (void) unsetSysAdapterListener < dia_IAudioTestListener > (this);
      DIA_TR_ERR("dia_IOCtrlSpeakerTest --- SEND TO AUDIO TEST CONTROL SERVER FAILED !!!");
      return DIA_FAILED;
   }

   DIA_TR_INF("dia_IOCtrlSpeakerTest::handleRequest timerValue=%d.", timerValue);

   // now initialize the counter for the timer
   vSetTimer(timerValue); //IVI specific

   mIsResultReady = FALSE;

   tU32 tm = sProcessingTimeoutMs + (getInstanceOfRandomGenerator()->getRandomNumber() % 1000);
   DIA_TR_INF("dia_IOCtrlSpeakerTest::handleRequest tm %d ms.", tm);

   if (DIA_EN_AUDIO_TEST_MODE_ON==mLastAudioMode)
   {
      DIA_TR_INF("dia_IOCtrlTweeterTest::handleRequest Start Timer.");
      mTimer.addTimerListener(this);
      mTimer.s32SetTime(tm, 0);
   }

   DIA_TR_INF("dia_IOCtrlSpeakerTest::handleRequest ctrlValue size is %d.", ctrlValue->size());
   for (tU8 i=0; i<ctrlValue->size(); i++)
   {
      DIA_TR_INF("dia_IOCtrlSpeakerTest::handleRequest ctrlValue[%d] 0x%02X.", i, ctrlValue->at(i));
   }

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlSpeakerTest::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlSpeakerTest::vOnTerminate()");
   tDiaResult retCode = DIA_E_NOERROR;

   DIA_TR_INF("dia_IOCtrlSpeakerTest::vOnTerminate status=%d.", status);

   mLastAudioMode = DIA_EN_AUDIO_TEST_MODE_OFF;

   if (eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE)
   {
      if ((status == DIA_EN_IOCTRL_STATUS_INACTIVE) || (status == DIA_EN_IOCTRL_STATUS_INACTIVE_TIMEOUT))
      {
         // we have to wait for the response
         mIsResultReady = FALSE;
         status = DIA_EN_IOCTRL_STATUS_INACTIVE;

         DIA_TR_INF("dia_IOCtrlSpeakerTest::vOnTerminate status = DIA_EN_IOCTRL_STATUS_INACTIVE.");
      }

      dia_IAudioTest* pInterface = 0;
      if (querySysAdapterInterface < dia_IAudioTest > (&pInterface) == DIA_SUCCESS)
      {
         if (pInterface)
         {
            (void) setSysAdapterListener < dia_IAudioTestListener > (this);
            if (pInterface->startLoudspeakerTest(mLastAudioMode) != DIA_SUCCESS)
            {
               DIA_TR_INF("dia_IOCtrlSpeakerTest::vOnTerminate FAILED TO DEACTIVATE SPEAKER TEST !");
            }
         }
      }
   }

   // this ioctrl is controlled by the external tester
   eSetMode(DIA_EN_IOCTRL_CTRLMODE_ECU);

   // this ioctrl is no longer active
   eSetStatus(status);

   mTimer.s32SetTime(0,0);
   mTimer.removeTimerListener(this);

   return retCode;
}

//------------------------------------------------------------------------------

void
dia_IOCtrlSpeakerTest::vOnLoudspeakerTest ( tDiaResult success )
{
   dia_tclFnctTrace trc("dia_IOCtrlSpeakerTest::vOnLoudspeakerTest");

   switch (success)
   {
      case DIA_SUCCESS:
      {
         DIA_TR_INF("dia_IOCtrlSpeakerTest::vOnLoudspeakerTest SUCCESS.");
         (void) unsetSysAdapterListener<dia_IAudioTestListener>(this);
         mIsResultReady = TRUE;

         //Wait for Timer, then generate response in case of MODE_ON
         if (DIA_EN_AUDIO_TEST_MODE_ON!=mLastAudioMode)
         {
            DIA_TR_INF("dia_IOCtrlSpeakerTest::vOnLoudspeakerTest SUCCESS.");
            dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
         }
      }
      break;

      case DIA_E_ERROR:
      {
         //stop timer
         mTimer.s32SetTime(0,0);
         mTimer.removeTimerListener(this);

         DIA_TR_ERR("dia_IOCtrlSpeakerTest::vOnLoudspeakerTest ERROR CASE !");
         (void) unsetSysAdapterListener<dia_IAudioTestListener>(this);
         mIsResultReady = TRUE;
         mErrorInfo = DIA_E_ERROR;
         dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
      }
      break;

      default:
      {
         //stop timer
         mTimer.s32SetTime(0,0);
         mTimer.removeTimerListener(this);

         DIA_TR_ERR("dia_IOCtrlSpeakerTest::vOnLoudspeakerTest Start/Stop of Speaker Test failed !!!");
         (void) unsetSysAdapterListener<dia_IAudioTestListener>(this);
         mIsResultReady = TRUE;
         mErrorInfo = DIA_E_ERROR;
         dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
      }
      break;
   }
}

//-----------------------------------------------------------------------------

void
dia_IOCtrlSpeakerTest::handleTimeout ( void )
{
   dia_tclFnctTrace trc("dia_IOCtrlSpeakerTest::handleTimeout");
   (void) unsetSysAdapterListener<dia_IAudioTestListener>(this);

   mTimer.s32SetTime(0,0);
   mTimer.removeTimerListener(this);
}

//-------------------------------------------------------------------------

void
dia_IOCtrlSpeakerTest::vOnTimerElapsed ( dia_TimerID /*id*/ )
{
   dia_tclFnctTrace trc("dia_IOCtrlSpeakerTest::vOnTimerElapsed");

   tDiaResult removeResult;

   mTimer.s32SetTime(0,0);
   removeResult = mTimer.removeTimerListener(this);
   if (DIA_SUCCESS!=removeResult)
   {
      DIA_TR_ERR("dia_IOCtrlSpeakerTest::vOnTimerElapsed removeResult=0x%08X removeTimerListener.", removeResult);
   }

   removeResult = dia_IOCtrlTimer::getInstance()->removeTimerClient(this);
   if (DIA_SUCCESS!=removeResult)
   {
      DIA_TR_ERR("dia_IOCtrlSpeakerTest::vOnTimerElapsed removeResult=0x%08X removeTimerClient.", removeResult);
   }

   std::vector<tU8>& v = (std::vector<tU8>&)getControlValue();

   for (tU8 i=0; i<v.size(); i++)
   {
      DIA_TR_INF("dia_IOCtrlSpeakerTest::vOnTimerElapsed ctrlValue[%d] 0x%02X.", i, v.at(i));
   }

   v.pop_back();
   v.push_back(0x00);

   for (tU8 i=0; i<v.size(); i++)
   {
      DIA_TR_INF("dia_IOCtrlSpeakerTest::vOnTimerElapsed ctrlValue[%d] 0x%02X.", i, v.at(i));
   }

   //send positive response
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}
