/*
 * dia_IOCtrlResetTouchCtrlExtDisplay.h
 *
 *  Created on:
 *      Author: abe6kor
 */

#ifndef DIA_IOCTRL_RESET_TOUCH_CTRL_EXT_DISPLAY_H_
#define DIA_IOCTRL_RESET_TOUCH_CTRL_EXT_DISPLAY_H_

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_RESET_TOUCHCNTL_EXTDISPLAY_LISTENER__
#include "project/interfaces/dia_IResetTouchCntlExtDisplayListener.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

class dia_IOCtrlResetTouchCtrlExtDisplay
   :  public dia_IOCtrlSignal,
      public dia_IResetTouchCntlExtDisplayListenerImpl
{
public:
   //! class constructor
   dia_IOCtrlResetTouchCtrlExtDisplay ( void );
   //! class destructor
   virtual ~dia_IOCtrlResetTouchCtrlExtDisplay ( void );
   //! short term adjustment
   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );

   //!Handle Timeout
   virtual void handleTimeout ( void );
   //! Signal to inform requester about success of the setResetTouchCntlExtDisplay change request
   virtual void vOnResetTouchController(tDiaResult success);

protected:
   //! deactivate IoControl
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );
   bool mbExtDisplay;

};


#endif /* DIA_IOCTRL_RESET_TOUCH_CTRL_EXT_DISPLAY_H_ */
