/*
 * dia_IOCtrlResetTouchCtrlExtDisplay.cpp
 *
 *  Created on:
 *      Author: abe6kor
 //TTFis:> DIA_REQ UDS 07 2F 90 10 03 FF
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "project/services/customer/dia_IOCtrlResetTouchCtrlExtDisplay.h"

#ifndef __INCLUDED_DIA_SRVHANDLER_GENERIC_IOCTRL_BY_IDENTIFIER__
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#define CTRL_VALUE_SIZE 1
#define DATA_LENGTH 3
#define EXT_DISPLAYS 0xFF

//------------------------------------------------------------------------------

dia_IOCtrlResetTouchCtrlExtDisplay::dia_IOCtrlResetTouchCtrlExtDisplay ( void )
   : dia_IOCtrlSignal (
		 "dia_IOCtrlResetTouchCtrlExtDisplay",
		 DIA_C_U16_DID_AIVI_RESET_TOUCH_CTRL_EXT_DISPLAY,
		 CTRL_VALUE_SIZE, // Length in Byte
         DIA_EN_IOCTRL_CTRLMODE_TESTER, // No freeze is necessary ; Tester is responsible for preconditions
         DIA_EN_IOCTRL_MONITORING_MODE_SHORT_TERM_ADJUSTMENT
        ),
     mbExtDisplay(false) /* CID - 91090 Fix */
{
}

//------------------------------------------------------------------------------

dia_IOCtrlResetTouchCtrlExtDisplay::~dia_IOCtrlResetTouchCtrlExtDisplay ( void )
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_IResetTouchCntlExtDisplayListener>(this);
   }
   _BP_CATCH_ALL
   {
       DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlResetTouchCtrlExtDisplay::~dia_IOCtrlResetTouchCtrlExtDisplay !!!");
       DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlResetTouchCtrlExtDisplay::handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue )
{
	dia_tclFnctTrace oTrace("dia_IOCtrlResetTouchCtrlExtDisplay::handleRequest()");
	tBool errorDetected = TRUE;

	if (dia_getPropertySize(DIA_PROP_AIVI_VARIANT_CODING) == DIA_AIVI_VARIANT_CODING_LENGTH)
	{
		tU8 aiviVariantCoding[DIA_AIVI_VARIANT_CODING_LENGTH] = { 0 };
		tDiaResult getPropRes = dia_getProperty(DIA_PROP_AIVI_VARIANT_CODING, aiviVariantCoding, DIA_AIVI_VARIANT_CODING_LENGTH);
		for(tU8 i =0; i<DIA_AIVI_VARIANT_CODING_LENGTH ;i++)
		{
		DIA_TR_INF("aiviVariantCoding[%d] = %x",i,aiviVariantCoding[i]);
		}

		if (getPropRes == DIA_SUCCESS)
		{
			//Check DisplayOutput
			mbExtDisplay = ((aiviVariantCoding[1] & (1 << 0)) == 1)? TRUE: FALSE;
		}
	}

	if(mbExtDisplay)
	{
		dia_IResetTouchCntlExtDisplay* pInterface = NULL;
		if (querySysAdapterInterface < dia_IResetTouchCntlExtDisplay > (&pInterface) == DIA_SUCCESS) {
			if (pInterface) {
				(void) setSysAdapterListener < dia_IResetTouchCntlExtDisplayListener > (this);
				tU8 extDisplay = EXT_DISPLAYS; // All ExternalDisplays
				tU8 input_mode = ctrlValue->at(0);
				DIA_TR_INF("dia_IOCtrlResetTouchCtrlExtDisplay::handleRequest input_mode = 0x%02x", input_mode);

				dia_eResetTouchCntlExtDisplay mode = DIA_EN_RESETTOUCHCNTLEXTDISPLAY_UNKNOWN;

				if(input_mode==0x00){
					mode = DIA_EN_RESETTOUCHCNTLEXTDISPLAY_OFF;
					DIA_TR_INF("dia_IOCtrlResetTouchCtrlExtDisplay::handleRequest mode = DIA_EN_ResetTouchCntlExtDisplay_OFF.");
				} else {
					mode = DIA_EN_RESETTOUCHCNTLEXTDISPLAY_ON;
					DIA_TR_INF("dia_IOCtrlResetTouchCtrlExtDisplay::handleRequest mode = DIA_EN_ResetTouchCntlExtDisplay_ON.");
				}

				if ( pInterface->setResetTouchCntlExtDisplay(extDisplay,mode) == DIA_SUCCESS )
				{
					errorDetected = FALSE;
				}
			}
		}
	}
	else
	{
		DIA_TR_ERR("dia_IOCtrlResetTouchCtrlExtDisplay::handleRequest --- No External Display !!!");
		return DIA_FAILED;
	}
	if (errorDetected) {
		(void) unsetSysAdapterListener < dia_IResetTouchCntlExtDisplayListener > (this);
		DIA_TR_ERR("dia_IOCtrlResetTouchCtrlExtDisplay::handleRequest --- SEND RVC CONTROL FAILED !!!");
		return DIA_FAILED;
	}


	// now initialize the counter for the timer
	vSetTimer(timerValue); //IVI specific

	mIsResultReady = FALSE;

	// NO_ERROR allows the service handler to return immediately
	return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlResetTouchCtrlExtDisplay::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlResetTouchCtrlExtDisplay::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;


   // we must not wait for a response
   mIsResultReady = TRUE;

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}
//-----------------------------------------------------------------------------
void
dia_IOCtrlResetTouchCtrlExtDisplay::vOnResetTouchController ( tDiaResult success )
{
   dia_tclFnctTrace trc("dia_IOCtrlResetTouchCtrlExtDisplay::vOnResetTouchController");

   (tVoid) unsetSysAdapterListener<dia_IResetTouchCntlExtDisplayListener>(this);
   mIsResultReady = TRUE;
   if (success == DIA_SUCCESS) {
      DIA_TR_INF("dia_IOCtrlResetTouchCtrlExtDisplay::vOnResetTouchController SUCCESSFUL !!!");
   } else {
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT); // set error condition which is checked by the super class
      DIA_TR_ERR("dia_IOCtrlResetTouchCtrlExtDisplay::vOnResetTouchController DIA_FAILED !!!");
   }

   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

//-----------------------------------------------------------------------------
void
dia_IOCtrlResetTouchCtrlExtDisplay::handleTimeout ( void )
{
   dia_tclFnctTrace trc("dia_IOCtrlResetTouchCtrlExtDisplay::handleTimeout");
   (void) unsetSysAdapterListener<dia_IResetTouchCntlExtDisplayListener>(this);
}
