/*
 * dia_IOCtrlRearCameraActivation.h
 *
 *  Created on: 02.09.2015
 *      Author: sbr5kor
 */

#ifndef DIA_IOCTRL_REAR_CAMERA_ACTIVATION_H_
#define DIA_IOCTRL_REAR_CAMERA_ACTIVATION_H_

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_RVCCONTROL_LISTENER__
#include "common/interfaces/dia_IRVCControlListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_VIDEOSOURCE_LISTENER__
#include "common/interfaces/dia_IVideoSourceListener.h"
#endif

class dia_IOCtrlRearCameraActivation
   :  public dia_IOCtrlSignal,
   	  public dia_IVideoSourceListenerImpl
{
public:
   //! class constructor
   dia_IOCtrlRearCameraActivation ( void );
   //! class destructor
   virtual ~dia_IOCtrlRearCameraActivation ( void );

   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );

   //!
   virtual void handleTimeout ( void );

   //!
   virtual bool isFrozen ( void ) const {return true;}

   //! Signal to inform requester about success of the active RVC Display selection
    virtual void vOnRVCDisplay ( tDiaResult success );

protected:
   //! deactivate the rear camera
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );
   //! Set RVC Display information
     tDiaResult activateRVCDisplay ( const dia_VideoSrcInfo& rVideoInfo ) const;

};


#endif /* DIA_IOCTRL_REAR_CAMERA_ACTIVATION_H_ */
