/*
 * dia_IOCtrlRearCameraActivation.cpp
 *
 *  Created on: 02.09.2015
 *      Author: sbr5kor
//TTFis:> DIA_REQ UDS 07 2F 90 06 03 01
 *                                  (01..FF) -> activate RVC
 *                                  (00)     -> deactivate RVC
 *  ---------------------------------------------------------------------------------------------------
 *  Date 			Author			Modification
 *  19.01.2016		bsu9kor			Added function activateRVCDisplay(NCG3D 7515)
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef DIA_IOCTRL_REAR_CAMERA_ACTIVATION_H_
#include "project/services/customer/dia_IOCtrlRearCameraActivation.h"
#endif
#ifndef __INCLUDED_DIA_SRVHANDLER_GENERIC_IOCTRL_BY_IDENTIFIER__
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"
#endif

#define CTRL_VALUE_SIZE 1
#define DATA_LENGTH 3

//------------------------------------------------------------------------------

dia_IOCtrlRearCameraActivation::dia_IOCtrlRearCameraActivation ( void )
   : dia_IOCtrlSignal (
		 "dia_IOCtrlRearCameraActivation",
		 DIA_C_U16_DID_AIVI_REAR_CAMERA_ACTIVATION,
		 CTRL_VALUE_SIZE, // Length in Byte
         DIA_EN_IOCTRL_CTRLMODE_TESTER, // No freeze is necessary ; Tester is responsible for preconditions
         DIA_EN_IOCTRL_MONITORING_MODE_SHORT_TERM_ADJUSTMENT
        )
{
}

//------------------------------------------------------------------------------

dia_IOCtrlRearCameraActivation::~dia_IOCtrlRearCameraActivation ( void )
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_IVideoSourceListener>(this);
   }
   _BP_CATCH_ALL
   {
       DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlRearCameraActivation::~dia_IOCtrlRearCameraActivation !!!");
       DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlRearCameraActivation::handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlRearCameraActivation::handleRequest()");
   tBool errorDetected = TRUE;

	         for(tU8 i=0; i<ctrlValue->size(); i++){
	           DIA_TR_INF("dia_IOCtrlRearCameraActivation::handleRequest ctrlValue->at(%d)=0x%02x", i, ctrlValue->at(i) );
	         }

	         dia_VideoSrcInfo videoSrcInfo(DIA_EN_VIDEOSRC_UNKNOWN,DIA_EN_VIDEONORM_UNKNOWN);
	         if(ctrlValue->at(0) == 0x00        /*normal hmi*/){
	            videoSrcInfo.videoSrc = DIA_EN_VIDEOSRC_INT;
	         } else /*0x00 to 0xff rear view camera*/{
	            videoSrcInfo.videoSrc = DIA_EN_VIDEOSRC_EXT;
	         } /*else {
	#ifndef __DIA_UNIT_TESTING__
	            DIA_TR_ERR("dia_IOCtrlRearCameraActivation::handleRequest - UNKNOWN PAYLOAD BYTE 0x%02x !!!!", ctrlValue->at(0) );
	#endif
	            return DIA_FAILED;
	         }*/
	#ifndef __DIA_UNIT_TESTING__
	         DIA_TR_INF("dia_IOCtrlRearCameraActivation::handleRequest - activeVideoSource: 0x%02x Norm 0x%02x.", videoSrcInfo.videoSrc, videoSrcInfo.videoNorm);
	#endif
	         (void) setSysAdapterListener<dia_IVideoSourceListener>(this);
	         if ( activateRVCDisplay(videoSrcInfo) == DIA_SUCCESS )
	         {
	             DIA_TR_INF("dia_IOCtrlRearCameraActivation::handleRequest - setRVCDisplay SUCCESSFUL");
	             errorDetected = FALSE;
	         }
	         else
	         {
	             DIA_TR_INF("dia_IOCtrlRearCameraActivation::handleRequest - setRVCDisplay FAILED");
	         }

	   if ( errorDetected )
	   {
	      (void) unsetSysAdapterListener<dia_IVideoSourceListener>(this);
	      DIA_TR_ERR(" ---  SEND TO VIDEOSOURCE SERVER FAILED!!!!");
	      return DIA_FAILED;
	   }

   // now initialize the counter for the timer
   vSetTimer(timerValue); //IVI specific

   mIsResultReady = FALSE;

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlRearCameraActivation::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlRearCameraActivation::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;

   if ( eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE )
   {
      if ( (status == DIA_EN_IOCTRL_STATUS_INACTIVE) || (status == DIA_EN_IOCTRL_STATUS_INACTIVE_TIMEOUT))
      {
         // we have to wait for the response
         mIsResultReady = FALSE;
         status = DIA_EN_IOCTRL_STATUS_INACTIVE;
      }

      dia_VideoSrcInfo videoSrcInfo(DIA_EN_VIDEOSRC_INT,DIA_EN_VIDEONORM_UNKNOWN);
      if ( activateRVCDisplay(videoSrcInfo) == DIA_SUCCESS )
      {
    	  mIsResultReady = TRUE;
    	  DIA_TR_INF("dia_IOCtrlRearCameraActivation::vOnTerminate SUCCESSFUL !!!");
      }
      else
      {
    	  DIA_TR_INF("dia_IOCtrlRearCameraActivation::vOnTerminate FAILED !!!");
      }
   }

   // this ioctrl is controlled by the external tester
   eSetMode(DIA_EN_IOCTRL_CTRLMODE_ECU);

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}

//------------------------------------------------------------------------------

void
dia_IOCtrlRearCameraActivation::vOnRVCDisplay ( tDiaResult success )
{
   dia_tclFnctTrace trc("dia_IOCtrlRearCameraActivation::vOnRVCDisplay");

   (void) unsetSysAdapterListener<dia_IVideoSourceListener>(this);
   mIsResultReady = TRUE;
   if( success == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_IOCtrlRearCameraActivation::vOnRVCDisplay SUCCESSFUL !!!");
   } else {
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
      DIA_TR_ERR("dia_IOCtrlRearCameraActivation::vOnRVCDisplay DIA_FAILED !!!");
   }
   
	#ifndef __DIA_UNIT_TESTING__
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
	#endif
}
//-----------------------------------------------------------------------------

/******************************************************************************
* FUNCTION:    activateRVCDisplay
*
* DESCRIPTION: Calls the system adapter functinality to activate the requested video source
*
* PARAMETER:   const dia_VideoSrcInfo& rVideoInfo - structure containing the videosource type and mode
*
* RETURNVALUE: SUCCESSFUL  - video source successfully activated
*              FALSE - video source activation failed
*
******************************************************************************/
tDiaResult
dia_IOCtrlRearCameraActivation::activateRVCDisplay ( const dia_VideoSrcInfo& rVideoInfo ) const
{
	tDiaResult retCode = DIA_FAILED;
	   dia_IVideoSource* pInterface = 0;
	   if ( querySysAdapterInterface<dia_IVideoSource>(&pInterface) == DIA_SUCCESS )
	   {
	      if ( pInterface )
	      {
	         if ( pInterface->setRVCDisplay(rVideoInfo) == DIA_SUCCESS )
	         {
	            DIA_TR_INF("dia_IOCtrlRearCameraActivation::activateRVCDisplay -  SUCCESSFUL");
	            retCode = DIA_SUCCESS;
	         } else {
	            DIA_TR_INF("dia_IOCtrlRearCameraActivation::activateRVCDisplay -  FAILED");
	         }
	      }
	   }
	   return retCode;
}
//-----------------------------------------------------------------------------

void
dia_IOCtrlRearCameraActivation::handleTimeout ( void )
{
   dia_tclFnctTrace trc("dia_IOCtrlRearCameraActivation::handleTimeout");
   (void) unsetSysAdapterListener<dia_IVideoSourceListener>(this);
}
